/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.annotations.UIRights;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.misc.InternalParentTree;
import to.etc.domui.component.misc.MessageFlare;
import to.etc.domui.component.misc.MsgBox;
import to.etc.domui.dom.HtmlFullRenderer;
import to.etc.domui.dom.PrettyXmlOutputWriter;
import to.etc.domui.dom.errors.IExceptionListener;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.IHasChangeListener;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.OptimalDeltaRenderer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.PagePhase;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.login.ILoginDialogFactory;
import to.etc.domui.login.IUser;
import to.etc.domui.parts.IComponentJsonProvider;
import to.etc.domui.parts.IComponentUrlDataProvider;
import to.etc.domui.server.AppFilter;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.ExceptionUtil;
import to.etc.domui.server.HttpServerRequestResponse;
import to.etc.domui.server.IFilterRequestHandler;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.AppSession;
import to.etc.domui.state.CidPair;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.ConversationDestroyedException;
import to.etc.domui.state.IGotoAction;
import to.etc.domui.state.INotReloadablePage;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.UIContext;
import to.etc.domui.state.UserLogItem;
import to.etc.domui.state.WindowSession;
import to.etc.domui.themes.DefaultThemeVariant;
import to.etc.domui.themes.ThemeManager;
import to.etc.domui.trouble.ClientDisconnectedException;
import to.etc.domui.trouble.ExpiredSessionPage;
import to.etc.domui.trouble.MsgException;
import to.etc.domui.trouble.NotLoggedInException;
import to.etc.domui.trouble.SessionInvalidException;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.INewPageInstantiated;
import to.etc.domui.util.IRebuildOnRefresh;
import to.etc.domui.util.IRightsCheckedManually;
import to.etc.domui.util.Msgs;
import to.etc.template.JSTemplate;
import to.etc.template.JSTemplateCompiler;
import to.etc.util.DeveloperOptions;
import to.etc.util.FileTool;
import to.etc.util.IndentWriter;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.ajax.renderer.json.JSONRegistry;
import to.etc.webapp.ajax.renderer.json.JSONRenderer;
import to.etc.webapp.nls.CodeException;
import to.etc.webapp.query.IQContextContainer;
import to.etc.webapp.query.QContextManager;

public class ApplicationRequestHandler
implements IFilterRequestHandler {
    static Logger LOG = LoggerFactory.getLogger(ApplicationRequestHandler.class);
    @Nonnull
    private final DomApplication m_application;
    private static boolean m_logPerf = DeveloperOptions.getBool((String)"domui.logtime", (boolean)false);
    @Nonnull
    private final JSONRegistry m_jsonRegistry = new JSONRegistry();
    @Nullable
    private JSTemplate m_exceptionTemplate;

    public ApplicationRequestHandler(@Nonnull DomApplication application) {
        this.m_application = application;
    }

    @Override
    public boolean accepts(@Nonnull IRequestContext ctx) throws Exception {
        return this.m_application.getUrlExtension().equals(ctx.getExtension()) || ctx.getExtension().equals("obit") || this.m_application.getRootPage() != null && ctx.getInputPath().length() == 0;
    }

    @Override
    public void handleRequest(@Nonnull RequestContextImpl ctx) throws Exception {
        ctx.getRequestResponse().setNoCache();
        this.handleMain(ctx);
        ctx.getSession().dump();
    }

    private void handleMain(@Nonnull RequestContextImpl ctx) throws Exception {
        Class<? extends UrlPage> runclass = this.decodeRunClass(ctx);
        try {
            this.runClass(ctx, runclass);
        }
        catch (ThingyNotFoundException xxxx) {
            throw xxxx;
        }
        catch (ClientDisconnectedException xxxx) {
            throw xxxx;
        }
        catch (Exception x) {
            this.renderApplicationMail(ctx, x);
            if (!this.m_application.isShowProblemTemplate() && !this.m_application.inDevelopmentMode()) {
                throw x;
            }
            this.tryRenderOopsFrame(ctx, x);
        }
        catch (Error x) {
            this.renderApplicationMail(ctx, x);
            if (!this.m_application.isShowProblemTemplate() && !this.m_application.inDevelopmentMode()) {
                throw x;
            }
            String s = x.getMessage();
            if (s != null && s.contains("compilation") && s.contains("problem")) {
                this.tryRenderOopsFrame(ctx, x);
            }
            throw x;
        }
    }

    private void renderApplicationMail(@Nonnull RequestContextImpl ctx, @Nonnull Throwable x) {
        String s = x.getMessage();
        if (s != null && s.contains("compilation") && s.contains("problem")) {
            return;
        }
        ExceptionUtil util = new ExceptionUtil(ctx);
        util.renderEmail(x);
    }

    private void tryRenderOopsFrame(@Nonnull RequestContextImpl ctx, @Nonnull Throwable x) throws Exception {
        try {
            this.renderOopsFrame(ctx, x);
        }
        catch (Exception oopx) {
            System.out.println("Exception while rendering exception page!!?? " + oopx);
            oopx.printStackTrace();
            if (x instanceof Error) {
                throw (Error)x;
            }
            throw (Exception)x;
        }
    }

    @Nonnull
    private Class<? extends UrlPage> decodeRunClass(@Nonnull IRequestContext ctx) {
        int spos;
        if (ctx.getInputPath().length() == 0) {
            Class<? extends UrlPage> rootPage = this.m_application.getRootPage();
            if (null == rootPage) {
                throw new ProgrammerErrorException("The DomApplication's 'getRootPage()' method returns null, and there is a request for the root of the web app... Override that method or make sure the root is handled differently.");
            }
            String txt = rootPage.getCanonicalName();
            return this.m_application.loadPageClass(txt);
        }
        String s = ctx.getInputPath();
        int pos = s.lastIndexOf(46);
        if (pos != -1 && pos > (spos = s.lastIndexOf(47) + 1)) {
            s = s.substring(spos, pos);
            return this.m_application.loadPageClass(s);
        }
        throw new IllegalStateException("Cannot decode URL " + ctx.getInputPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runClass(@Nonnull RequestContextImpl ctx, @Nonnull Class<? extends UrlPage> clz) throws Exception {
        String s;
        Page page;
        String hpq;
        CidPair cida;
        String action = ctx.getParameter("webuia");
        String cid = ctx.getParameter("$cid");
        CidPair cidPair = cida = cid == null ? null : CidPair.decode(cid);
        if (DomUtil.USERLOG.isDebugEnabled()) {
            DomUtil.USERLOG.debug("\n\n\n========= DomUI request =================\nCID=" + cid + "\nAction=" + action + "\n");
        }
        if (!"pollasy".equals(action)) {
            this.logUser(ctx, cid, clz.getName(), "Incoming request on " + cid + " action=" + action);
        }
        if ("OBITUARY".equals(action)) {
            int pageTag;
            try {
                pageTag = Integer.parseInt(ctx.getParameter("$pt"));
            }
            catch (Exception x) {
                throw new IllegalStateException("Missing or invalid $pt PageTAG in OBITUARY request");
            }
            if (cida == null) {
                throw new IllegalStateException("Missing $cid in OBITUARY request");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("OBITUARY received for " + cid + ": pageTag=" + pageTag);
            }
            ctx.getSession().internalObituaryReceived(cida.getWindowId(), pageTag);
            ctx.getOutputWriter("text/html", "utf-8");
            return;
        }
        WindowSession cm = null;
        if (cida != null) {
            cm = ctx.getSession().findWindowSession(cida.getWindowId());
        }
        if (cm == null) {
            HttpServerRequestResponse srr;
            String newid;
            HttpServerRequestResponse srr2;
            HttpSession hs;
            boolean nonReloadableExpiredDetected = false;
            if (action != null) {
                if (INotReloadablePage.class.isAssignableFrom(clz)) {
                    nonReloadableExpiredDetected = true;
                } else {
                    if (this.m_application.getAutoRefreshPollInterval() <= 0) {
                        String msg = Msgs.BUNDLE.getString("s.session.expired");
                        this.generateExpired(ctx, msg);
                        this.logUser(ctx, cid, clz.getName(), msg);
                    } else {
                        String msg = "Not sending expired message because autorefresh is ON for " + cid;
                        LOG.info(msg);
                        this.logUser(ctx, cid, clz.getName(), msg);
                    }
                    return;
                }
            }
            cm = ctx.getSession().createWindowSession();
            String newmsg = "$cid: input windowid=" + cid + " not found - created wid=" + cm.getWindowID();
            if (LOG.isDebugEnabled()) {
                LOG.debug(newmsg);
            }
            this.logUser(ctx, cid, clz.getName(), newmsg);
            String conversationId = "x";
            if (this.m_application.inDevelopmentMode() && cida != null && ctx.getRequestResponse() instanceof HttpServerRequestResponse && null != (hs = (srr2 = (HttpServerRequestResponse)ctx.getRequestResponse()).getRequest().getSession()) && (newid = cm.internalAttemptReload(hs, clz, PageParameters.createFrom(ctx), cida.getWindowId())) != null) {
                conversationId = newid;
            }
            if (nonReloadableExpiredDetected) {
                this.generateNonReloadableExpired(ctx, cm);
                return;
            }
            PageParameters pp = PageParameters.createFrom(ctx);
            if (ctx.getRequestResponse() instanceof HttpServerRequestResponse && "post".equalsIgnoreCase((srr = (HttpServerRequestResponse)ctx.getRequestResponse()).getRequest().getMethod()) && pp.getDataLength() > 768) {
                this.redirectForPost(ctx, cm, pp);
                return;
            }
            StringBuilder sb = new StringBuilder(256);
            sb.append(ctx.getRelativePath(ctx.getInputPath()));
            sb.append('?');
            StringTool.encodeURLEncoded((Appendable)sb, (String)"$cid");
            sb.append('=');
            sb.append(cm.getWindowID());
            sb.append(".").append(conversationId);
            DomUtil.addUrlParameters(sb, ctx, false);
            ApplicationRequestHandler.generateHttpRedirect(ctx, sb.toString(), "Your session has expired. Starting a new session.");
            String expmsg = "Session " + cid + " has expired - starting a new session by redirecting to " + sb.toString();
            this.logUser(ctx, cid, clz.getName(), expmsg);
            if (DomUtil.USERLOG.isDebugEnabled()) {
                DomUtil.USERLOG.debug(expmsg);
            }
            return;
        }
        if (cida == null) {
            throw new IllegalStateException("Cannot happen: cida is null??");
        }
        if (action != null && cm.isConversationDestroyed(cida.getConversationId())) {
            String msg = "Session " + cid + " was destroyed earlier- assuming this is an out-of-order event and sending empty delta back";
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            this.logUser(ctx, cid, clz.getName(), msg);
            System.out.println(msg);
            this.generateEmptyDelta(ctx);
            return;
        }
        ctx.internalSetWindowSession(cm);
        cm.clearGoto();
        PageParameters papa = null;
        if (action == null && null != (hpq = (papa = PageParameters.createFrom(ctx)).getString("xxxpck", null))) {
            ConversationContext coco = cm.findConversation(cida.getConversationId());
            if (null == coco) {
                throw new IllegalStateException("The conversation " + cida.getConversationId() + " containing POST data is missing in windowSession " + cm);
            }
            papa = (PageParameters)coco.getAttribute("__ORIPP");
            if (null == papa) {
                throw new IllegalStateException("The conversation " + cid + " no (longer) has the post data??");
            }
        }
        if ((page = cm.tryToMakeOrGetPage(ctx, clz, papa, action)) != null) {
            page.internalSetPhase(PagePhase.BUILD);
            page.internalIncrementRequestCounter();
            cm.internalSetLastPage(page);
            if (DomUtil.USERLOG.isDebugEnabled()) {
                DomUtil.USERLOG.debug("Request for page " + page + " in conversation " + cid);
            }
        }
        if (action != null && (s = ctx.getParameter("$pt")) != null) {
            int pt = Integer.parseInt(s);
            if (page == null || pt != page.getPageTag()) {
                if ("pollasy".equals(action)) {
                    this.generateExpiredPollasy(ctx);
                } else {
                    String msg = "Session " + cid + " expired, page will be reloaded (page tag difference) on action=" + action;
                    if (DomUtil.USERLOG.isDebugEnabled()) {
                        DomUtil.USERLOG.debug(msg);
                    }
                    this.logUser(ctx, cid, clz.getName(), msg);
                    if (this.m_application.getAutoRefreshPollInterval() <= 0) {
                        this.generateExpired(ctx, Msgs.BUNDLE.getString("s.session.expired"));
                    } else {
                        msg = "Not sending expired message because autorefresh is ON for " + cid;
                        LOG.info(msg);
                        this.logUser(ctx, cid, clz.getName(), msg);
                    }
                }
                return;
            }
        }
        if (page == null) {
            throw new IllegalStateException("Page can not be null here. Null is already handled inside expired AJAX request handling.");
        }
        UIContext.internalSet(page);
        if (action != null && action.startsWith("#")) {
            this.runComponentAction(ctx, page, action.substring(1));
            return;
        }
        if ("$pagedata".equals(action)) {
            this.runPageData(ctx, page);
            return;
        }
        if ("$pagejson".equals(action)) {
            this.runPageJson(ctx, page);
            return;
        }
        List<NodeBase> pendingChangeList = Collections.EMPTY_LIST;
        if (!"pollasy".equals(action)) {
            long ts = System.nanoTime();
            pendingChangeList = this.handleComponentInput(ctx, page);
            if (LOG.isDebugEnabled()) {
                ts = System.nanoTime() - ts;
                LOG.debug("rq: input handling took " + StringTool.strNanoTime((long)ts));
            }
        }
        if (action != null) {
            this.runAction(ctx, page, action, pendingChangeList);
            return;
        }
        long ts = System.nanoTime();
        try {
            if (DomUtil.USERLOG.isDebugEnabled()) {
                DomUtil.USERLOG.debug(cid + ": Full render of page " + page);
            }
            if (page.getBody() instanceof IRebuildOnRefresh) {
                page.getBody().forceRebuild();
                page.setInjected(false);
                QContextManager.closeSharedContexts((IQContextContainer)page.getConversation());
                if (DomUtil.USERLOG.isDebugEnabled()) {
                    DomUtil.USERLOG.debug(cid + ": IForceRefresh, cleared page data for " + page);
                }
                this.logUser(ctx, cid, clz.getName(), "Full page render with forced refresh");
            } else {
                this.logUser(ctx, cid, clz.getName(), "Full page render");
            }
            if (!page.isInjected()) {
                ctx.getApplication().getInjector().injectPageValues(page.getBody(), DomUtil.nullChecked(papa));
                page.setInjected(true);
            }
            if (!this.checkAccess(cm, ctx, page)) {
                return;
            }
            this.m_application.internalCallPageFullRender(ctx, page);
            page.getBody().onReload();
            page.getConversation().processDelayedResults(page);
            this.callNewPageBuiltListeners(page);
            page.internalFullBuild();
            List ml = (List)cm.getAttribute("uigoto.msgs");
            if (ml != null) {
                if (ml.size() > 0) {
                    page.getBody().build();
                    for (Object m : ml) {
                        if (DomUtil.USERLOG.isDebugEnabled()) {
                            DomUtil.USERLOG.debug(cid + ": page reload message = " + ((UIMessage)m).getMessage());
                        }
                        MessageFlare mf = MessageFlare.display((NodeContainer)page.getBody(), (UIMessage)m);
                        mf.setTestID("SingleShotMsg");
                    }
                }
                cm.setAttribute("uigoto.msgs", null);
            }
            page.callRequestStarted();
            List al = (List)cm.getAttribute("uigoto.action");
            if (al != null && al.size() > 0) {
                page.getBody().build();
                for (IGotoAction ga : al) {
                    if (DomUtil.USERLOG.isDebugEnabled()) {
                        DomUtil.USERLOG.debug(cid + ": page reload action = " + ga);
                    }
                    ga.executeAction(page.getBody());
                }
                cm.setAttribute("uigoto.action", null);
            }
            this.m_application.internalCallPageComplete(ctx, page);
            page.getBody().internalOnBeforeRender();
            page.internalDeltaBuild();
            Writer w = page.isRenderAsXHTML() ? ctx.getOutputWriter("application/xhtml+xml; charset=UTF-8", "utf-8") : ctx.getOutputWriter("text/html; charset=UTF-8", "utf-8");
            PrettyXmlOutputWriter out = new PrettyXmlOutputWriter(w);
            HtmlFullRenderer hr = this.m_application.findRendererFor(ctx.getBrowserVersion(), out);
            hr.render(ctx, page);
            if (cm.handleGoto(ctx, page, false)) {
                return;
            }
        }
        catch (SessionInvalidException x) {
            this.logUser(ctx, cid, clz.getName(), "Session exception: " + x);
            this.renderUserError(ctx, "The session has been invalidated; perhaps you are logged out");
        }
        catch (ConversationDestroyedException x) {
            this.logUser(ctx, cid, clz.getName(), "Conversation exception: " + (Object)((Object)x));
            this.renderUserError(ctx, "Your conversation with the server has been destroyed. Please refresh the page.");
        }
        catch (Exception ex) {
            String url;
            Exception x = WrappedException.unwrap((Exception)ex);
            if (!(x instanceof ValidationException)) {
                this.logUser(ctx, cid, clz.getName(), "Page exception: " + x);
            }
            try {
                page.getBody().forceRebuild();
            }
            catch (ConversationDestroyedException xx) {
                this.logUser(ctx, cid, clz.getName(), "Conversation exception: " + (Object)((Object)xx));
                this.renderUserError(ctx, "Your conversation with the server has been destroyed. Please refresh the page.");
            }
            catch (SessionInvalidException xx) {
                this.logUser(ctx, cid, clz.getName(), "Session exception: " + x);
                this.renderUserError(ctx, "The session has been invalidated; perhaps you have logged out in another window?");
            }
            catch (Exception xxx) {
                System.err.println("Double exception in handling full page build exception");
                System.err.println("Original exception: " + x);
                System.err.println("Second one on forceRebuild: " + xxx);
                x.printStackTrace();
                xxx.printStackTrace();
            }
            page.getBody().forceRebuild();
            if (x instanceof NotLoggedInException && (url = this.m_application.handleNotLoggedInException(ctx, page, (NotLoggedInException)x)) != null) {
                ApplicationRequestHandler.generateHttpRedirect(ctx, url, "You need to be logged in");
                return;
            }
            IExceptionListener xl = ctx.getApplication().findExceptionListenerFor(x);
            if (xl != null && xl.handleException(ctx, page, null, x) && cm.handleExceptionGoto(ctx, page, false)) {
                AppSession aps = ctx.getSession();
                if (aps.incrementExceptionCount() > 10) {
                    aps.clearExceptionRetryCount();
                    throw new RuntimeException("Loop in exception handling in a full page (new page) render", x);
                }
                return;
            }
            this.checkFullExceptionCount(page, x);
        }
        finally {
            page.internalClearDeltaFully();
        }
        page.setFullRenderCompleted(true);
        page.setPageExceptionCount(0);
        ctx.getSession().clearExceptionRetryCount();
        if (m_logPerf) {
            ts = System.nanoTime() - ts;
            System.out.println("domui: full render took " + StringTool.strNanoTime((long)ts));
        }
        page.getConversation().startDelayedExecution();
    }

    private void renderUserError(RequestContextImpl ctx, String s) {
        try {
            ctx.sendError(503, "It appears this session was logged out in mid-flight");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logUser(@Nonnull RequestContextImpl ctx, @Nullable String cid, @Nonnull String pageName, String string) {
        ctx.getSession().log(new UserLogItem(cid, pageName, null, null, string));
    }

    private void logUser(@Nonnull RequestContextImpl ctx, @Nonnull Page page, String string) {
        ConversationContext conversation = page.internalGetConversation();
        String cid = conversation == null ? null : conversation.getFullId();
        ctx.getSession().log(new UserLogItem(cid, page.getBody().getClass().getName(), null, null, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runComponentAction(@Nonnull RequestContextImpl ctx, @Nonnull Page page, @Nonnull String action) throws Exception {
        this.m_application.internalCallPageAction(ctx, page);
        page.callRequestStarted();
        try {
            NodeBase wcomp = null;
            String wid = ctx.getParameter("webuic");
            if (wid != null) {
                wcomp = page.findNodeByID(wid);
            }
            if (wcomp == null) {
                return;
            }
            page.setTheCurrentNode(wcomp);
            wcomp.componentHandleWebDataRequest(ctx, action);
        }
        finally {
            page.callRequestFinished();
            page.setTheCurrentNode(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPageData(@Nonnull RequestContextImpl ctx, @Nonnull Page page) throws Exception {
        this.m_application.internalCallPageAction(ctx, page);
        page.callRequestStarted();
        NodeBase wcomp = null;
        String wid = ctx.getParameter("webuic");
        if (wid != null) {
            wcomp = page.findNodeByID(wid);
        }
        if (wcomp == null) {
            return;
        }
        page.setTheCurrentNode(wcomp);
        try {
            IComponentUrlDataProvider dp = (IComponentUrlDataProvider)((Object)wcomp);
            dp.provideUrlData(ctx);
        }
        finally {
            page.callRequestFinished();
            page.setTheCurrentNode(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPageJson(@Nonnull RequestContextImpl ctx, @Nonnull Page page) throws Exception {
        this.m_application.internalCallPageAction(ctx, page);
        page.callRequestStarted();
        NodeBase wcomp = null;
        String wid = ctx.getParameter("webuic");
        if (wid != null) {
            wcomp = page.findNodeByID(wid);
        }
        if (wcomp == null) {
            return;
        }
        page.setTheCurrentNode(wcomp);
        try {
            if (!(wcomp instanceof IComponentJsonProvider)) {
                throw new ProgrammerErrorException("The component " + wcomp + " must implement " + IComponentJsonProvider.class.getName() + " to be able to accept JSON data requests");
            }
            IComponentJsonProvider dp = (IComponentJsonProvider)((Object)wcomp);
            PageParameters pp = PageParameters.createFrom(ctx);
            Object value = dp.provideJsonData(pp);
            this.renderJsonLikeResponse(ctx, value);
        }
        finally {
            page.callRequestFinished();
            page.setTheCurrentNode(null);
        }
    }

    private void renderJsonLikeResponse(@Nonnull RequestContextImpl ctx, @Nonnull Object value) throws Exception {
        Writer w = ctx.getOutputWriter("application/javascript", "utf-8");
        if (value instanceof String) {
            w.write((String)value);
        } else {
            JSONRenderer jr = new JSONRenderer(this.m_jsonRegistry, new IndentWriter(w), false);
            jr.render(value);
        }
    }

    private void generateNonReloadableExpired(RequestContextImpl ctx, WindowSession cm) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(ExpiredSessionPage.class.getName()).append('.').append(DomApplication.get().getUrlExtension());
        sb.append('?');
        StringTool.encodeURLEncoded((Appendable)sb, (String)"$cid");
        sb.append('=');
        sb.append(cm.getWindowID());
        sb.append(".x");
        ApplicationRequestHandler.generateAjaxRedirect(ctx, sb.toString());
    }

    private void redirectForPost(RequestContextImpl ctx, WindowSession cm, @Nonnull PageParameters pp) throws Exception {
        ConversationContext cc = cm.createConversation(ConversationContext.class);
        cm.acceptNewConversation(cc);
        cc.setAttribute("__ORIPP", pp);
        String hashString = pp.calculateHashString();
        StringBuilder sb = new StringBuilder(256);
        sb.append(ctx.getRelativePath(ctx.getInputPath()));
        sb.append('?');
        StringTool.encodeURLEncoded((Appendable)sb, (String)"$cid");
        sb.append('=');
        sb.append(cm.getWindowID());
        sb.append(".");
        sb.append(cc.getId());
        sb.append("&");
        sb.append("xxxpck").append("=").append(hashString);
        ApplicationRequestHandler.generateHttpRedirect(ctx, sb.toString(), "Your session has expired. Starting a new session.");
    }

    private void checkFullExceptionCount(Page page, Exception x) throws Exception {
        if (!page.isFullRenderCompleted()) {
            throw x;
        }
        page.setPageExceptionCount(page.getPageExceptionCount() + 1);
        if (page.getPageExceptionCount() >= 2) {
            page.getConversation().destroy();
            throw new RuntimeException("The page keeps dying on you.. The page has been destroyed so that a new one will be allocated on the next refresh.", x);
        }
        throw x;
    }

    private boolean checkAccess(WindowSession cm, RequestContextImpl ctx, Page page) throws Exception {
        String rurl;
        String failureReason;
        UIRights rann;
        UrlPage body;
        block14: {
            IRightsCheckedManually rcm;
            if (ctx.getParameter("webuia") != null) {
                throw new IllegalStateException("Cannot be called for an AJAX request");
            }
            body = page.getBody();
            rann = body.getClass().getAnnotation(UIRights.class);
            IRightsCheckedManually iRightsCheckedManually = rcm = body instanceof IRightsCheckedManually ? (IRightsCheckedManually)((Object)body) : null;
            if (rann == null && rcm == null) {
                return true;
            }
            IUser user = UIContext.getCurrentUser();
            if (user == null) {
                this.redirectToLoginPage(cm, ctx);
                return false;
            }
            failureReason = null;
            try {
                boolean allowed;
                if (null != rcm && (allowed = rcm.isAccessAllowedBy(user))) {
                    return true;
                }
                if (null != rann) {
                    if (this.checkRightsAnnotation(ctx, body, rann, user)) {
                        return true;
                    }
                    break block14;
                }
                throw new CodeException(Msgs.BUNDLE, "rights.disallowed", new Object[0]);
            }
            catch (CodeException cx) {
                failureReason = cx.getMessage();
            }
            catch (Exception x) {
                failureReason = x.toString();
            }
        }
        ILoginDialogFactory ldf = this.m_application.getLoginDialogFactory();
        String string = rurl = ldf == null ? null : ldf.getAccessDeniedURL();
        if (rurl == null) {
            rurl = DomApplication.get().getAccessDeniedPageClass().getName() + "." + this.m_application.getUrlExtension();
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append(rurl);
        DomUtil.addUrlParameters(sb, new PageParameters("targetPage", body.getClass().getName()), true);
        if (null != failureReason || rann == null) {
            if (failureReason == null) {
                failureReason = "Empty reason - this should not happen!";
            }
            sb.append("&").append("refusalMsg").append("=");
            StringTool.encodeURLEncoded((Appendable)sb, (String)failureReason);
        } else {
            int ix = 0;
            for (String r : rann.value()) {
                sb.append("&r" + ix + "=");
                ++ix;
                StringTool.encodeURLEncoded((Appendable)sb, (String)r);
            }
        }
        ApplicationRequestHandler.generateHttpRedirect(ctx, sb.toString(), "Access denied");
        this.logUser(ctx, cm.getWindowID(), page.getBody().getClass().getName(), sb.toString());
        return false;
    }

    private void redirectToLoginPage(WindowSession cm, RequestContextImpl ctx) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        sb.append(ctx.getRelativePath(ctx.getInputPath()));
        sb.append('?');
        StringTool.encodeURLEncoded((Appendable)sb, (String)"$cid");
        sb.append('=');
        sb.append(cm.getWindowID());
        sb.append(".x");
        DomUtil.addUrlParameters(sb, ctx, false);
        ILoginDialogFactory ldf = this.m_application.getLoginDialogFactory();
        if (ldf == null) {
            throw new NotLoggedInException(sb.toString());
        }
        String target = ldf.getLoginRURL(sb.toString());
        if (target == null) {
            throw new IllegalStateException("The Login Dialog Handler=" + ldf + " returned an invalid URL for the login dialog.");
        }
        target = ctx.getRelativePath(target);
        ApplicationRequestHandler.generateHttpRedirect(ctx, target, "You need to login before accessing this function");
    }

    private boolean checkRightsAnnotation(@Nonnull RequestContextImpl ctx, @Nonnull UrlPage body, @Nonnull UIRights rann, @Nonnull IUser user) throws Exception {
        if (StringTool.isBlank((String)rann.dataPath())) {
            for (String right : rann.value()) {
                if (user.hasRight(right)) continue;
                return false;
            }
            return true;
        }
        PropertyMetaModel<?> pmm = MetaManager.getPropertyMeta(body.getClass(), rann.dataPath());
        Object dataItem = pmm.getValue(body);
        for (String right : rann.value()) {
            if (user.hasRight(right, dataItem)) continue;
            return false;
        }
        return true;
    }

    public static void generateHttpRedirect(RequestContextImpl ctx, String to, String rsn) throws Exception {
        PrettyXmlOutputWriter out = new PrettyXmlOutputWriter(ctx.getOutputWriter("text/html; charset=UTF-8", "utf-8"));
        out.writeRaw("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html><head><script language=\"javascript\"><!--\nlocation.replace(" + StringTool.strToJavascriptString((String)to, (boolean)true) + ");\n--></script>\n</head><body>" + rsn + "</body></html>\n");
    }

    public static void generateAjaxRedirect(RequestContextImpl ctx, String url) throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info("redirecting to " + url);
        }
        PrettyXmlOutputWriter out = new PrettyXmlOutputWriter(ctx.getOutputWriter("text/xml; charset=UTF-8", "utf-8"));
        out.tag("redirect");
        out.attr("url", url);
        out.endAndCloseXmltag();
    }

    private void generateExpired(RequestContextImpl ctx, String message) throws Exception {
        PrettyXmlOutputWriter out = new PrettyXmlOutputWriter(ctx.getOutputWriter("text/xml; charset=UTF-8", "utf-8"));
        out.tag("expired");
        out.endtag();
        out.tag("msg");
        out.endtag();
        out.text(message);
        out.closetag("msg");
        out.closetag("expired");
    }

    private void generateEmptyDelta(RequestContextImpl ctx) throws Exception {
        PrettyXmlOutputWriter out = new PrettyXmlOutputWriter(ctx.getOutputWriter("text/xml; charset=UTF-8", "utf-8"));
        out.tag("delta");
        out.endtag();
        out.closetag("delta");
    }

    private void generateExpiredPollasy(RequestContextImpl ctx) throws Exception {
        PrettyXmlOutputWriter out = new PrettyXmlOutputWriter(ctx.getOutputWriter("text/xml; charset=UTF-8", "utf-8"));
        out.tag("expiredOnPollasy");
        out.endtag();
        out.closetag("expiredOnPollasy");
    }

    private List<NodeBase> handleComponentInput(@Nonnull IRequestContext ctx, @Nonnull Page page) throws Exception {
        ArrayList<NodeBase> changed = new ArrayList<NodeBase>();
        for (String name : ctx.getParameterNames()) {
            IHasChangeListener ch;
            NodeBase nb;
            String[] values = ctx.getParameters(name);
            if (null == values || !name.startsWith("_") || (nb = page.findNodeByID(name)) == null || !nb.acceptRequestParameter(values) || !(nb instanceof IHasChangeListener) || (ch = (IHasChangeListener)((Object)nb)).getOnValueChanged() == null) continue;
            changed.add(nb);
        }
        return changed;
    }

    private void runAction(RequestContextImpl ctx, Page page, String action, List<NodeBase> pendingChangeList) throws Exception {
        WindowSession cm;
        String url;
        boolean inhibitlog;
        long ts;
        block39: {
            ts = System.nanoTime();
            this.m_application.internalCallPageAction(ctx, page);
            page.callRequestStarted();
            if (!"pollasy".equals(action)) {
                page.controlToModel();
            }
            NodeBase wcomp = null;
            String wid = ctx.getParameter("webuic");
            if (wid != null) {
                wcomp = page.findNodeByID(wid);
            }
            inhibitlog = false;
            page.setTheCurrentNode(wcomp);
            try {
                if (("vchange".equals(action) || "clickandvchange".equals(action)) && wcomp != null && !pendingChangeList.contains(wcomp)) {
                    pendingChangeList.add(wcomp);
                }
                for (NodeBase n : pendingChangeList) {
                    if (DomUtil.USERLOG.isDebugEnabled()) {
                        DomUtil.USERLOG.debug("valueChanged on " + DomUtil.getComponentDetails(n));
                        this.logUser(ctx, page, "valueChanged on " + DomUtil.getComponentDetails(n));
                    }
                    n.internalOnValueChanged();
                }
                if ("clicked".equals(action)) {
                    this.handleClicked(ctx, page, wcomp);
                } else if ("clickandvchange".equals(action)) {
                    if (wcomp != null && wcomp.getClicked() != null) {
                        this.handleClicked(ctx, page, wcomp);
                    }
                } else if (!"vchange".equals(action)) {
                    if ("DEVTREE".equals(action)) {
                        this.handleDevelopmentShowCode(ctx, page, wcomp);
                    } else if ("pollasy".equals(action)) {
                        inhibitlog = true;
                    } else if (wcomp == null && this.isSafeToIgnoreUnknownNodeOnAction(action)) {
                        inhibitlog = true;
                    } else if (wcomp == null) {
                        if (!action.endsWith("?")) {
                            throw new IllegalStateException("Unknown node '" + wid + "' for action='" + action + "'");
                        }
                    } else {
                        wcomp.componentHandleWebAction(ctx, action);
                    }
                }
                ConversationContext conversation = page.internalGetConversation();
                if (null != conversation && conversation.isValid()) {
                    page.modelToControl();
                }
            }
            catch (ValidationException x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("rq: ignoring validation exception " + (Object)((Object)x));
                }
                page.modelToControl();
            }
            catch (MsgException msg) {
                MsgBox.error((NodeBase)page.getBody(), msg.getMessage());
                this.logUser(ctx, page, "error message: " + msg.getMessage());
                page.modelToControl();
            }
            catch (Exception ex) {
                this.logUser(ctx, page, "Action handler exception: " + ex);
                Exception x = WrappedException.unwrap((Exception)ex);
                if (x instanceof NotLoggedInException && (url = this.m_application.handleNotLoggedInException(ctx, page, (NotLoggedInException)x)) != null) {
                    ApplicationRequestHandler.generateAjaxRedirect(ctx, url);
                    return;
                }
                try {
                    page.modelToControl();
                }
                catch (Exception xxx) {
                    System.out.println("Double exception on modelToControl: " + xxx);
                    xxx.printStackTrace();
                }
                IExceptionListener xl = ctx.getApplication().findExceptionListenerFor(x);
                if (xl == null) {
                    throw x;
                }
                if (wcomp != null && !wcomp.isAttached()) {
                    wcomp = page.getTheCurrentControl();
                    System.out.println("DEBUG: Report exception on a " + (wcomp == null ? "unknown control/node" : wcomp.getClass()));
                }
                if (wcomp == null || !wcomp.isAttached()) {
                    throw new IllegalStateException("INTERNAL: Cannot determine node to report exception /on/", x);
                }
                if (xl.handleException(ctx, page, wcomp, x)) break block39;
                throw x;
            }
        }
        page.callRequestFinished();
        if (m_logPerf && !inhibitlog) {
            ts = System.nanoTime() - ts;
            System.out.println("domui: Action handling took " + StringTool.strNanoTime((long)ts));
        }
        if (!page.isDestroyed()) {
            page.getConversation().processDelayedResults(page);
        }
        if ((cm = ctx.getWindowSession()).handleGoto(ctx, page, true)) {
            return;
        }
        this.callNewPageBuiltListeners(page);
        try {
            ApplicationRequestHandler.renderOptimalDelta(ctx, page, inhibitlog);
        }
        catch (NotLoggedInException x) {
            url = this.m_application.handleNotLoggedInException(ctx, page, x);
            if (url != null) {
                ApplicationRequestHandler.generateHttpRedirect(ctx, url, "You need to be logged in");
                return;
            }
        }
        catch (Exception x) {
            this.logUser(ctx, page, "Delta render failed: " + x);
            throw x;
        }
    }

    private boolean isSafeToIgnoreUnknownNodeOnAction(@Nonnull String action) {
        return "lookupTyping".equals(action) || "lookupTypingDone".equals(action) || "notifyClientPositionAndSize".equals(action);
    }

    private void handleDevelopmentShowCode(RequestContextImpl ctx, Page page, NodeBase wcomp) {
        if (null == wcomp) {
            return;
        }
        List<InternalParentTree> res = page.getBody().getDeepChildren(InternalParentTree.class);
        if (res.size() > 0) {
            return;
        }
        InternalParentTree ipt = new InternalParentTree(wcomp);
        page.getBody().add(0, ipt);
    }

    public static void renderOptimalDelta(RequestContextImpl ctx, Page page) throws Exception {
        ApplicationRequestHandler.renderOptimalDelta(ctx, page, false);
    }

    private static void renderOptimalDelta(RequestContextImpl ctx, Page page, boolean inhibitlog) throws Exception {
        page.getBody().internalOnBeforeRender();
        page.internalDeltaBuild();
        ctx.getApplication().internalCallPageComplete(ctx, page);
        page.internalDeltaBuild();
        PrettyXmlOutputWriter out = new PrettyXmlOutputWriter(ctx.getOutputWriter("text/xml; charset=UTF-8", "utf-8"));
        long ts = System.nanoTime();
        HtmlFullRenderer fullr = ctx.getApplication().findRendererFor(ctx.getBrowserVersion(), out);
        OptimalDeltaRenderer dr = new OptimalDeltaRenderer(fullr, ctx, page);
        dr.render();
        if (m_logPerf && !inhibitlog) {
            ts = System.nanoTime() - ts;
            System.out.println("domui: Optimal Delta rendering using " + fullr + " took " + StringTool.strNanoTime((long)ts));
        }
        page.getConversation().startDelayedExecution();
    }

    private void callNewPageBuiltListeners(Page pg) throws Exception {
        if (pg.getBody().isBuilt()) {
            return;
        }
        pg.internalFullBuild();
        for (INewPageInstantiated npi : this.m_application.getNewPageInstantiatedListeners()) {
            npi.newPageBuilt(pg.getBody());
        }
    }

    private void handleClicked(IRequestContext ctx, Page page, NodeBase b) throws Exception {
        if (b == null) {
            this.logUser((RequestContextImpl)ctx, page, "User clicked to fast on " + DomUtil.getComponentDetails(b));
            System.out.println("User clicked too fast? Node not found. Ignoring.");
            return;
        }
        String msg = "Clicked on " + DomUtil.getComponentDetails(b);
        this.logUser((RequestContextImpl)ctx, page, msg);
        if (DomUtil.USERLOG.isDebugEnabled()) {
            DomUtil.USERLOG.debug(msg);
        }
        ClickInfo cli = new ClickInfo(ctx);
        b.internalOnClicked(cli);
    }

    private void renderOopsFrame(@Nonnull RequestContextImpl ctx, @Nonnull Throwable x) throws Exception {
        x.printStackTrace();
        if (ctx.getRequestResponse() instanceof HttpServerRequestResponse) {
            HttpServerRequestResponse srr = (HttpServerRequestResponse)ctx.getRequestResponse();
            HttpServletResponse resp = srr.getResponse();
            resp.setStatus(500);
        }
        ThemeManager themeManager = ctx.getApplication().internalGetThemeManager();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("x", x);
        dataMap.put("ctx", ctx);
        dataMap.put("app", ctx.getRelativePath(""));
        String sheet = themeManager.getThemedResourceRURL(DefaultThemeVariant.INSTANCE, "THEME/style.theme.css");
        if (null == sheet) {
            throw new IllegalStateException("Unexpected null??");
        }
        dataMap.put("stylesheet", sheet);
        String theme = themeManager.getThemedResourceRURL(DefaultThemeVariant.INSTANCE, "THEME/");
        dataMap.put("theme", theme);
        StringBuilder sb = new StringBuilder();
        ApplicationRequestHandler.dumpException(sb, x);
        dataMap.put("stacktrace", sb.toString());
        dataMap.put("message", StringTool.htmlStringize((String)x.toString()));
        dataMap.put("ctx", ctx);
        ExceptionUtil util = new ExceptionUtil(ctx);
        dataMap.put("util", util);
        Writer w = ctx.getRequestResponse().getOutputWriter("text/html", "utf-8");
        JSTemplate xt = this.getExceptionTemplate();
        xt.execute((Appendable)w, dataMap);
        w.flush();
        w.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public JSTemplate getExceptionTemplate() throws Exception {
        JSTemplate xt;
        block2: {
            JSTemplateCompiler jtc;
            block3: {
                xt = this.m_exceptionTemplate;
                if (xt != null) break block2;
                jtc = new JSTemplateCompiler();
                File src = new File(this.getClass().getResource("exceptionTemplate.html").getFile());
                if (!src.exists() || !src.isFile()) break block3;
                FileReader r = new FileReader(src);
                try {
                    xt = jtc.compile((Reader)r, src.getAbsolutePath());
                }
                catch (Throwable throwable) {
                    FileTool.closeAll((Object[])new Object[]{r});
                    throw throwable;
                }
                FileTool.closeAll((Object[])new Object[]{r});
                break block2;
            }
            xt = jtc.compile(ApplicationRequestHandler.class, "exceptionTemplate.html", "utf-8");
        }
        return xt;
    }

    private static void dumpException(@Nonnull StringBuilder a, @Nonnull Throwable x) {
        Throwable cause;
        StackTraceElement[] ssear;
        HashSet<String> allset = new HashSet<String>();
        for (StackTraceElement sse : ssear = x.getStackTrace()) {
            allset.add(sse.toString());
        }
        ApplicationRequestHandler.dumpSingle(a, x, Collections.EMPTY_SET);
        Throwable curr = x;
        while ((cause = curr.getCause()) != null && cause != curr) {
            a.append("\n\n     Caused by ").append(cause.toString()).append("\n");
            ApplicationRequestHandler.dumpSingle(a, cause, allset);
            curr = cause;
        }
    }

    private static void dumpSingle(@Nonnull StringBuilder sb, @Nonnull Throwable x, @Nonnull Set<String> initset) {
        String str;
        List<StackTraceElement> list = Arrays.asList(x.getStackTrace());
        int ix = ApplicationRequestHandler.findName(list, AppFilter.class.getName());
        if (ix != -1) {
            list = new ArrayList<StackTraceElement>(ApplicationRequestHandler.stripFrames(list, ix + 1));
        }
        int i = list.size();
        while (--i >= 0 && initset.contains(str = list.get(i).toString())) {
            list.remove(i);
        }
        for (StackTraceElement ste : list) {
            ApplicationRequestHandler.appendTraceLink(sb, ste);
        }
        if (x instanceof SQLException) {
            SQLException sx = (SQLException)x;
            while (sx.getNextException() != null) {
                sx = sx.getNextException();
                sb.append("SQL NextException: ");
                sb.append(sx.toString());
                sb.append("<br>");
            }
        }
    }

    private static int findName(@Nonnull List<StackTraceElement> list, String name) {
        int i = list.size();
        while (--i >= 0) {
            String cn = list.get(i).getClassName();
            if (!name.equals(cn)) continue;
            return i;
        }
        return -1;
    }

    private static List<StackTraceElement> stripFrames(@Nonnull List<StackTraceElement> list, int from) {
        return list.subList(0, from - 1);
    }

    private static void appendTraceLink(@Nonnull StringBuilder sb, @Nonnull StackTraceElement ste) {
        sb.append("        <a class='exc-stk-l' href=\"#\" onclick=\"linkClicked('");
        String name = ste.getLineNumber() <= 0 ? ste.getClassName().replace('.', '/') + ".java@" + ste.getMethodName() : ste.getClassName().replace('.', '/') + ".java#" + ste.getLineNumber();
        sb.append(name);
        sb.append("')\">");
        sb.append(ste.toString()).append("</a><br>");
    }
}

