/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

public class BrowserVersion {
    private String m_browserName;
    private String m_browserVersion;
    private int[] m_version;

    public static BrowserVersion parseUserAgent(String ua) {
        BrowserVersion bv = new BrowserVersion();
        bv.parse(ua);
        return bv;
    }

    private void parse(String ua) {
        if (ua.contains("Trident/7.0")) {
            this.handleIE11();
            return;
        }
        if (ua.startsWith("Mozilla/")) {
            this.decodeMozilla(ua);
            return;
        }
        int pos = ua.indexOf(47);
        if (pos == -1) {
            return;
        }
        this.m_browserName = ua.substring(0, pos).trim();
        int sp = ua.indexOf(32, pos);
        this.m_browserVersion = sp == -1 ? ua.substring(pos + 1) : ua.substring(pos + 1, sp).trim();
    }

    private void handleIE11() {
        this.m_browserName = "MSIE";
        this.m_browserVersion = "11.0";
    }

    private void decodeMozilla(String ua) {
        int p2;
        int p1;
        int pos = ua.indexOf("compatible");
        if (pos != -1 && (p1 = ua.indexOf(59, pos + 10)) != -1 && (p2 = ua.indexOf(59, p1 + 1)) != -1) {
            String br = ua.substring(p1 + 1, p2).trim();
            this.decodeBrowser(br);
            return;
        }
        pos = ua.lastIndexOf(32);
        if (pos != -1) {
            this.decodeBrowser(ua.substring(pos + 1));
        }
    }

    private void decodeBrowser(String br) {
        int pos = br.indexOf(32);
        if (pos == -1 && (pos = br.indexOf(47)) == -1) {
            this.m_browserName = br;
            return;
        }
        this.m_browserName = br.substring(0, pos);
        this.m_browserVersion = br.substring(pos + 1).trim();
    }

    public String getBrowserName() {
        return this.m_browserName;
    }

    public String getBrowserVersion() {
        return this.m_browserVersion;
    }

    private int[] getVer() {
        if (this.m_version == null) {
            if (this.m_browserVersion == null || this.m_browserVersion.length() == 0) {
                this.m_version = new int[]{0, 0};
                return this.m_version;
            }
            String[] ar = this.m_browserVersion.split("\\.");
            if (ar.length == 0) {
                ar = new String[]{this.m_browserVersion};
            }
            this.m_version = new int[ar.length];
            for (int i = 0; i < ar.length; ++i) {
                try {
                    this.m_version[i] = Integer.parseInt(ar[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.m_version;
    }

    private int getVer(int ix) {
        int[] v = this.getVer();
        if (ix >= v.length) {
            return 0;
        }
        return v[ix];
    }

    public int getMajorVersion() {
        return this.getVer(0);
    }

    public int getMinorVersion() {
        return this.getVer(1);
    }

    private static void check(String br, String bv, String ua) {
        BrowserVersion v = BrowserVersion.parseUserAgent(ua);
        if (!br.equals(v.getBrowserName())) {
            System.out.println("FAIL: Expected " + br + " got " + v.getBrowserName() + " in ua=" + ua);
        }
        if (!bv.equals(v.getBrowserVersion())) {
            System.out.println("FAIL: Expected " + bv + " got " + v.getBrowserVersion() + " in ua=" + ua);
        }
    }

    public boolean isIE() {
        return "MSIE".equals(this.getBrowserName());
    }

    public boolean isOpera() {
        return "Opera".equals(this.getBrowserName());
    }

    public boolean isKonqueror() {
        return "Konqueror".equals(this.getBrowserName());
    }

    public boolean isFirefox() {
        return "Firefox".equals(this.getBrowserName());
    }

    public boolean isMozilla() {
        return "Mozilla".equals(this.getBrowserName());
    }

    public static void main(String[] args) {
        try {
            BrowserVersion.check("Opera", "9.64", "Opera/9.64 (X11; Linux x86_64; U; nl) Presto/2.1.1");
            BrowserVersion.check("MSIE", "7.0", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 2.0.50727)");
            BrowserVersion.check("Firefox", "3.0.14", "Mozilla/5.0 (X11; U; Linux x86_64; en-US; rv:1.9.0.14) Gecko/2009090217 Ubuntu/9.04 (jaunty) Firefox/3.0.14");
            BrowserVersion.check("MSIE", "8.0", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; .NET CLR 2.0.50727)");
            BrowserVersion.check("Konqueror", "3.5", "Mozilla/5.0 (compatible; Konqueror/3.5; Linux; en_US) KHTML/3.5.10 (like Gecko) (Debian)");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public String toString() {
        return "[browser " + this.m_browserName + ", version=" + this.m_browserVersion + "]";
    }
}

