/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.ajax.AjaxRequestHandler;
import to.etc.domui.component.binding.DefaultBindingHandler;
import to.etc.domui.component.binding.IBindingHandler;
import to.etc.domui.component.binding.IBindingHandlerFactory;
import to.etc.domui.component.controlfactory.ControlBuilder;
import to.etc.domui.component.controlfactory.ControlFactoryMoney;
import to.etc.domui.component.controlfactory.PropertyControlFactory;
import to.etc.domui.component.delayed.IAsyncListener;
import to.etc.domui.component.layout.ErrorPanel;
import to.etc.domui.component.layout.title.AppPageTitleBar;
import to.etc.domui.component.layout.title.BasePageTitleBar;
import to.etc.domui.component.lookup.ILookupControlFactory;
import to.etc.domui.component2.controlfactory.ControlCreatorRegistry;
import to.etc.domui.dom.HtmlFullRenderer;
import to.etc.domui.dom.HtmlTagRenderer;
import to.etc.domui.dom.IBrowserOutput;
import to.etc.domui.dom.IHtmlRenderFactory;
import to.etc.domui.dom.MsCrapwareRenderFactory;
import to.etc.domui.dom.StandardHtmlFullRenderer;
import to.etc.domui.dom.StandardHtmlTagRenderer;
import to.etc.domui.dom.errors.IExceptionListener;
import to.etc.domui.dom.header.HeaderContributor;
import to.etc.domui.dom.header.HeaderContributorEntry;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.dom.webaction.JsonWebActionFactory;
import to.etc.domui.dom.webaction.SimpleWebActionFactory;
import to.etc.domui.dom.webaction.WebActionRegistry;
import to.etc.domui.injector.DefaultPageInjector;
import to.etc.domui.injector.IPageInjector;
import to.etc.domui.login.AccessDeniedPage;
import to.etc.domui.login.ILoginAuthenticator;
import to.etc.domui.login.ILoginDialogFactory;
import to.etc.domui.parts.SvgPartFactory;
import to.etc.domui.server.AppFilter;
import to.etc.domui.server.ApplicationRequestHandler;
import to.etc.domui.server.BrowserVersion;
import to.etc.domui.server.ConfigParameters;
import to.etc.domui.server.IAppSessionListener;
import to.etc.domui.server.IDomUIStateListener;
import to.etc.domui.server.IFilterRequestHandler;
import to.etc.domui.server.ILoginListener;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.IRequestInterceptor;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.ResourceRequestHandler;
import to.etc.domui.server.UrlPartRequestHandler;
import to.etc.domui.server.parts.IUrlPart;
import to.etc.domui.server.parts.PartRequestHandler;
import to.etc.domui.state.AppSession;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.IPageParameters;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.UIGoto;
import to.etc.domui.state.WindowSession;
import to.etc.domui.themes.ITheme;
import to.etc.domui.themes.IThemeFactory;
import to.etc.domui.themes.SimpleThemeFactory;
import to.etc.domui.themes.ThemeCssUtils;
import to.etc.domui.themes.ThemeManager;
import to.etc.domui.themes.ThemePartFactory;
import to.etc.domui.themes.ThemeResourceFactory;
import to.etc.domui.trouble.DataAccessViolationException;
import to.etc.domui.trouble.DataAccessViolationPage;
import to.etc.domui.trouble.ExpiredDataPage;
import to.etc.domui.trouble.NotLoggedInException;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.ICachedListMaker;
import to.etc.domui.util.IListMaker;
import to.etc.domui.util.INewPageInstantiated;
import to.etc.domui.util.js.IScriptScope;
import to.etc.domui.util.resources.ClassRefResourceFactory;
import to.etc.domui.util.resources.ClasspathInventory;
import to.etc.domui.util.resources.IModifyableResource;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceFactory;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.domui.util.resources.ProductionClassResourceRef;
import to.etc.domui.util.resources.ReloadingClassResourceRef;
import to.etc.domui.util.resources.ResourceDependencyList;
import to.etc.domui.util.resources.ResourceInfoCache;
import to.etc.domui.util.resources.SimpleResourceFactory;
import to.etc.domui.util.resources.VersionedJsResourceFactory;
import to.etc.domui.util.resources.WebappResourceRef;
import to.etc.util.DeveloperOptions;
import to.etc.util.WrappedException;
import to.etc.webapp.nls.BundleRef;
import to.etc.webapp.nls.NlsContext;
import to.etc.webapp.query.QNotFoundException;

public abstract class DomApplication {
    public static final Logger LOG = LoggerFactory.getLogger(DomApplication.class);
    @Nonnull
    private final PartRequestHandler m_partHandler = new PartRequestHandler(this);
    @Nonnull
    private Set<IAppSessionListener> m_appSessionListeners = new HashSet<IAppSessionListener>();
    @Nullable
    private File m_webFilePath;
    @Nullable
    private String m_urlExtension;
    @Nonnull
    private ControlBuilder m_controlBuilder = new ControlBuilder(this);
    @Nonnull
    private ControlCreatorRegistry m_controlCreatorRegistry = new ControlCreatorRegistry();
    private boolean m_developmentMode;
    private boolean m_uiTestMode;
    private int m_autoRefreshPollInterval;
    private int m_keepAliveInterval;
    private int m_defaultPollInterval = 2500;
    private String m_problemMailAddress;
    private String m_problemMailSubject;
    private boolean m_showProblemTemplate;
    private static DomApplication m_application;
    private static int m_nextPageTag;
    private final boolean m_logOutput = DeveloperOptions.getBool((String)"domui.log", (boolean)false);
    @Nonnull
    private List<IRequestInterceptor> m_interceptorList = new ArrayList<IRequestInterceptor>();
    @Nonnull
    private List<HeaderContributorEntry> m_orderedContributorList = Collections.EMPTY_LIST;
    @Nonnull
    private List<INewPageInstantiated> m_newPageInstListeners = Collections.EMPTY_LIST;
    private int m_windowSessionTimeout = 15;
    private int m_defaultExpiryTime = 86400;
    private ILoginAuthenticator m_loginAuthenticator;
    private ILoginDialogFactory m_loginDialogFactory;
    @Nonnull
    private List<ILoginListener> m_loginListenerList = Collections.EMPTY_LIST;
    @Nonnull
    private IPageInjector m_injector = new DefaultPageInjector();
    @Nonnull
    private ResourceInfoCache m_resourceInfoCache = new ResourceInfoCache(this);
    @Nonnull
    private IBindingHandlerFactory m_bindingHandlerFactory = DefaultBindingHandler.FACTORY;
    @Nonnull
    private List<IHtmlRenderFactory> m_renderFactoryList = new ArrayList<IHtmlRenderFactory>();
    @Nonnull
    private List<IResourceFactory> m_resourceFactoryList = Collections.EMPTY_LIST;
    @Nonnull
    private List<FilterRef> m_requestHandlerList = Collections.emptyList();
    private static volatile int m_platformVarcharByteLimit;
    private static final Comparator<FilterRef> C_HANDLER_DESCPRIO;
    @Nonnull
    private List<IAsyncListener<?>> m_asyncListenerList = Collections.emptyList();
    @Nonnull
    private final WebActionRegistry m_webActionRegistry = new WebActionRegistry();
    private static String[][] JQUERYSETS;
    @Nonnull
    private String m_jQueryVersion;
    @Nonnull
    private List<String> m_jQueryScripts;
    @Nonnull
    private String m_jQueryPath;
    private String m_problemFromAddress;
    private final Map<String, Boolean> m_knownResourceSet = new HashMap<String, Boolean>();
    private final Map<String, ListRef<?>> m_listCacheMap = new HashMap();
    private List<ExceptionEntry> m_exceptionListeners = new ArrayList<ExceptionEntry>();
    private final Map<String, BundleRef> m_rightsBundleMap = new HashMap<String, BundleRef>();
    private final ThemeManager m_themeManager = new ThemeManager(this);
    private final Map<String, String> m_themeApplicationProperties = new HashMap<String, String>();
    private List<IDomUIStateListener> m_uiStateListeners = Collections.EMPTY_LIST;

    @Nullable
    public abstract Class<? extends UrlPage> getRootPage();

    public DomApplication() {
        String jqversion = DeveloperOptions.getString((String)"domui.jqueryversion", (String)"1.10.2");
        String[] jqdata = null;
        for (String[] jqd : JQUERYSETS) {
            if (!jqd[0].equalsIgnoreCase(jqversion)) continue;
            jqdata = jqd;
            break;
        }
        if (null == jqdata || null == jqversion) {
            throw new IllegalStateException("jQuery version '" + jqversion + "' not supported");
        }
        this.m_jQueryVersion = jqversion;
        this.m_jQueryPath = jqdata[1];
        ArrayList<String> jqp = new ArrayList<String>(jqdata.length - 2);
        for (int i = 2; i < jqdata.length; ++i) {
            jqp.add(jqdata[i]);
        }
        this.m_jQueryScripts = jqp;
        this.registerControlFactories();
        this.registerPartFactories();
        this.initHeaderContributors();
        this.initializeWebActions();
        this.addRenderFactory(new MsCrapwareRenderFactory());
        this.addExceptionListener(QNotFoundException.class, new IExceptionListener(){

            @Override
            public boolean handleException(@Nonnull IRequestContext ctx, @Nonnull Page page, @Nullable NodeBase source, @Nonnull Throwable x) throws Exception {
                if (!(x instanceof QNotFoundException)) {
                    throw new IllegalStateException("??");
                }
                String rurl = DomUtil.createPageURL(ExpiredDataPage.class, (IPageParameters)new PageParameters("errorMessage", x.getLocalizedMessage()));
                UIGoto.redirect(rurl);
                return true;
            }
        });
        this.addExceptionListener(DataAccessViolationException.class, new IExceptionListener(){

            @Override
            public boolean handleException(@Nonnull IRequestContext ctx, @Nonnull Page page, @Nullable NodeBase source, @Nonnull Throwable x) throws Exception {
                if (!(x instanceof DataAccessViolationException)) {
                    throw new IllegalStateException("??");
                }
                String rurl = DomUtil.createPageURL(DataAccessViolationPage.class, (IPageParameters)new PageParameters("errorMessage", x.getLocalizedMessage()));
                UIGoto.redirect(rurl);
                return true;
            }
        });
        this.setCurrentTheme("blue/domui/blue");
        this.setThemeFactory(SimpleThemeFactory.INSTANCE);
        this.registerResourceFactory(new ClassRefResourceFactory());
        this.registerResourceFactory(new VersionedJsResourceFactory());
        this.registerResourceFactory(new SimpleResourceFactory());
        this.registerResourceFactory(new ThemeResourceFactory());
        this.addRequestHandler(new ApplicationRequestHandler(this), 100);
        this.addRequestHandler(new ResourceRequestHandler(this, this.m_partHandler), 0);
        this.addRequestHandler(new AjaxRequestHandler(this), 20);
        this.addRequestHandler(this.getPartRequestHandler(), 80);
    }

    protected void registerControlFactories() {
        this.registerControlFactory(PropertyControlFactory.STRING_CF);
        this.registerControlFactory(PropertyControlFactory.TEXTAREA_CF);
        this.registerControlFactory(PropertyControlFactory.BOOLEAN_AND_ENUM_CF);
        this.registerControlFactory(PropertyControlFactory.DATE_CF);
        this.registerControlFactory(PropertyControlFactory.RELATION_COMBOBOX_CF);
        this.registerControlFactory(PropertyControlFactory.RELATION_LOOKUP_CF);
        this.registerControlFactory(new ControlFactoryMoney());
    }

    protected void registerPartFactories() {
        this.registerUrlPart(new ThemePartFactory(), 100);
        this.registerUrlPart(new SvgPartFactory(), 100);
    }

    private static synchronized void setCurrentApplication(DomApplication da) {
        m_application = da;
    }

    @Nonnull
    public static synchronized DomApplication get() {
        DomApplication da = m_application;
        if (da == null) {
            throw new IllegalStateException("The 'current application' is unset!?");
        }
        return da;
    }

    public synchronized void addSessionListener(IAppSessionListener l) {
        this.m_appSessionListeners = new HashSet<IAppSessionListener>(this.m_appSessionListeners);
        this.m_appSessionListeners.add(l);
    }

    public synchronized void removeSessionListener(IAppSessionListener l) {
        this.m_appSessionListeners = new HashSet<IAppSessionListener>(this.m_appSessionListeners);
        this.m_appSessionListeners.remove(l);
    }

    private synchronized Set<IAppSessionListener> getAppSessionListeners() {
        return this.m_appSessionListeners;
    }

    @Nonnull
    public String getUrlExtension() {
        if (null != this.m_urlExtension) {
            return this.m_urlExtension;
        }
        throw new IllegalStateException("Application is not initialized");
    }

    @Nonnull
    private synchronized List<FilterRef> getRequestHandlerList() {
        return this.m_requestHandlerList;
    }

    public synchronized void addRequestHandler(@Nonnull IFilterRequestHandler fh, int priority) {
        this.m_requestHandlerList = new ArrayList<FilterRef>(this.m_requestHandlerList);
        this.m_requestHandlerList.add(new FilterRef(fh, priority));
        Collections.sort(this.m_requestHandlerList, C_HANDLER_DESCPRIO);
    }

    @Nullable
    public IFilterRequestHandler findRequestHandler(@Nonnull IRequestContext ctx) throws Exception {
        for (FilterRef h : this.getRequestHandlerList()) {
            if (!h.getHandler().accepts(ctx)) continue;
            return h.getHandler();
        }
        return null;
    }

    public void registerUrlPart(@Nonnull IUrlPart factory, int priority) {
        this.addRequestHandler(new UrlPartRequestHandler(this.getPartRequestHandler(), factory), priority);
    }

    public void registerUrlPart(@Nonnull IUrlPart factory) {
        this.registerUrlPart(factory, 10);
    }

    @Nonnull
    public PartRequestHandler getPartRequestHandler() {
        return this.m_partHandler;
    }

    @Nonnull
    public AppSession createSession() {
        AppSession aps = new AppSession(this);
        return aps;
    }

    void registerSession(@Nonnull AppSession aps) {
        for (IAppSessionListener l : this.getAppSessionListeners()) {
            try {
                l.sessionCreated(this, aps);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    void unregisterSession(@Nonnull AppSession aps) {
    }

    final void internalDestroy() {
        LOG.info("Destroying application " + this);
        try {
            this.destroy();
        }
        catch (Throwable x) {
            AppFilter.LOG.error("Exception when destroying Application", x);
        }
    }

    protected void destroy() {
    }

    protected void initialize(@Nonnull ConfigParameters pp) throws Exception {
    }

    public final synchronized void internalInitialize(@Nonnull ConfigParameters pp, boolean development) throws Exception {
        DomApplication.setCurrentApplication(this);
        this.m_webFilePath = pp.getWebFileRoot();
        String ext = pp.getString("extension");
        if (ext == null || ext.trim().length() == 0) {
            this.m_urlExtension = "ui";
        } else {
            if ((ext = ext.trim()).startsWith(".")) {
                ext = ext.substring(1);
            }
            if (ext.indexOf(46) != -1) {
                throw new IllegalArgumentException("The 'extension' parameter contains too many dots...");
            }
            this.m_urlExtension = ext;
        }
        this.m_developmentMode = development;
        if (this.m_developmentMode && DeveloperOptions.getBool((String)"domui.traceallocations", (boolean)true)) {
            NodeBase.internalSetLogAllocations(true);
        }
        String haso = DeveloperOptions.getString((String)"domui.testui");
        boolean uiTestMode = false;
        if (this.m_developmentMode && haso == null) {
            uiTestMode = true;
        }
        if ("true".equals(haso)) {
            uiTestMode = true;
        }
        if ("true".equals(haso = System.getProperty("domui.testui"))) {
            uiTestMode = true;
        }
        if (uiTestMode) {
            this.setUiTestMode();
        }
        this.initialize(pp);
        int refreshinterval = 0;
        if (development) {
            if (DeveloperOptions.getBool((String)"domui.autorefresh", (!DeveloperOptions.getBool((String)"domui.log", (boolean)false) ? 1 : 0) != 0)) {
                refreshinterval = DeveloperOptions.getInt((String)"domui.refreshinterval", (int)2500);
            }
            this.setAutoRefreshPollInterval(refreshinterval);
        }
    }

    public static final synchronized int internalNextPageTag() {
        int id;
        if ((id = ++m_nextPageTag) <= 0) {
            m_nextPageTag = 1;
            id = 1;
        }
        return id;
    }

    @Nonnull
    final Class<?> loadApplicationClass(@Nonnull String name) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(name);
    }

    @Nonnull
    public Class<? extends UrlPage> loadPageClass(@Nonnull String name) {
        Class<?> clz = null;
        try {
            clz = this.loadApplicationClass(name);
        }
        catch (ClassNotFoundException x) {
            throw new ThingyNotFoundException("404 class " + name + " not found");
        }
        catch (Exception x) {
            throw new IllegalStateException("Error in class " + name, x);
        }
        if (!UrlPage.class.isAssignableFrom(clz)) {
            throw new IllegalStateException("Class " + clz + " is not a valid page class (does not extend " + UrlPage.class.getName() + ")");
        }
        return clz;
    }

    @Nonnull
    public String getScriptVersion() {
        return this.m_jQueryPath;
    }

    @Nonnull
    public List<String> getJQueryScripts() {
        return this.m_jQueryScripts;
    }

    public String getJQueryVersion() {
        return this.m_jQueryVersion;
    }

    @Nonnull
    public WebActionRegistry getWebActionRegistry() {
        return this.m_webActionRegistry;
    }

    protected void initializeWebActions() {
        this.getWebActionRegistry().register(new SimpleWebActionFactory());
        this.getWebActionRegistry().register(new JsonWebActionFactory());
    }

    public HtmlFullRenderer findRendererFor(BrowserVersion bv, IBrowserOutput o) {
        boolean tm = this.isUiTestMode();
        for (IHtmlRenderFactory f : this.getRenderFactoryList()) {
            HtmlFullRenderer tr = f.createFullRenderer(bv, o, tm);
            if (tr == null) continue;
            return tr;
        }
        return new StandardHtmlFullRenderer(new StandardHtmlTagRenderer(bv, o, tm), o);
    }

    public HtmlTagRenderer findTagRendererFor(BrowserVersion bv, IBrowserOutput o) {
        boolean tm = this.isUiTestMode();
        for (IHtmlRenderFactory f : this.getRenderFactoryList()) {
            HtmlTagRenderer tr = f.createTagRenderer(bv, o, tm);
            if (tr == null) continue;
            return tr;
        }
        return new StandardHtmlTagRenderer(bv, o, tm);
    }

    private synchronized List<IHtmlRenderFactory> getRenderFactoryList() {
        return this.m_renderFactoryList;
    }

    public synchronized void addRenderFactory(IHtmlRenderFactory f) {
        if (this.m_renderFactoryList.contains(f)) {
            throw new IllegalStateException("Don't be silly, this one is already added");
        }
        this.m_renderFactoryList = new ArrayList<IHtmlRenderFactory>(this.m_renderFactoryList);
        this.m_renderFactoryList.add(0, f);
    }

    public synchronized boolean inDevelopmentMode() {
        return this.m_developmentMode;
    }

    public synchronized boolean isUiTestMode() {
        return this.m_uiTestMode;
    }

    public void setAutoRefreshPollInterval(int autoRefreshPollInterval) {
        this.m_autoRefreshPollInterval = autoRefreshPollInterval;
    }

    public synchronized int getAutoRefreshPollInterval() {
        return this.m_autoRefreshPollInterval;
    }

    public synchronized int getDefaultPollInterval() {
        return this.m_defaultPollInterval;
    }

    public synchronized void setDefaultPollInterval(int defaultPollInterval) {
        this.m_defaultPollInterval = defaultPollInterval;
    }

    public synchronized int calculatePollInterval(boolean pollCallbackRequired) {
        int pollinterval = Integer.MAX_VALUE;
        if (this.m_keepAliveInterval > 0) {
            pollinterval = this.m_keepAliveInterval;
        }
        if (this.m_autoRefreshPollInterval > 0 && this.m_autoRefreshPollInterval < pollinterval) {
            pollinterval = this.m_autoRefreshPollInterval;
        }
        if (pollCallbackRequired && this.m_defaultPollInterval < pollinterval) {
            pollinterval = this.m_defaultPollInterval;
        }
        if (pollinterval == Integer.MAX_VALUE) {
            return 0;
        }
        return pollinterval;
    }

    public int getWindowSessionTimeout() {
        return this.m_windowSessionTimeout;
    }

    public void setWindowSessionTimeout(int windowSessionTimeout) {
        this.m_windowSessionTimeout = windowSessionTimeout;
    }

    public synchronized int getDefaultExpiryTime() {
        return this.m_defaultExpiryTime;
    }

    public synchronized void setDefaultExpiryTime(int defaultExpiryTime) {
        this.m_defaultExpiryTime = defaultExpiryTime;
    }

    @Nonnull
    public Locale getRequestLocale(HttpServletRequest request) {
        return request.getLocale();
    }

    @Nullable
    public synchronized String getProblemMailAddress() {
        return this.m_problemMailAddress;
    }

    public synchronized void setProblemMail(@Nonnull String toAddress, @Nonnull String fromAddress, @Nonnull String subject) {
        this.m_problemMailAddress = toAddress;
        this.m_problemMailSubject = subject;
        this.m_problemFromAddress = fromAddress;
    }

    @Nullable
    public String getProblemFromAddress() {
        return this.m_problemFromAddress;
    }

    @Nullable
    public synchronized String getProblemMailSubject() {
        return this.m_problemMailSubject;
    }

    public synchronized boolean isShowProblemTemplate() {
        return this.m_showProblemTemplate;
    }

    public synchronized void setShowProblemTemplate(boolean showProblemTemplate) {
        this.m_showProblemTemplate = showProblemTemplate;
    }

    @Nonnull
    public IBindingHandlerFactory getBindingHandlerFactory() {
        return this.m_bindingHandlerFactory;
    }

    public void setBindingHandlerFactory(@Nonnull IBindingHandlerFactory bindingHandlerFactory) {
        this.m_bindingHandlerFactory = bindingHandlerFactory;
    }

    @Nonnull
    public IBindingHandler getBindingHandler(@Nonnull NodeBase node) {
        return this.getBindingHandlerFactory().getBindingHandler(node);
    }

    protected void initHeaderContributors() {
        int order = -1200;
        for (String jqresource : this.getJQueryScripts()) {
            this.addHeaderContributor(HeaderContributor.loadJavascript("$js/" + jqresource), order++);
        }
        this.addHeaderContributor(HeaderContributor.loadJavascript("$js/jquery.blockUI.js"), -970);
        this.addHeaderContributor(HeaderContributor.loadJavascript("$js/domui.js"), -900);
        this.addHeaderContributor(HeaderContributor.loadJavascript("$js/domui.searchpopup.js"), -895);
        this.addHeaderContributor(HeaderContributor.loadJavascript("$js/weekagenda.js"), -790);
        this.addHeaderContributor(HeaderContributor.loadJavascript("$js/jquery.wysiwyg.js"), -780);
        this.addHeaderContributor(HeaderContributor.loadJavascript("$js/wysiwyg.rmFormat.js"), -779);
        this.addHeaderContributor(HeaderContributor.loadStylesheet("$js/jquery.wysiwyg.css"), -780);
        this.addHeaderContributor(HeaderContributor.loadJavascript("$js/jquery-plugins/jquery.floatThead.js"), -790);
        this.addHeaderContributor(HeaderContributor.loadJavascript("$js/calendar.js"), -780);
        this.addHeaderContributor(HeaderContributor.loadJavascript("$js/calendar-setup.js"), -770);
        this.addHeaderContributor(HeaderContributor.loadJavascript("$ckeditor/ckeditor.js"), -760);
    }

    public final synchronized void addHeaderContributor(HeaderContributor hc, int order) {
        for (HeaderContributorEntry hce : this.m_orderedContributorList) {
            if (!hce.getContributor().equals(hc)) continue;
            throw new IllegalArgumentException("The header contributor " + hc + " has already been added.");
        }
        this.m_orderedContributorList = new ArrayList<HeaderContributorEntry>(this.m_orderedContributorList);
        this.m_orderedContributorList.add(new HeaderContributorEntry(hc, order));
    }

    public synchronized List<HeaderContributorEntry> getHeaderContributorList() {
        return this.m_orderedContributorList;
    }

    public void addDefaultErrorComponent(NodeContainer page) {
        ErrorPanel panel = new ErrorPanel();
        page.add(0, panel);
    }

    @Deprecated
    public BasePageTitleBar getDefaultPageTitleBar(String title) {
        return new AppPageTitleBar(title, true);
    }

    @Nonnull
    public final ControlBuilder getControlBuilder() {
        return this.m_controlBuilder;
    }

    @Nonnull
    public ControlCreatorRegistry getControlCreatorRegistry() {
        return this.m_controlCreatorRegistry;
    }

    public final void registerControlFactory(PropertyControlFactory cf) {
        this.getControlBuilder().registerControlFactory(cf);
    }

    public void register(ILookupControlFactory f) {
        this.getControlBuilder().register(f);
    }

    public <T> T createInstance(Class<T> clz, Object ... args) {
        try {
            return clz.newInstance();
        }
        catch (IllegalAccessException x) {
            throw new WrappedException((Throwable)x);
        }
        catch (InstantiationException x) {
            throw new WrappedException((Throwable)x);
        }
    }

    @Nonnull
    public File getAppFile(String path) {
        return new File(this.m_webFilePath, path);
    }

    @Nonnull
    public IResourceRef getAppFileOrResource(String name) {
        File f = this.getAppFile(name);
        if (f.exists()) {
            return new WebappResourceRef(f);
        }
        return this.createClasspathReference("/resources/" + name);
    }

    public synchronized void registerResourceFactory(@Nonnull IResourceFactory f) {
        this.m_resourceFactoryList = new ArrayList<IResourceFactory>(this.m_resourceFactoryList);
        this.m_resourceFactoryList.add(f);
    }

    @Nonnull
    public synchronized List<IResourceFactory> getResourceFactories() {
        return this.m_resourceFactoryList;
    }

    @Nullable
    public IResourceFactory findResourceFactory(String name) {
        IResourceFactory best = null;
        int bestscore = -1;
        for (IResourceFactory rf : this.getResourceFactories()) {
            int score = rf.accept(name);
            if (score <= bestscore) continue;
            bestscore = score;
            best = rf;
        }
        return best;
    }

    @Nonnull
    public final File getWebAppFileRoot() {
        if (null != this.m_webFilePath) {
            return this.m_webFilePath;
        }
        throw new IllegalStateException("Application is not initialized");
    }

    @Nonnull
    public IResourceRef createClasspathReference(String name) {
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (this.inDevelopmentMode()) {
            IModifyableResource ts = ClasspathInventory.getInstance().findResourceSource(name);
            return new ReloadingClassResourceRef(ts, name);
        }
        return new ProductionClassResourceRef(name);
    }

    @Nonnull
    public IResourceRef getResource(@Nonnull String name, @Nonnull IResourceDependencyList rdl) throws Exception {
        IResourceRef ref = this.internalFindResource(name, rdl);
        if (ref instanceof WebappResourceRef && !ref.exists()) {
            throw new ThingyNotFoundException(name);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasApplicationResource(String name) throws Exception {
        Boolean k;
        DomApplication domApplication = this;
        synchronized (domApplication) {
            k = this.m_knownResourceSet.get(name);
            if (k != null) {
                return k;
            }
        }
        IResourceRef ref = this.internalFindResource(name, ResourceDependencyList.NULL);
        k = ref.exists();
        if (!this.inDevelopmentMode() || ref instanceof IModifyableResource) {
            DomApplication domApplication2 = this;
            synchronized (domApplication2) {
                this.m_knownResourceSet.put(name, k);
            }
        }
        return k;
    }

    @Nonnull
    private IResourceRef internalFindResource(@Nonnull String name, @Nonnull IResourceDependencyList rdl) throws Exception {
        IResourceFactory rf = this.findResourceFactory(name);
        if (rf != null) {
            return rf.getResource(this, name, rdl);
        }
        File src = new File(this.m_webFilePath, name);
        WebappResourceRef r = new WebappResourceRef(src);
        rdl.add(r);
        return r;
    }

    public String findLocalizedResourceName(String basename, String suffix, Locale loc) throws Exception {
        StringBuilder sb = new StringBuilder(128);
        String s = this.tryKey(sb, basename, suffix, loc.getLanguage(), loc.getCountry(), loc.getVariant(), NlsContext.getDialect());
        if (s != null) {
            return s;
        }
        s = this.tryKey(sb, basename, suffix, loc.getLanguage(), loc.getCountry(), loc.getVariant(), null);
        if (s != null) {
            return s;
        }
        s = this.tryKey(sb, basename, suffix, loc.getLanguage(), loc.getCountry(), null, NlsContext.getDialect());
        if (s != null) {
            return s;
        }
        s = this.tryKey(sb, basename, suffix, loc.getLanguage(), loc.getCountry(), null, null);
        if (s != null) {
            return s;
        }
        s = this.tryKey(sb, basename, suffix, loc.getLanguage(), null, null, NlsContext.getDialect());
        if (s != null) {
            return s;
        }
        s = this.tryKey(sb, basename, suffix, loc.getLanguage(), null, null, null);
        if (s != null) {
            return s;
        }
        s = this.tryKey(sb, basename, suffix, null, null, null, NlsContext.getDialect());
        if (s != null) {
            return s;
        }
        s = this.tryKey(sb, basename, suffix, null, null, null, null);
        if (s != null) {
            return s;
        }
        return null;
    }

    private String tryKey(StringBuilder sb, String basename, String suffix, String lang, String country, String variant, String dialect) throws Exception {
        String res;
        sb.setLength(0);
        sb.append(basename);
        if (dialect != null && dialect.length() > 0) {
            sb.append('_');
            sb.append(dialect);
        }
        if (lang != null && lang.length() > 0) {
            sb.append('_');
            sb.append(lang);
        }
        if (country != null && country.length() > 0) {
            sb.append('_');
            sb.append(country);
        }
        if (variant != null && variant.length() > 0) {
            sb.append('_');
            sb.append(variant);
        }
        if (suffix != null && suffix.length() > 0) {
            sb.append(suffix);
        }
        if (this.hasApplicationResource(res = sb.toString())) {
            return res;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <T> List<T> getCachedList(IListMaker<T> maker) throws Exception {
        ListRef<Object> ref;
        if (!(maker instanceof ICachedListMaker)) {
            return maker.createList(this);
        }
        ICachedListMaker cm = (ICachedListMaker)maker;
        String key = cm.getCacheKey();
        Map<String, ListRef<?>> map = this.m_listCacheMap;
        synchronized (map) {
            ref = this.m_listCacheMap.get(key);
            if (ref == null) {
                ref = new ListRef(cm);
                this.m_listCacheMap.put(key, ref);
            }
        }
        return new ArrayList<Object>(ref.initialize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListCaches() {
        Map<String, ListRef<?>> map = this.m_listCacheMap;
        synchronized (map) {
            this.m_listCacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListCache(ICachedListMaker<?> maker) {
        Map<String, ListRef<?>> map = this.m_listCacheMap;
        synchronized (map) {
            this.m_listCacheMap.remove(maker.getCacheKey());
        }
    }

    public boolean logOutput() {
        return this.m_logOutput;
    }

    public synchronized void addInterceptor(IRequestInterceptor r) {
        ArrayList<IRequestInterceptor> l = new ArrayList<IRequestInterceptor>(this.m_interceptorList);
        l.add(r);
        this.m_interceptorList = l;
    }

    public synchronized List<IRequestInterceptor> getInterceptorList() {
        return this.m_interceptorList;
    }

    private synchronized List<ExceptionEntry> getExceptionListeners() {
        return this.m_exceptionListeners;
    }

    public synchronized void addExceptionListener(Class<? extends Exception> xclass, IExceptionListener l) {
        this.m_exceptionListeners = new ArrayList<ExceptionEntry>(this.m_exceptionListeners);
        for (int i = 0; i < this.m_exceptionListeners.size(); ++i) {
            ExceptionEntry ee = this.m_exceptionListeners.get(i);
            if (ee.getExceptionClass() == xclass) {
                this.m_exceptionListeners.set(i, new ExceptionEntry(xclass, l));
                return;
            }
            if (!ee.getExceptionClass().isAssignableFrom(xclass)) continue;
            this.m_exceptionListeners.add(i, new ExceptionEntry(xclass, l));
            return;
        }
        this.m_exceptionListeners.add(new ExceptionEntry(xclass, l));
    }

    public IExceptionListener findExceptionListenerFor(Exception x) {
        Class<?> xclass = x.getClass();
        for (ExceptionEntry ee : this.getExceptionListeners()) {
            if (!ee.getExceptionClass().isAssignableFrom(xclass)) continue;
            return ee.getListener();
        }
        return null;
    }

    public synchronized void addNewPageInstantiatedListener(INewPageInstantiated l) {
        this.m_newPageInstListeners = new ArrayList<INewPageInstantiated>(this.m_newPageInstListeners);
        this.m_newPageInstListeners.add(l);
    }

    public synchronized void removeNewPageInstantiatedListener(INewPageInstantiated l) {
        this.m_newPageInstListeners = new ArrayList<INewPageInstantiated>(this.m_newPageInstListeners);
        this.m_newPageInstListeners.remove(l);
    }

    public synchronized List<INewPageInstantiated> getNewPageInstantiatedListeners() {
        return this.m_newPageInstListeners;
    }

    public synchronized ILoginAuthenticator getLoginAuthenticator() {
        return this.m_loginAuthenticator;
    }

    public synchronized void setLoginAuthenticator(ILoginAuthenticator loginAuthenticator) {
        this.m_loginAuthenticator = loginAuthenticator;
    }

    public synchronized ILoginDialogFactory getLoginDialogFactory() {
        return this.m_loginDialogFactory;
    }

    public synchronized void setLoginDialogFactory(ILoginDialogFactory loginDialogFactory) {
        this.m_loginDialogFactory = loginDialogFactory;
    }

    public synchronized void addLoginListener(ILoginListener l) {
        if (this.m_loginListenerList.contains(l)) {
            return;
        }
        this.m_loginListenerList = new ArrayList<ILoginListener>(this.m_loginListenerList);
        this.m_loginListenerList.add(l);
    }

    public synchronized List<ILoginListener> getLoginListenerList() {
        return this.m_loginListenerList;
    }

    public synchronized <T> void addAsyncListener(@Nonnull IAsyncListener<T> l) {
        this.m_asyncListenerList = new ArrayList(this.m_asyncListenerList);
        this.m_asyncListenerList.add(l);
    }

    public synchronized <T> void removeAsyncListener(@Nonnull IAsyncListener<T> l) {
        this.m_asyncListenerList = new ArrayList(this.m_asyncListenerList);
        this.m_asyncListenerList.remove(l);
    }

    @Nonnull
    public synchronized List<IAsyncListener<?>> getAsyncListenerList() {
        return this.m_asyncListenerList;
    }

    public String handleNotLoggedInException(RequestContextImpl ci, Page page, NotLoggedInException x) {
        ILoginDialogFactory ldf = ci.getApplication().getLoginDialogFactory();
        if (ldf == null) {
            return null;
        }
        String target = ldf.getLoginRURL(x.getURL());
        if (target == null) {
            throw new IllegalStateException("The Login Dialog Handler=" + ldf + " returned an invalid URL for the login dialog.");
        }
        return ci.getRelativePath(target);
    }

    public synchronized IPageInjector getInjector() {
        return this.m_injector;
    }

    public synchronized void setInjector(IPageInjector injector) {
        this.m_injector = injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRight(BundleRef bundle, String ... rights) {
        Map<String, BundleRef> map = this.m_rightsBundleMap;
        synchronized (map) {
            for (String r : rights) {
                if (this.m_rightsBundleMap.containsKey(r)) continue;
                this.m_rightsBundleMap.put(r, bundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRights(BundleRef bundle, Class<?> constantsclass) {
        Field[] far = constantsclass.getDeclaredFields();
        Map<String, BundleRef> map = this.m_rightsBundleMap;
        synchronized (map) {
            for (Field f : far) {
                int mod = f.getModifiers();
                if (!Modifier.isFinal(mod) || !Modifier.isPublic(mod) || !Modifier.isStatic(mod) || f.getType() != String.class) continue;
                try {
                    String s = (String)f.get(null);
                    if (s == null || this.m_rightsBundleMap.containsKey(s)) continue;
                    this.m_rightsBundleMap.put(s, bundle);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRegisteredRights() {
        Map<String, BundleRef> map = this.m_rightsBundleMap;
        synchronized (map) {
            return new ArrayList<String>(this.m_rightsBundleMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findRightsDescription(String right) {
        BundleRef br;
        Map<String, BundleRef> map = this.m_rightsBundleMap;
        synchronized (map) {
            br = this.m_rightsBundleMap.get(right);
        }
        return br == null ? null : br.findMessage(NlsContext.getLocale(), right);
    }

    public String getRightsDescription(String right) {
        String v = this.findRightsDescription(right);
        return v == null ? right : v;
    }

    public static int getPlatformVarcharByteLimit() {
        return m_platformVarcharByteLimit;
    }

    public static void setPlatformVarcharByteLimit(int platformVarcharByteLimit) {
        m_platformVarcharByteLimit = platformVarcharByteLimit;
    }

    @OverridingMethodsMustInvokeSuper
    public void augmentThemeMap(@Nonnull IScriptScope ss) throws Exception {
        ss.put("util", new ThemeCssUtils(ss));
        ss.eval(Object.class, "function url(x) { return util.url(x);};", "internal");
        this.m_themeApplicationProperties.forEach((key, value) -> ss.put((String)key, value));
    }

    public final void setCurrentTheme(@Nonnull String currentTheme) {
        this.m_themeManager.setCurrentTheme(currentTheme);
    }

    @Nonnull
    public final String getCurrentTheme() {
        return this.m_themeManager.getCurrentTheme();
    }

    public final void setThemeProperty(@Nonnull String name, @Nullable String value) {
        this.m_themeApplicationProperties.put(name, value);
    }

    @Nullable
    public final String getThemeProperty(@Nonnull String name) {
        return this.m_themeApplicationProperties.get(name);
    }

    @Nonnull
    public final ITheme getTheme() {
        return this.m_themeManager.getTheme(this.getCurrentTheme(), null);
    }

    @Nonnull
    public ThemeManager internalGetThemeManager() {
        return this.m_themeManager;
    }

    public final void setThemeFactory(@Nonnull IThemeFactory themer) {
        this.m_themeManager.setThemeFactory(themer);
    }

    public final ITheme getTheme(@Nonnull String themeName, @Nullable IResourceDependencyList rdl) throws Exception {
        return this.m_themeManager.getTheme(themeName, rdl);
    }

    public final String getThemeReplacedString(IResourceDependencyList rdl, String rurl) throws Exception {
        return this.m_themeManager.getThemeReplacedString(rdl, rurl);
    }

    public final String getThemeReplacedString(IResourceDependencyList rdl, String rurl, BrowserVersion bv) throws Exception {
        return this.m_themeManager.getThemeReplacedString(rdl, rurl, bv);
    }

    @Nonnull
    public ResourceInfoCache getResourceInfoCache() {
        return this.m_resourceInfoCache;
    }

    public synchronized int getKeepAliveInterval() {
        return this.m_keepAliveInterval;
    }

    public synchronized void setKeepAliveInterval(int keepAliveInterval) {
        if (!DeveloperOptions.getBool((String)"domui.log", (boolean)false) && (DeveloperOptions.getBool((String)"domui.autorefresh", (boolean)true) || DeveloperOptions.getBool((String)"domui.keepalive", (boolean)false))) {
            this.m_keepAliveInterval = keepAliveInterval;
        }
    }

    public synchronized void addUIStateListener(IDomUIStateListener sl) {
        this.m_uiStateListeners = new ArrayList<IDomUIStateListener>(this.m_uiStateListeners);
        this.m_uiStateListeners.add(sl);
    }

    public synchronized void removeUIStateListener(IDomUIStateListener sl) {
        this.m_uiStateListeners = new ArrayList<IDomUIStateListener>(this.m_uiStateListeners);
        this.m_uiStateListeners.remove(sl);
    }

    private synchronized List<IDomUIStateListener> getUIStateListeners() {
        return this.m_uiStateListeners;
    }

    public final void internalCallWindowSessionCreated(WindowSession ws) {
        for (IDomUIStateListener sl : this.getUIStateListeners()) {
            try {
                sl.windowSessionCreated(ws);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public final void internalCallWindowSessionDestroyed(WindowSession ws) {
        for (IDomUIStateListener sl : this.getUIStateListeners()) {
            try {
                sl.windowSessionDestroyed(ws);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public final void internalCallConversationCreated(ConversationContext ws) {
        for (IDomUIStateListener sl : this.getUIStateListeners()) {
            try {
                sl.conversationCreated(ws);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public final void internalCallConversationDestroyed(ConversationContext ws) {
        for (IDomUIStateListener sl : this.getUIStateListeners()) {
            try {
                sl.conversationDestroyed(ws);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public final void internalCallPageFullRender(RequestContextImpl ctx, Page ws) {
        for (IDomUIStateListener sl : this.getUIStateListeners()) {
            try {
                sl.onBeforeFullRender(ctx, ws);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public final void internalCallPageAction(RequestContextImpl ctx, Page ws) {
        for (IDomUIStateListener sl : this.getUIStateListeners()) {
            try {
                sl.onBeforePageAction(ctx, ws);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public final void internalCallPageComplete(IRequestContext ctx, Page ws) {
        for (IDomUIStateListener sl : this.getUIStateListeners()) {
            try {
                sl.onAfterPage(ctx, ws);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public synchronized void setUiTestMode() {
        if (!this.m_uiTestMode) {
            this.addHeaderContributor(HeaderContributor.loadJavascript("$js/web-driver/fileSaver.js"), 11);
            this.addHeaderContributor(HeaderContributor.loadJavascript("$js/web-driver/sharedLocatorGenerator.js"), 13);
            this.addHeaderContributor(HeaderContributor.loadJavascript("$js/web-driver/domuiLocatorGenerator.js"), 12);
        }
        this.m_uiTestMode = true;
    }

    @Nonnull
    public <T extends UrlPage> Class<T> getAccessDeniedPageClass() {
        return AccessDeniedPage.class;
    }

    static {
        m_nextPageTag = (int)(System.nanoTime() & Integer.MAX_VALUE);
        C_HANDLER_DESCPRIO = new Comparator<FilterRef>(){

            @Override
            public int compare(FilterRef a, FilterRef b) {
                return b.getPriority() - a.getPriority();
            }
        };
        JQUERYSETS = new String[][]{{"1.4.4", "jquery-1.4.4", "jquery.js", "jquery-ui.js"}, {"1.10.2", "jquery-1.10.2", "jquery.js", "jquery-ui.js", "jquery-migrate.js"}};
    }

    public static class ExceptionEntry {
        private final Class<? extends Exception> m_exceptionClass;
        private final IExceptionListener m_listener;

        public ExceptionEntry(Class<? extends Exception> exceptionClass, IExceptionListener listener) {
            this.m_exceptionClass = exceptionClass;
            this.m_listener = listener;
        }

        public Class<? extends Exception> getExceptionClass() {
            return this.m_exceptionClass;
        }

        public IExceptionListener getListener() {
            return this.m_listener;
        }
    }

    private static final class ListRef<T> {
        private List<T> m_list;
        private final ICachedListMaker<T> m_maker;

        public ListRef(ICachedListMaker<T> maker) {
            this.m_maker = maker;
        }

        public synchronized List<T> initialize() throws Exception {
            if (this.m_list == null) {
                this.m_list = this.m_maker.createList(DomApplication.get());
            }
            return this.m_list;
        }
    }

    private static final class FilterRef {
        private final int m_score;
        @Nonnull
        private final IFilterRequestHandler m_handler;

        public FilterRef(@Nonnull IFilterRequestHandler handler, int score) {
            this.m_handler = handler;
            this.m_score = score;
        }

        public int getPriority() {
            return this.m_score;
        }

        @Nonnull
        public IFilterRequestHandler getHandler() {
            return this.m_handler;
        }
    }
}

