/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.login.IUser;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.AppSession;
import to.etc.domui.state.UIContext;
import to.etc.domui.state.UserLogItem;
import to.etc.domui.util.DomUtil;
import to.etc.smtp.Address;
import to.etc.smtp.MailBuilder;
import to.etc.smtp.Message;
import to.etc.util.LineIterator;
import to.etc.util.StringTool;
import to.etc.webapp.mailer.BulkMailer;

public class ExceptionUtil {
    @Nonnull
    private final RequestContextImpl m_ctx;

    public ExceptionUtil(@Nonnull RequestContextImpl ri) {
        this.m_ctx = ri;
    }

    public String renderParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table class='listtbl'>\n");
        sb.append("<thead><tr>\n");
        sb.append("<th>name</th><th>Value</th>");
        sb.append("</tr></thead>\n");
        String[] names = this.m_ctx.getParameterNames();
        if (names != null) {
            for (String name : names) {
                boolean first = true;
                String[] values = this.m_ctx.getParameters(name);
                if (values == null || values.length == 0) {
                    sb.append("<tr><td>").append(StringTool.htmlStringize((String)name)).append("</td><td>No value</td></tr>");
                    continue;
                }
                for (String value : values) {
                    sb.append("<tr><td>");
                    if (first) {
                        sb.append(StringTool.htmlStringize((String)name));
                    } else {
                        sb.append("\u00a0");
                    }
                    first = false;
                    sb.append("</td><td>");
                    sb.append(StringTool.htmlStringize((String)value));
                    sb.append("</td></tr>");
                }
            }
        }
        sb.append("</table>");
        return sb.toString();
    }

    @Nonnull
    public List<UserLogItem> getUserLog() {
        AppSession session = this.m_ctx.getSession();
        return session.getLogItems();
    }

    @Nullable
    public String lastName(@Nullable String name) {
        if (null == name) {
            return null;
        }
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public void renderEmail(@Nonnull Throwable x) {
        String addr = DomApplication.get().getProblemMailAddress();
        if (null == addr) {
            return;
        }
        String subj = DomApplication.get().getProblemMailSubject();
        if (null == subj) {
            return;
        }
        String from = DomApplication.get().getProblemFromAddress();
        if (null == from) {
            return;
        }
        try {
            InetAddress host = InetAddress.getLocalHost();
            subj = subj + " (" + host.getCanonicalHostName() + ")";
        }
        catch (Exception host) {
            // empty catch block
        }
        MailBuilder mb = new MailBuilder();
        mb.initialize(subj);
        mb.append("A problem occurred in this DomUI application: ").append(x.toString()).nl();
        mb.nl();
        try {
            InetAddress host = InetAddress.getLocalHost();
            mb.append("Server: ").append(host.getCanonicalHostName()).append(", ").append(host.getHostAddress()).nl();
        }
        catch (Exception host) {
            // empty catch block
        }
        try {
            IUser user = UIContext.getCurrentUser();
            if (null != user) {
                mb.append("User name: ").append(user.getDisplayName()).append(", login id ").append(user.getLoginID()).nl();
            }
        }
        catch (Exception user) {
            // empty catch block
        }
        mb.ttl("Exception stack trace");
        StringBuilder sb = new StringBuilder();
        DomUtil.dumpException(sb, x);
        for (String[] s : new LineIterator(sb.toString())) {
            mb.append((String)s).nl();
        }
        mb.nl();
        mb.ttl("Page input parameters");
        String[] names = this.m_ctx.getParameterNames();
        if (names != null) {
            for (String name : names) {
                boolean first = true;
                String[] values = this.m_ctx.getParameters(name);
                if (values == null || values.length == 0) {
                    mb.b(name).append(": ");
                    mb.append("No value").nl();
                    continue;
                }
                for (String value : values) {
                    if (first) {
                        mb.b(name).append(": ");
                    } else {
                        mb.append(StringTool.strToFixedLength((String)"", (int)name.length())).append(": ");
                    }
                    first = false;
                    mb.append(value).nl();
                }
            }
        }
        mb.nl();
        mb.ttl("Click/event stream (new to old)");
        AppSession session = this.m_ctx.getSession();
        mb.append(StringTool.strToFixedLength((String)"Time", (int)12));
        mb.append(StringTool.strToFixedLength((String)"CID", (int)30));
        mb.append(StringTool.strToFixedLength((String)"Page", (int)24));
        mb.append("Message").nl();
        ArrayList<UserLogItem> logItems = new ArrayList<UserLogItem>(session.getLogItems());
        Collections.reverse(logItems);
        for (UserLogItem li : logItems) {
            mb.append(StringTool.strToFixedLength((String)li.time(), (int)12));
            mb.append(StringTool.strToFixedLength((String)li.getCid(), (int)30));
            mb.append(StringTool.strToFixedLength((String)this.lastName(li.getPage()), (int)24));
            mb.append(li.getText()).nl();
        }
        Message m = mb.createMessage();
        m.addTo(new Address(addr));
        m.setFrom(new Address(from, from));
        try {
            BulkMailer.getInstance().store(m);
        }
        catch (Exception xxx) {
            xxx.printStackTrace();
        }
    }
}

