/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.HttpServerSession;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.IRequestResponse;
import to.etc.domui.server.IServerSession;
import to.etc.domui.util.upload.UploadHttpRequestWrapper;
import to.etc.domui.util.upload.UploadItem;
import to.etc.domui.util.upload.UploadParser;
import to.etc.net.NetTools;
import to.etc.webapp.core.ServerTools;

public class HttpServerRequestResponse
implements IRequestResponse {
    @Nonnull
    private final HttpServletRequest m_request;
    @Nonnull
    private final HttpServletResponse m_response;
    @Nonnull
    private final String m_webappContext;
    private IServerSession m_serverSession;

    private HttpServerRequestResponse(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull String webappContext) {
        this.m_request = request;
        this.m_response = response;
        this.m_webappContext = webappContext;
    }

    @Override
    @Nonnull
    public String getRequestURI() {
        return this.m_request.getRequestURI();
    }

    @Override
    @Nonnull
    public String getQueryString() {
        return this.m_request.getQueryString();
    }

    @Nonnull
    public HttpServletRequest getRequest() {
        return this.m_request;
    }

    @Nonnull
    public HttpServletResponse getResponse() {
        return this.m_response;
    }

    @Override
    @Nonnull
    public String getWebappContext() {
        return this.m_webappContext;
    }

    @Nonnull
    public static HttpServerRequestResponse create(@Nonnull DomApplication application, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        String webapp = request.getContextPath();
        if (webapp == null) {
            webapp = "";
        } else {
            if (webapp.startsWith("/")) {
                webapp = webapp.substring(1);
            }
            if (!webapp.endsWith("/")) {
                webapp = webapp + "/";
            }
        }
        String requesturi = request.getRequestURI();
        int pos = requesturi.lastIndexOf(46);
        String extension = pos < 0 ? "" : requesturi.substring(pos + 1).toLowerCase();
        HttpServletRequest realrequest = request;
        if (application.getUrlExtension().equals(extension) || requesturi.contains(".part")) {
            realrequest = UploadParser.wrapIfNeeded(request);
        }
        return new HttpServerRequestResponse(realrequest, response, webapp);
    }

    @Override
    public void releaseUploads() {
        if (!(this.m_request instanceof UploadHttpRequestWrapper)) {
            return;
        }
        UploadHttpRequestWrapper w = (UploadHttpRequestWrapper)this.m_request;
        w.releaseFiles();
    }

    @Override
    @Nonnull
    public String getUserAgent() {
        return this.m_request.getHeader("user-agent");
    }

    @Override
    @Nonnull
    public String getApplicationURL() {
        return NetTools.getApplicationURL((HttpServletRequest)this.getRequest());
    }

    @Override
    @Nonnull
    public String getHostURL() {
        return NetTools.getHostURL((HttpServletRequest)this.getRequest());
    }

    @Override
    @Nullable
    public String getParameter(@Nonnull String name) {
        return this.getRequest().getParameter(name);
    }

    @Override
    @Nonnull
    public String[] getParameters(@Nonnull String name) {
        return this.getRequest().getParameterValues(name);
    }

    @Override
    @Nonnull
    public String[] getParameterNames() {
        return this.getRequest().getParameterMap().keySet().toArray(new String[this.getRequest().getParameterMap().size()]);
    }

    @Override
    @Nonnull
    public String[] getFileParameters() throws Exception {
        if (!(this.m_request instanceof UploadHttpRequestWrapper)) {
            return new String[0];
        }
        UploadHttpRequestWrapper urw = (UploadHttpRequestWrapper)this.m_request;
        return urw.getFileItemMap().keySet().toArray(new String[urw.getFileItemMap().size()]);
    }

    @Override
    @Nonnull
    public UploadItem[] getFileParameter(@Nonnull String name) throws Exception {
        if (!(this.m_request instanceof UploadHttpRequestWrapper)) {
            return new UploadItem[0];
        }
        UploadHttpRequestWrapper urw = (UploadHttpRequestWrapper)this.m_request;
        return urw.getFileItems(name);
    }

    @Override
    public void setNoCache() {
        ServerTools.generateNoCache((HttpServletResponse)this.getResponse());
    }

    @Override
    public void setExpiry(int cacheTime) {
        ServerTools.generateExpiryHeader((HttpServletResponse)this.getResponse(), (int)cacheTime);
    }

    @Override
    @Nonnull
    public Writer getOutputWriter(@Nonnull String contentType, @Nullable String encoding) throws IOException {
        this.getResponse().setContentType(contentType);
        if (null != encoding) {
            this.getResponse().setCharacterEncoding(encoding);
        }
        return this.getResponse().getWriter();
    }

    @Override
    @Nonnull
    public OutputStream getOutputStream(@Nonnull String contentType, @Nullable String encoding, int contentLength) throws Exception {
        this.getResponse().setContentType(contentType);
        if (null != encoding) {
            this.getResponse().setCharacterEncoding(encoding);
        }
        if (contentLength > 0) {
            this.getResponse().setContentLength(contentLength);
        }
        return this.getResponse().getOutputStream();
    }

    @Override
    public void redirect(@Nonnull String newUrl) throws Exception {
        this.getResponse().sendRedirect(newUrl);
    }

    @Override
    public void sendError(int httpErrorCode, @Nonnull String message) throws Exception {
        this.getResponse().sendError(httpErrorCode, message);
    }

    @Override
    public void addHeader(@Nonnull String name, @Nonnull String value) {
        this.getResponse().addHeader(name, value);
    }

    @Override
    public void addCookie(@Nonnull Cookie cookie) {
        cookie.setDomain(NetTools.getHostName((HttpServletRequest)this.getRequest()));
        this.getResponse().addCookie(cookie);
    }

    @Override
    @Nonnull
    public Cookie[] getCookies() {
        return this.getRequest().getCookies();
    }

    @Override
    @Nullable
    public String getRemoteUser() {
        return this.getRequest().getRemoteUser();
    }

    @Override
    @Nullable
    public IServerSession getServerSession(boolean create) {
        HttpSession ses;
        IServerSession ss = this.m_serverSession;
        if (ss == null && null != (ses = this.getRequest().getSession(create))) {
            this.m_serverSession = ss = new HttpServerSession(ses);
        }
        return ss;
    }

    @Nullable
    public static HttpServerRequestResponse get(@Nonnull IRequestContext ctx) {
        IRequestResponse rr = ctx.getRequestResponse();
        if (rr instanceof HttpServerRequestResponse) {
            return (HttpServerRequestResponse)rr;
        }
        return null;
    }
}

