/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import to.etc.domui.server.AbstractContextMaker;
import to.etc.domui.server.ConfigParameters;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.HttpServerRequestResponse;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.AppSession;

public final class NormalContextMaker
extends AbstractContextMaker {
    @Nonnull
    private final String m_applicationClassName;
    private DomApplication m_application;

    public NormalContextMaker(@Nonnull String applicationClassName, @Nonnull ConfigParameters pp) throws Exception {
        super(pp);
        Class<?> clz;
        this.m_applicationClassName = applicationClassName;
        try {
            clz = this.getClass().getClassLoader().loadClass(applicationClassName);
        }
        catch (ClassNotFoundException x) {
            throw new IllegalStateException("The main application class '" + this.m_applicationClassName + "' cannot be found: " + x, x);
        }
        try {
            this.m_application = (DomApplication)clz.newInstance();
        }
        catch (Exception x) {
            throw new IllegalStateException("The main application class '" + this.m_applicationClassName + "' cannot be INSTANTIATED: " + x, x);
        }
        this.m_application.internalInitialize(pp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain) throws Exception {
        AppSession appSession;
        HttpSession sess;
        HttpSession httpSession = sess = request.getSession(true);
        synchronized (httpSession) {
            appSession = (AppSession)sess.getAttribute(AppSession.class.getName());
            if (appSession == null) {
                appSession = this.m_application.createSession();
                sess.setAttribute(AppSession.class.getName(), (Object)appSession);
            }
        }
        HttpServerRequestResponse requestResponse = HttpServerRequestResponse.create(this.m_application, request, response);
        RequestContextImpl ctx = new RequestContextImpl(requestResponse, this.m_application, appSession);
        this.execute(requestResponse, ctx, chain);
    }
}

