/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.server.AbstractContextMaker;
import to.etc.domui.server.AppFilter;
import to.etc.domui.server.ConfigParameters;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.HttpServerRequestResponse;
import to.etc.domui.server.IReloadListener;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.reloader.IReloadedClassesListener;
import to.etc.domui.server.reloader.Reloader;
import to.etc.domui.state.AppSession;
import to.etc.domui.state.HttpSessionLink;
import to.etc.webapp.nls.BundleRef;

public class ReloadingContextMaker
extends AbstractContextMaker {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadingContextMaker.class);
    private String m_applicationClassName;
    private ConfigParameters m_config;
    private Reloader m_reloader;
    private DomApplication m_application;
    private int m_nestCount;
    private Set<IReloadedClassesListener> m_listenerSet = new HashSet<IReloadedClassesListener>();
    private static ReloadingContextMaker m_instance;
    @Nonnull
    public static List<IReloadListener> m_reloadListener;
    private static long m_lastReloadTime;

    public ReloadingContextMaker(@Nonnull String applicationClassName, @Nonnull ConfigParameters pp, @Nullable String patterns, @Nullable String patternsWatchOnly) throws Exception {
        super(pp);
        m_instance = this;
        this.m_applicationClassName = applicationClassName;
        this.m_config = pp;
        this.m_reloader = new Reloader(patterns, patternsWatchOnly);
        System.out.println("DomUI: We are running in DEVELOPMENT mode. This will be VERY slow when used in a production environment.");
        this.checkReload();
    }

    public static synchronized void addReloadListener(IReloadListener l) {
        m_reloadListener = new ArrayList<IReloadListener>(m_reloadListener);
        m_reloadListener.add(l);
    }

    private static synchronized List<IReloadListener> listeners() {
        return m_reloadListener;
    }

    public static Class<?> loadClass(String name) throws Exception {
        if (m_instance != null) {
            return m_instance.getReloader().getReloadingLoader().loadClass(name);
        }
        return ReloadingContextMaker.class.getClassLoader().loadClass(name);
    }

    public Reloader getReloader() {
        return this.m_reloader;
    }

    private static synchronized void reloaded() {
        m_lastReloadTime = System.currentTimeMillis();
    }

    public static synchronized long getLastReload() {
        return m_lastReloadTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain) throws Exception {
        ReloadingContextMaker reloadingContextMaker = this;
        synchronized (reloadingContextMaker) {
            if (this.m_nestCount == 0) {
                this.checkReload();
            }
            ++this.m_nestCount;
        }
        try {
            HttpSessionLink link;
            HttpSession sess;
            HttpSession httpSession = sess = request.getSession(true);
            synchronized (httpSession) {
                link = (HttpSessionLink)sess.getAttribute(AppSession.class.getName());
                if (link == null) {
                    link = new HttpSessionLink(sess, this);
                    sess.setAttribute(AppSession.class.getName(), (Object)link);
                    this.addListener(link);
                }
            }
            DomApplication application = this.m_application;
            if (null == application) {
                throw new IllegalStateException("Application not loaded/known");
            }
            AppSession ass = link.getAppSession(application);
            HttpServerRequestResponse requestResponse = HttpServerRequestResponse.create(application, request, response);
            RequestContextImpl ctx = new RequestContextImpl(requestResponse, application, ass);
            this.execute(requestResponse, ctx, chain);
        }
        finally {
            reloadingContextMaker = this;
            synchronized (reloadingContextMaker) {
                --this.m_nestCount;
            }
        }
    }

    private void checkReload() throws Exception {
        Class<DomApplication> clz;
        LOG.debug("Checking for reload");
        if (this.m_application == null) {
            this.m_application = this.createApplication();
            ReloadingContextMaker.reloaded();
            return;
        }
        if (!this.m_reloader.isChanged()) {
            return;
        }
        LOG.info("Reloading system");
        for (IReloadedClassesListener l : this.getListeners()) {
            try {
                l.classesReloaded();
            }
            catch (Exception x) {
                AppFilter.LOG.error("Error calling listener: " + x, (Throwable)x);
            }
        }
        this.m_reloader.clear();
        ReloadingContextMaker.reloaded();
        try {
            clz = this.m_reloader.loadApplication(this.m_applicationClassName);
        }
        catch (ClassNotFoundException x) {
            throw new IllegalStateException("The main application class '" + this.m_applicationClassName + "' cannot be found: " + x, x);
        }
        if (this.m_application != null) {
            MetaManager.internalClear();
            BundleRef.internalClear();
            for (IReloadListener ll : ReloadingContextMaker.listeners()) {
                try {
                    ll.reloaded(this.m_reloader.getReloadingLoader());
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            Class<?> oclz = this.m_application.getClass();
            System.out.println("OLD app = " + oclz + ", loaded by " + oclz.getClassLoader());
            System.out.println("NEW app = " + clz + ", loaded by " + clz.getClassLoader());
            if (clz.isAssignableFrom(oclz)) {
                return;
            }
            DomApplication old = this.m_application;
            this.m_application = null;
            old.internalDestroy();
        }
        this.m_application = this.createApplication();
    }

    private DomApplication createApplication() throws Exception {
        DomApplication a;
        Class<DomApplication> clz;
        try {
            clz = this.m_reloader.loadApplication(this.m_applicationClassName);
        }
        catch (ClassNotFoundException x) {
            throw new IllegalStateException("The main application class '" + this.m_applicationClassName + "' cannot be found: " + x, x);
        }
        try {
            DomApplication o;
            a = o = clz.newInstance();
        }
        catch (Exception x) {
            System.out.println("DomApplication classloader: " + DomApplication.class.getClassLoader());
            System.out.println("Instance classloader: " + clz.getClassLoader());
            Class<DomApplication> pc = clz.getSuperclass();
            System.out.println("Instance superclass=" + pc);
            System.out.println("Instance superclass classloader: " + pc.getClassLoader());
            throw new IllegalStateException("The main application class '" + this.m_applicationClassName + "' cannot be INSTANTIATED: " + x, x);
        }
        a.internalInitialize(this.m_config, true);
        return a;
    }

    public synchronized void addListener(IReloadedClassesListener l) {
        this.m_listenerSet = new HashSet<IReloadedClassesListener>(this.m_listenerSet);
        this.m_listenerSet.add(l);
    }

    public synchronized void removeListener(IReloadedClassesListener l) {
        this.m_listenerSet = new HashSet<IReloadedClassesListener>(this.m_listenerSet);
        this.m_listenerSet.remove(l);
    }

    private Set<IReloadedClassesListener> getListeners() {
        return this.m_listenerSet;
    }

    static {
        m_reloadListener = new ArrayList<IReloadListener>();
    }
}

