/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.server.BrowserVersion;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IAttributeContainer;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.IRequestResponse;
import to.etc.domui.server.IServerSession;
import to.etc.domui.state.AppSession;
import to.etc.domui.state.CidPair;
import to.etc.domui.state.WindowSession;
import to.etc.domui.util.upload.UploadItem;
import to.etc.util.FileTool;

public class RequestContextImpl
implements IRequestContext,
IAttributeContainer {
    @Nonnull
    private final DomApplication m_application;
    @Nonnull
    private final AppSession m_session;
    @Nonnull
    private final IRequestResponse m_requestResponse;
    private WindowSession m_windowSession;
    private StringWriter m_sw;
    private Writer m_outWriter;
    private BrowserVersion m_browserVersion;
    private Map<String, Object> m_attributeMap = Collections.EMPTY_MAP;
    @Nonnull
    private final String m_urlin;
    @Nonnull
    private final String m_extension;
    private static final int PAGE_HEADER_BUFFER_LENGTH = 4000;
    private boolean m_amLockingSession;
    private String m_outputContentType;
    private String m_outputEncoding;
    private Exception m_outputAllocated;

    public RequestContextImpl(@Nonnull IRequestResponse rr, @Nonnull DomApplication app, @Nonnull AppSession ses) {
        this.m_requestResponse = rr;
        this.m_application = app;
        this.m_session = ses;
        String urlin = rr.getRequestURI();
        while (urlin.startsWith("/")) {
            urlin = urlin.substring(1);
        }
        int pos = urlin.lastIndexOf(46);
        this.m_extension = pos < 0 ? "" : urlin.substring(pos + 1).toLowerCase();
        String webapp = rr.getWebappContext();
        if (webapp.length() > 0) {
            if (!urlin.startsWith(webapp)) {
                throw new IllegalStateException("webapp url '" + urlin + "' incorrect: it does not start with '" + webapp + "'");
            }
            urlin = urlin.substring(webapp.length());
            while (urlin.startsWith("/")) {
                urlin = urlin.substring(1);
            }
        }
        this.m_urlin = urlin;
    }

    @Override
    @Nonnull
    public final DomApplication getApplication() {
        return this.m_application;
    }

    @Override
    @Nonnull
    public final AppSession getSession() {
        this.m_session.internalLockSession();
        if (!this.m_amLockingSession) {
            this.m_session.internalCheckExpiredWindowSessions();
        }
        this.m_amLockingSession = true;
        return this.m_session;
    }

    @Override
    @Nonnull
    public IRequestResponse getRequestResponse() {
        return this.m_requestResponse;
    }

    public final void internalSetWindowSession(WindowSession cm) {
        this.m_windowSession = cm;
    }

    @Override
    @Nonnull
    public final WindowSession getWindowSession() {
        if (this.m_windowSession != null) {
            return this.m_windowSession;
        }
        String cid = this.getParameter("$cid");
        if (cid != null) {
            CidPair cida = CidPair.decode(cid);
            this.m_windowSession = this.getSession().findWindowSession(cida.getWindowId());
            if (this.m_windowSession != null) {
                return this.m_windowSession;
            }
        }
        throw new IllegalStateException("WindowSession is not known!!");
    }

    void internalUnlockSession() {
        if (this.m_amLockingSession) {
            this.m_session.internalUnlockSession();
            this.m_amLockingSession = false;
        }
    }

    private void internalDetachConversations() {
        if (this.m_windowSession != null) {
            this.getWindowSession().internalDetachConversations();
        }
    }

    private void internalReleaseUploads() {
        this.m_requestResponse.releaseUploads();
    }

    public void internalOnRequestFinished() {
        this.internalDetachConversations();
        this.internalReleaseUploads();
        this.internalUnlockSession();
    }

    @Override
    @Nonnull
    public String getExtension() {
        return this.m_extension;
    }

    @Override
    @Nonnull
    public final String getInputPath() {
        return this.m_urlin;
    }

    @Override
    public String getUserAgent() {
        return this.m_requestResponse.getUserAgent();
    }

    @Override
    public BrowserVersion getBrowserVersion() {
        if (this.m_browserVersion == null) {
            this.m_browserVersion = BrowserVersion.parseUserAgent(this.getUserAgent());
        }
        return this.m_browserVersion;
    }

    public void flush() throws Exception {
        if (this.m_sw != null) {
            String outputContentType;
            if (this.getApplication().logOutput()) {
                String res = this.m_sw.getBuffer().toString();
                File tgt = new File("/tmp/last-domui-output.xml");
                try {
                    FileTool.writeFileFromString((File)tgt, (String)res, (String)"utf-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("---- rendered output:");
                System.out.println(res);
                System.out.println("---- end");
            }
            if (null == (outputContentType = this.m_outputContentType)) {
                throw new IllegalStateException("The content type for buffered output is not set.");
            }
            Writer ow = this.getRequestResponse().getOutputWriter(outputContentType, this.m_outputEncoding);
            ow.append(this.m_sw.getBuffer());
            this.m_sw = null;
        }
    }

    public void discard() throws IOException {
    }

    @Override
    @Nonnull
    public String getRelativePath(@Nonnull String rel) {
        StringBuilder sb = new StringBuilder(rel.length() + 128);
        sb.append(this.m_requestResponse.getApplicationURL());
        sb.append(rel);
        return sb.toString();
    }

    @Override
    @Nonnull
    public Writer getOutputWriter(@Nonnull String contentType, @Nullable String encoding) throws IOException {
        StringWriter sw = this.m_sw;
        if (null != sw && sw.getBuffer().length() > 4000) {
            System.out.println("domui warning: outputwriter reallocated after writing " + sw.getBuffer().length() + " characters of data already");
        }
        this.m_outputContentType = contentType;
        this.m_outputEncoding = encoding;
        this.m_sw = new StringWriter(8192);
        this.m_outWriter = this.m_sw;
        return this.m_outWriter;
    }

    public void redirect(@Nonnull String newUrl) throws Exception {
        this.getRequestResponse().redirect(newUrl);
    }

    public void sendError(int httpErrorCode, @Nonnull String message) throws Exception {
        this.getRequestResponse().sendError(httpErrorCode, message);
    }

    @Override
    @Nullable
    public IServerSession getServerSession(boolean create) {
        return this.getRequestResponse().getServerSession(create);
    }

    @Override
    @Nullable
    public String getParameter(@Nonnull String name) {
        return this.m_requestResponse.getParameter(name);
    }

    @Override
    @Nonnull
    public String[] getParameters(@Nonnull String name) {
        return this.m_requestResponse.getParameters(name);
    }

    @Override
    @Nonnull
    public String[] getParameterNames() {
        return this.m_requestResponse.getParameterNames();
    }

    public String[] getFileParameters() throws Exception {
        return this.m_requestResponse.getFileParameters();
    }

    public UploadItem[] getFileParameter(@Nonnull String name) throws Exception {
        return this.m_requestResponse.getFileParameter(name);
    }

    @Override
    public Object getAttribute(@Nonnull String name) {
        return this.m_attributeMap.get(name);
    }

    @Override
    public void setAttribute(@Nonnull String name, @Nullable Object value) {
        if (this.m_attributeMap == Collections.EMPTY_MAP) {
            this.m_attributeMap = new HashMap<String, Object>();
        }
        if (value == null) {
            this.m_attributeMap.remove(name);
        } else {
            this.m_attributeMap.put(name, value);
        }
    }
}

