/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class ServerClientRegistry {
    @Nonnull
    private static final ServerClientRegistry m_instance = new ServerClientRegistry();
    @Nonnull
    private final Map<String, List<Client>> m_userMap = new HashMap<String, List<Client>>();

    @Nonnull
    public static ServerClientRegistry getInstance() {
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerRequest(@Nonnull HttpServletRequest req, @Nonnull String remoteUser) {
        try {
            if (req == null) {
                throw new IllegalStateException("??");
            }
            HttpSession ses = req.getSession(false);
            if (ses == null) {
                return;
            }
            String rt = req.getParameter("webuia");
            if ("pollasy".equals(rt)) {
                return;
            }
            long ts = System.currentTimeMillis();
            Map<String, List<Client>> map = this.m_userMap;
            synchronized (map) {
                List<Use> ul;
                Client c;
                List<Client> list = this.m_userMap.get(remoteUser);
                if (list == null) {
                    list = new ArrayList<Client>(4);
                    this.m_userMap.put(remoteUser, list);
                }
                if ((c = ServerClientRegistry.findClient(list, req.getRemoteAddr())) == null) {
                    c = new Client(req.getRemoteAddr(), req.getRemoteHost(), remoteUser, ts);
                    list.add(c);
                    ses.setAttribute(this.getClass().getName(), (Object)c);
                }
                Use u = (ul = c.getLastUseList()).size() < 5 ? new Use() : ul.remove(0);
                ul.add(u);
                u.update(req.getRequestURI(), ts);
                c.update(ts);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Nullable
    private static Client findClient(@Nonnull List<Client> list, @Nonnull String a) {
        for (Client c : list) {
            if (!c.getRemoteAddress().equals(a)) continue;
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterUser(@Nonnull Client c) {
        Map<String, List<Client>> map = this.m_userMap;
        synchronized (map) {
            List<Client> list = this.m_userMap.get(c.getRemoteUser());
            if (list == null) {
                return;
            }
            list.remove(c);
        }
    }

    @Nonnull
    private Client dupClient(@Nonnull Client in) {
        Client c = new Client();
        c.m_nRequests = in.m_nRequests;
        c.m_remoteAddress = in.m_remoteAddress;
        c.m_remoteHost = in.m_remoteHost;
        c.m_remoteUser = in.m_remoteUser;
        c.m_tsLastRequest = in.m_tsLastRequest;
        c.m_tsSessionStart = in.m_tsSessionStart;
        ArrayList<Use> nul = new ArrayList<Use>(in.getLastUseList().size());
        for (Use u : in.getLastUseList()) {
            Use nu = new Use();
            nu.m_timeStamp = u.m_timeStamp;
            nu.m_url = u.m_url;
            nul.add(nu);
        }
        c.m_lastUseList = nul;
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<Client> getActiveClients() {
        ArrayList<Client> res = new ArrayList<Client>();
        Map<String, List<Client>> map = this.m_userMap;
        synchronized (map) {
            for (List<Client> list : this.m_userMap.values()) {
                for (Client c : list) {
                    res.add(this.dupClient(c));
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<String> getActiveLogins() {
        TreeSet<String> idmap = new TreeSet<String>();
        Map<String, List<Client>> map = this.m_userMap;
        synchronized (map) {
            for (List<Client> list : this.m_userMap.values()) {
                for (Client c : list) {
                    idmap.add(c.getRemoteUser());
                }
            }
        }
        return idmap;
    }

    public final class Client
    implements HttpSessionBindingListener {
        private String m_remoteAddress;
        private String m_remoteHost;
        private String m_remoteUser;
        private List<Use> m_lastUseList = new ArrayList<Use>();
        private long m_tsSessionStart;
        private long m_tsLastRequest;
        private int m_nRequests;

        Client() {
        }

        Client(String addr, String hn, String user, long ts) {
            this.m_remoteAddress = addr;
            this.m_remoteHost = hn;
            this.m_remoteUser = user;
            this.m_nRequests = 1;
            this.m_tsLastRequest = this.m_tsSessionStart = ts;
        }

        public String getRemoteAddress() {
            return this.m_remoteAddress;
        }

        public String getRemoteHost() {
            return this.m_remoteHost;
        }

        public String getRemoteUser() {
            return this.m_remoteUser;
        }

        public List<Use> getLastUseList() {
            return this.m_lastUseList;
        }

        public long getTsSessionStart() {
            return this.m_tsSessionStart;
        }

        public long getTsLastRequest() {
            return this.m_tsLastRequest;
        }

        public int getNRequests() {
            return this.m_nRequests;
        }

        void update(long ts) {
            this.m_tsLastRequest = ts;
            ++this.m_nRequests;
        }

        public void valueBound(HttpSessionBindingEvent arg0) {
        }

        public void valueUnbound(HttpSessionBindingEvent arg0) {
            ServerClientRegistry.this.unregisterUser(this);
        }
    }

    public static final class Use {
        private long m_timeStamp;
        @Nullable
        private String m_url;

        void update(@Nonnull String url, long ts) {
            this.m_url = url;
            this.m_timeStamp = ts;
        }

        public long getTimeStamp() {
            return this.m_timeStamp;
        }

        @Nonnull
        public String getUrl() {
            if (null != this.m_url) {
                return this.m_url;
            }
            throw new IllegalStateException("update() not called");
        }
    }
}

