/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class WrappedHttpServetResponse
extends HttpServletResponseWrapper {
    @Nullable
    private String m_ieEmulation;
    private boolean m_flushed;
    private ServletOutputStream m_sos;
    private ServletOutputStream m_wrappedos;
    private PrintWriter m_wr;
    private PrintWriter m_wrappedwr;
    private byte[] m_buffer;
    private int m_bix;
    private int m_blen;
    private char[] m_chbuffer;
    private final String m_url;

    public WrappedHttpServetResponse(@Nonnull String url, @Nonnull HttpServletResponse resp, @Nonnull String defaultVersion) {
        super(resp);
        this.m_url = url;
        this.m_blen = 8192;
        this.m_ieEmulation = defaultVersion;
    }

    public void setIeEmulationMode(@Nullable String compatible) throws IOException {
        if (this.m_flushed) {
            throw new RuntimeException("InternetExplorer filter: output already flushed - cannot remove IE emulation header anymore! Move this call to the BEGINNING of the page.");
        }
        this.m_ieEmulation = compatible;
        this.internalFlush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.m_wrappedwr != null) {
            throw new IllegalStateException("Attempting to allocate an output stream but a writer was allocated earlier");
        }
        if (this.m_sos == null) {
            this.m_sos = super.getOutputStream();
            this.m_buffer = new byte[this.m_blen];
            this.m_wrappedos = new WrappedOS();
        }
        return this.m_wrappedos;
    }

    void writeByte(int b) throws IOException {
        if (this.m_flushed) {
            this.m_sos.write(b);
        } else {
            this.m_buffer[this.m_bix++] = (byte)b;
            if (this.m_bix >= this.m_blen) {
                this.internalFlush();
            }
        }
    }

    public void writeBuffer(byte[] b, int off, int len) throws IOException {
        if (this.m_flushed) {
            this.m_sos.write(b, off, len);
        } else if (this.m_bix + len >= this.m_blen) {
            this.internalFlush();
            this.m_sos.write(b, off, len);
        } else {
            System.arraycopy(b, off, this.m_buffer, this.m_bix, len);
            this.m_bix += len;
        }
    }

    public PrintWriter getWriter() throws IOException {
        if (this.m_sos != null) {
            throw new IllegalStateException("Attempting to allocate a Writer, but a stream was allocated earlier!");
        }
        if (this.m_wr == null) {
            this.m_chbuffer = new char[this.m_blen];
            this.m_wr = super.getWriter();
            this.m_wrappedwr = new PrintWriter(new WrappedWriter());
        }
        return this.m_wrappedwr;
    }

    public void writeCharacters(char[] b, int off, int len) throws IOException {
        if (this.m_flushed) {
            this.m_wr.write(b, off, len);
        } else if (this.m_bix + len >= this.m_blen) {
            this.internalFlush();
            this.m_wr.write(b, off, len);
        } else {
            System.arraycopy(b, off, this.m_chbuffer, this.m_bix, len);
            this.m_bix += len;
        }
    }

    public void flushBuffer() throws IOException {
        this.internalFlush();
        super.flushBuffer();
    }

    private void internalFlush() throws IOException {
        if (this.m_flushed) {
            return;
        }
        if (this.m_ieEmulation != null) {
            this.addHeader("X-UA-Compatible", this.m_ieEmulation);
        }
        if (this.m_bix > 0) {
            if (this.m_wr != null) {
                this.m_wr.write(this.m_chbuffer, 0, this.m_bix);
                this.m_chbuffer = null;
            } else {
                this.m_sos.write(this.m_buffer, 0, this.m_bix);
                this.m_buffer = null;
            }
            this.m_blen = 0;
            this.m_bix = 0;
        }
        this.m_flushed = true;
    }

    private class WrappedOS
    extends ServletOutputStream {
        public void write(int b) throws IOException {
            WrappedHttpServetResponse.this.writeByte(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            WrappedHttpServetResponse.this.writeBuffer(b, off, len);
        }

        public void close() throws IOException {
            super.close();
        }
    }

    private class WrappedWriter
    extends Writer {
        @Override
        public void close() throws IOException {
            WrappedHttpServetResponse.this.flushBuffer();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] buf, int off, int len) throws IOException {
            WrappedHttpServetResponse.this.writeCharacters(buf, off, len);
        }
    }
}

