/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server.parts;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.annotation.Nonnull;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IExtendedParameterInfo;
import to.etc.domui.server.parts.IBufferedPartFactory;
import to.etc.domui.server.parts.PartResponse;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.domui.util.resources.ResourceDependencyList;
import to.etc.net.HttpCallException;
import to.etc.util.FileTool;
import to.etc.webapp.core.ServerTools;
import to.etc.webapp.nls.NlsContext;

public final class InternalResourcePart
implements IBufferedPartFactory {
    @Override
    @Nonnull
    public Object decodeKey(@Nonnull String rurl, @Nonnull IExtendedParameterInfo param) throws Exception {
        if (FileTool.getFileExtension((String)rurl).length() == 0) {
            throw new HttpCallException("", 403, "Request forbidden for directory " + rurl);
        }
        Locale loc = null;
        int pos = rurl.lastIndexOf(".nls.");
        if (-1 != pos) {
            loc = NlsContext.getLocale();
            rurl = rurl.substring(0, pos) + rurl.substring(pos + 5);
        }
        if (rurl.endsWith(".class")) {
            throw new ThingyNotFoundException(rurl);
        }
        return new ResKey(loc, rurl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(@Nonnull PartResponse pr, @Nonnull DomApplication da, @Nonnull Object inkey, @Nonnull IResourceDependencyList rdl) throws Exception {
        ResKey k = (ResKey)inkey;
        if (k.getLoc() != null) {
            throw new IllegalStateException("Locale in resource not implemented.");
        }
        String rurl = k.getRURL();
        IResourceRef ires = da.getResource(rurl, da.inDevelopmentMode() ? rdl : ResourceDependencyList.NULL);
        if (!da.inDevelopmentMode()) {
            pr.setCacheTime(da.getDefaultExpiryTime());
        }
        pr.setMime(ServerTools.getExtMimeType((String)FileTool.getFileExtension((String)rurl)));
        InputStream is = ires.getInputStream();
        if (is == null) {
            throw new ThingyNotFoundException(k.getRURL());
        }
        try {
            FileTool.copyFile((OutputStream)pr.getOutputStream(), (InputStream)is);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    private static class ResKey {
        private Locale m_loc;
        private String m_rurl;

        public ResKey(Locale loc, String rurl) {
            this.m_loc = loc;
            this.m_rurl = rurl;
        }

        public String toString() {
            return "[$resource " + this.m_rurl + "]";
        }

        public Locale getLoc() {
            return this.m_loc;
        }

        public String getRURL() {
            return this.m_rurl;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_loc == null ? 0 : this.m_loc.hashCode());
            result = 31 * result + (this.m_rurl == null ? 0 : this.m_rurl.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResKey other = (ResKey)obj;
            if (this.m_loc == null ? other.m_loc != null : !this.m_loc.equals(other.m_loc)) {
                return false;
            }
            return !(this.m_rurl == null ? other.m_rurl != null : !this.m_rurl.equals(other.m_rurl));
        }
    }
}

