/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server.parts;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IFilterRequestHandler;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.parts.CachedPart;
import to.etc.domui.server.parts.IBufferedPartFactory;
import to.etc.domui.server.parts.IPartFactory;
import to.etc.domui.server.parts.IPartRenderer;
import to.etc.domui.server.parts.IUnbufferedPartFactory;
import to.etc.domui.server.parts.IUrlPart;
import to.etc.domui.server.parts.PartResponse;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.LRUHashMap;
import to.etc.domui.util.resources.ResourceDependencyList;
import to.etc.util.ByteBufferOutputStream;
import to.etc.util.DeveloperOptions;

public final class PartRequestHandler
implements IFilterRequestHandler {
    @Nonnull
    private final DomApplication m_application;
    private final boolean m_allowExpires;
    @Nonnull
    private final LRUHashMap<Object, CachedPart> m_cache;
    private final Map<String, IPartRenderer> m_partMap = new HashMap<String, IPartRenderer>();

    public PartRequestHandler(@Nonnull DomApplication application) {
        this.m_application = application;
        LRUHashMap.SizeCalculator<CachedPart> sc = new LRUHashMap.SizeCalculator<CachedPart>(){

            @Override
            public int getObjectSize(CachedPart item) {
                return item == null ? 4 : item.m_size + 32;
            }
        };
        this.m_cache = new LRUHashMap(sc, 0x1000000);
        this.m_allowExpires = DeveloperOptions.getBool((String)"domui.expires", (boolean)true);
    }

    @Override
    public boolean accepts(@Nonnull IRequestContext ri) throws Exception {
        String in = ri.getInputPath();
        if (in.endsWith(".part")) {
            return true;
        }
        int pos = in.indexOf(47);
        if (pos < 0) {
            return false;
        }
        String seg = in.substring(0, pos);
        return seg.endsWith(".part");
    }

    DomApplication getApplication() {
        return this.m_application;
    }

    @Override
    public void handleRequest(@Nonnull RequestContextImpl ctx) throws Exception {
        String rest;
        String fname;
        int pos;
        String input = ctx.getInputPath();
        boolean part = false;
        if (input.endsWith(".part")) {
            input = input.substring(0, input.length() - 5);
            part = true;
        }
        if ((pos = input.indexOf(47)) == -1) {
            fname = input;
            rest = "";
        } else {
            fname = input.substring(0, pos);
            rest = input.substring(pos + 1);
        }
        if (fname.endsWith(".part")) {
            fname = fname.substring(0, fname.length() - 5);
            part = true;
        }
        if (!part) {
            throw new ThingyNotFoundException("Not a part: " + input);
        }
        IPartRenderer pr = this.findPartRenderer(fname);
        if (pr == null) {
            throw new ThingyNotFoundException("The part factory '" + fname + "' cannot be located.");
        }
        pr.render(ctx, rest);
    }

    public void renderUrlPart(IUrlPart part, RequestContextImpl ctx) throws Exception {
        IPartRenderer pr = this.createPartRenderer(part);
        if (pr == null) {
            throw new ThingyNotFoundException("No renderer for " + part);
        }
        String input = ctx.getInputPath();
        pr.render(ctx, input);
    }

    private static final IPartFactory makePartInst(Class<?> fc) {
        try {
            return (IPartFactory)fc.newInstance();
        }
        catch (Exception x) {
            throw new IllegalStateException("Cannot instantiate PartFactory '" + fc + "': " + x, x);
        }
    }

    public synchronized IPartRenderer findPartRenderer(String name) {
        IPartRenderer pr = this.m_partMap.get(name);
        if (pr != null) {
            return pr;
        }
        Class<?> fc = DomUtil.findClass(this.getClass().getClassLoader(), name);
        if (fc == null) {
            return null;
        }
        if (!IPartFactory.class.isAssignableFrom(fc)) {
            throw new IllegalArgumentException("The class '" + name + "' does not implement the 'PartFactory' interface (it is not a part, I guess. WHAT ARE YOU DOING!? Access logged to administrator)");
        }
        final IPartFactory pf = PartRequestHandler.makePartInst(fc);
        if (pf instanceof IUnbufferedPartFactory) {
            pr = new IPartRenderer(){

                @Override
                public void render(RequestContextImpl ctx, String rest) throws Exception {
                    IUnbufferedPartFactory upf = (IUnbufferedPartFactory)pf;
                    upf.generate(PartRequestHandler.this.getApplication(), rest, ctx);
                }
            };
        } else if (pf instanceof IBufferedPartFactory) {
            pr = new IPartRenderer(){

                @Override
                public void render(RequestContextImpl ctx, String rest) throws Exception {
                    PartRequestHandler.this.generate((IBufferedPartFactory)pf, ctx, rest);
                }
            };
        } else {
            throw new IllegalStateException("??Internal: don't know how to handle part factory " + fc);
        }
        this.m_partMap.put(name, pr);
        return pr;
    }

    private IPartRenderer createPartRenderer(final IPartFactory pf) {
        if (pf instanceof IUnbufferedPartFactory) {
            return new IPartRenderer(){

                @Override
                public void render(RequestContextImpl ctx, String rest) throws Exception {
                    IUnbufferedPartFactory upf = (IUnbufferedPartFactory)pf;
                    upf.generate(PartRequestHandler.this.getApplication(), rest, ctx);
                }
            };
        }
        if (pf instanceof IBufferedPartFactory) {
            return new IPartRenderer(){

                @Override
                public void render(RequestContextImpl ctx, String rest) throws Exception {
                    PartRequestHandler.this.generate((IBufferedPartFactory)pf, ctx, rest);
                }
            };
        }
        throw new IllegalStateException("??Internal: don't know how to handle part factory " + pf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IBufferedPartFactory pf, RequestContextImpl ctx, String url) throws Exception {
        CachedPart cp = this.getCachedInstance(pf, ctx, url);
        OutputStream os = null;
        if (cp.m_cacheTime > 0 && this.m_allowExpires) {
            ctx.getRequestResponse().setExpiry(cp.getCacheTime());
        }
        try {
            os = ctx.getRequestResponse().getOutputStream(cp.getContentType(), null, cp.getSize());
            for (byte[] data : cp.getData()) {
                os.write(data);
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public CachedPart getCachedInstance(IBufferedPartFactory pf, RequestContextImpl ctx, String url) throws Exception {
        Object key = pf.decodeKey(url, ctx);
        if (key == null) {
            throw new ThingyNotFoundException("Cannot get resource for " + pf + " with rurl=" + url);
        }
        return this.getCachedInstance(pf, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedPart getCachedInstance(IBufferedPartFactory pf, Object key) throws Exception {
        CachedPart cp;
        LRUHashMap<Object, CachedPart> lRUHashMap = this.m_cache;
        synchronized (lRUHashMap) {
            cp = this.m_cache.get(key);
        }
        if (cp != null && cp.m_dependencies != null && cp.m_dependencies.isModified()) {
            System.out.println("parts: part " + key + " has changed. Reloading..");
            cp = null;
        }
        if (cp != null) {
            return cp;
        }
        ResourceDependencyList rdl = new ResourceDependencyList();
        ByteBufferOutputStream os = new ByteBufferOutputStream();
        PartResponse pr = new PartResponse((OutputStream)os);
        pf.generate(pr, this.m_application, key, rdl);
        String mime = pr.getMime();
        if (mime == null) {
            throw new IllegalStateException("The part " + pf + " did not set a MIME type, key=" + key);
        }
        os.close();
        cp = new CachedPart(os.getBuffers(), os.getSize(), pr.getCacheTime(), mime, rdl.createDependencies(), pr.getExtra());
        LRUHashMap<Object, CachedPart> lRUHashMap2 = this.m_cache;
        synchronized (lRUHashMap2) {
            this.m_cache.put(key, cp);
        }
        return cp;
    }
}

