/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server.reloader;

import java.net.URLClassLoader;
import org.slf4j.Logger;
import to.etc.domui.server.reloader.Reloader;

public class CheckingClassLoader
extends URLClassLoader {
    private static final Logger LOG = Reloader.LOG;
    private Reloader m_reloader;
    private String m_applicationClass;

    public CheckingClassLoader(ClassLoader parent, Reloader r, String appclass) {
        super(r.getUrls(), parent);
        this.m_reloader = r;
        this.m_applicationClass = appclass;
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!name.startsWith(this.m_applicationClass)) {
            return this.m_reloader.getReloadingLoader().loadClass(name);
        }
        Class<?> clz = this.findLoadedClass(name);
        if (clz == null) {
            LOG.debug("Load class " + name + " using checking loader");
            try {
                clz = this.findClass(name);
            }
            catch (ClassNotFoundException x) {
                if (this.getParent() == null) {
                    throw x;
                }
                clz = this.getParent().loadClass(name);
            }
            if (clz == null) {
                throw new ClassNotFoundException(name);
            }
        }
        if (resolve) {
            this.resolveClass(clz);
        }
        return clz;
    }
}

