/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server.reloader;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.reloader.CheckingClassLoader;
import to.etc.domui.server.reloader.ReloadingClassLoader;
import to.etc.domui.util.resources.ResourceTimestamp;
import to.etc.util.ClassUtil;
import to.etc.util.StringTool;

@SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs here are not network based")
public final class Reloader {
    static final Logger LOG = LoggerFactory.getLogger(Reloader.class);
    private List<LoadSpec> m_loadSpecList = new ArrayList<LoadSpec>();
    private List<LoadSpec> m_watchSpecList = new ArrayList<LoadSpec>();
    private ReloadingClassLoader m_currentLoader;
    private CheckingClassLoader m_checkLoader;
    private URL[] m_urls;
    private boolean m_changed;
    private boolean m_sweeping;

    public Reloader(String paths, String pathsWatchOnly) {
        Pattern p;
        boolean on;
        String path;
        StringTokenizer st = new StringTokenizer(paths, " \t;,");
        while (st.hasMoreTokens()) {
            path = st.nextToken().trim();
            if (path.length() <= 0) continue;
            on = true;
            if (path.startsWith("-")) {
                on = false;
                path = path.substring(1).trim();
            } else if (path.startsWith("+")) {
                on = false;
                path = path.substring(1).trim();
            }
            p = Pattern.compile(path);
            this.m_loadSpecList.add(new LoadSpec(p, on));
        }
        if (this.m_loadSpecList.size() == 0) {
            throw new IllegalStateException("No load specifiers added.");
        }
        if (pathsWatchOnly != null) {
            st = new StringTokenizer(pathsWatchOnly, " \t;,");
            while (st.hasMoreTokens()) {
                path = st.nextToken().trim();
                if (path.length() <= 0) continue;
                on = true;
                if (path.startsWith("-")) {
                    on = false;
                    path = path.substring(1).trim();
                } else if (path.startsWith("+")) {
                    on = false;
                    path = path.substring(1).trim();
                }
                p = Pattern.compile(path);
                this.m_watchSpecList.add(new LoadSpec(p, on));
            }
        }
        this.m_urls = ClassUtil.findUrlsFor((ClassLoader)this.getClass().getClassLoader());
        this.m_currentLoader = new ReloadingClassLoader(this.getClass().getClassLoader(), this);
    }

    public URL[] getUrls() {
        return this.m_urls;
    }

    public synchronized ClassLoader getReloadingLoader() {
        return this.m_currentLoader;
    }

    public Class<DomApplication> loadApplication(String classname) throws Exception {
        if (this.m_checkLoader == null) {
            this.m_checkLoader = new CheckingClassLoader(this.getClass().getClassLoader(), this, classname);
        }
        return this.m_checkLoader.loadClass(classname);
    }

    boolean watchClass(String name) {
        for (LoadSpec ls : this.m_loadSpecList) {
            if (!ls.matches(name)) continue;
            return ls.isAccept();
        }
        return false;
    }

    boolean watchOnlyClass(String name) {
        for (LoadSpec ls : this.m_watchSpecList) {
            if (!ls.matches(name)) continue;
            return ls.isAccept();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChanged() {
        List<ResourceTimestamp> sweeplist;
        Reloader reloader = this;
        synchronized (reloader) {
            if (this.m_changed) {
                return true;
            }
            if (this.m_sweeping) {
                while (this.m_sweeping) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.m_changed;
            }
            this.m_sweeping = true;
            sweeplist = this.m_currentLoader.getDependencyList();
        }
        boolean changed = false;
        try {
            boolean bl = changed = this.sweep(sweeplist);
            return bl;
        }
        finally {
            Reloader reloader2 = this;
            synchronized (reloader2) {
                if (changed) {
                    this.m_changed = true;
                }
                this.m_sweeping = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Reloader reloader = this;
        synchronized (reloader) {
            this.m_changed = false;
            this.m_currentLoader = new ReloadingClassLoader(this.getClass().getClassLoader(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sweep(List<ResourceTimestamp> list) {
        int fc = 0;
        long ts = System.nanoTime();
        try {
            for (ResourceTimestamp fr : list) {
                if (fr.isModified()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Class Source " + fr + " has changed.");
                    }
                    boolean bl = true;
                    return bl;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unchanged source for " + fr);
                }
                ++fc;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ts = System.nanoTime() - ts;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scanned " + fc + " .class files in " + StringTool.strNanoTime((long)ts));
            }
        }
    }

    private static class LoadSpec {
        private Pattern m_pat;
        private boolean m_accept;

        public LoadSpec(Pattern pat, boolean accept) {
            this.m_accept = accept;
            this.m_pat = pat;
        }

        public boolean matches(String in) {
            return this.m_pat.matcher(in).matches();
        }

        public boolean isAccept() {
            return this.m_accept;
        }
    }
}

