/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.server.reloader;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import to.etc.domui.server.reloader.Reloader;
import to.etc.domui.util.resources.ClasspathInventory;
import to.etc.domui.util.resources.IModifyableResource;
import to.etc.domui.util.resources.ResourceTimestamp;

public class ReloadingClassLoader
extends URLClassLoader {
    private static final Logger LOG = Reloader.LOG;
    private static int m_nextid = 1;
    private Reloader m_reloader;
    private final int m_id;
    private ClassLoader m_rootLoader;
    private final List<ResourceTimestamp> m_dependList = new ArrayList<ResourceTimestamp>();
    @Nonnull
    private final Set<String> m_scannedPackages = new HashSet<String>();

    private static final synchronized int nextID() {
        return m_nextid++;
    }

    public ReloadingClassLoader(ClassLoader parent, Reloader r) {
        super(r.getUrls(), parent);
        this.m_reloader = r;
        this.m_id = ReloadingClassLoader.nextID();
        this.m_rootLoader = this.getClass().getClassLoader();
        LOG.debug("ReloadingClassLoader: new instance " + this + " created");
    }

    public String toString() {
        return "reloader[" + this.m_id + "]";
    }

    @Override
    @Nullable
    public URL getResource(@Nullable String name) {
        URL resource = super.getResource(name);
        if (resource != null) {
            this.addResourceWatch(resource);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWatchFor(Class<?> clz) {
        IModifyableResource rt = ClasspathInventory.getInstance().findClassSource(clz);
        if (rt == null) {
            LOG.info("Cannot find source file for class=" + clz + "; changes to this class are not tracked");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Watching " + clz);
        }
        Reloader reloader = this.m_reloader;
        synchronized (reloader) {
            this.m_dependList.add(new ResourceTimestamp(rt, rt.getLastModified()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResourceTimestamp> getDependencyList() {
        Reloader reloader = this.m_reloader;
        synchronized (reloader) {
            return new ArrayList<ResourceTimestamp>(this.m_dependList);
        }
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("to.etc.domui.")) {
            return this.m_rootLoader.loadClass(name);
        }
        Class<?> loadClass = this.m_rootLoader.loadClass(name);
        if (!(this.m_reloader.watchClass(name) || loadClass.getSuperclass() != null && loadClass.getSuperclass().getName().equals(ResourceBundle.class.getName()))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Class " + name + " not matching watch pattern delegated to root loader");
            }
            if (this.m_reloader.watchOnlyClass(name)) {
                this.addWatchFor(loadClass);
                try {
                    this.scanForForResourceWatches(loadClass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOG.warn("Class " + name + " cannot watch resources");
                }
            }
            return loadClass;
        }
        Class<?> clz = this.findLoadedClass(name);
        if (clz == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("loading class-to-watch=" + name);
            }
            try {
                clz = this.findClass(name);
                this.addWatchFor(clz);
            }
            catch (ClassNotFoundException x) {
                if (this.getParent() == null) {
                    throw x;
                }
                clz = this.getParent().loadClass(name);
            }
            if (clz == null) {
                throw new ClassNotFoundException(name);
            }
        }
        if (resolve) {
            this.resolveClass(clz);
        }
        return clz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForForResourceWatches(@Nonnull Class<?> loadClass) throws Exception {
        File file;
        File[] listFiles;
        Set<String> set = this.m_scannedPackages;
        synchronized (set) {
            if (this.m_scannedPackages.contains(loadClass.getPackage().getName())) {
                return;
            }
        }
        URL resource = this.getResource(loadClass.getPackage().getName().replace('.', '/'));
        if (resource != null && (listFiles = (file = new File(resource.getFile())).listFiles()) != null) {
            for (int i = 0; i < listFiles.length; ++i) {
                this.addResourceWatch(listFiles[i]);
            }
        }
        Set<String> set2 = this.m_scannedPackages;
        synchronized (set2) {
            this.m_scannedPackages.add(loadClass.getPackage().getName());
        }
    }

    public void addResourceWatch(@Nonnull URL resource) {
        if (resource != null && resource.getFile() != null) {
            this.addResourceWatch(new File(resource.getFile()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceWatch(final @Nonnull File file) {
        if (file.getName().endsWith(".properties")) {
            Reloader reloader = this.m_reloader;
            synchronized (reloader) {
                this.m_dependList.add(new ResourceTimestamp(new IModifyableResource(){

                    @Override
                    public long getLastModified() {
                        return file.lastModified();
                    }
                }, file.lastModified()));
            }
        }
    }
}

