/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IAttributeContainer;
import to.etc.domui.state.IAppSessionBindingListener;
import to.etc.domui.state.SavedPage;
import to.etc.domui.state.SavedWindow;
import to.etc.domui.state.UserLogItem;
import to.etc.domui.state.WindowSession;
import to.etc.domui.util.janitor.Janitor;
import to.etc.domui.util.janitor.JanitorTask;

public class AppSession
implements HttpSessionBindingListener,
IAttributeContainer {
    private static final Logger LOG = LoggerFactory.getLogger(AppSession.class);
    @Nonnull
    private final DomApplication m_application;
    @Nonnull
    private final Map<String, Object> m_objCache = new HashMap<String, Object>();
    @Nullable
    private Thread m_lockingThread;
    private int m_exceptionRetryCount;
    @Nonnull
    private Map<String, WindowSession> m_windowMap = new HashMap<String, WindowSession>();
    @Nonnull
    private Map<String, Object> m_attributeMap = Collections.EMPTY_MAP;
    @Nonnull
    private final LinkedList<UserLogItem> m_itemList = new LinkedList();

    public AppSession(@Nonnull DomApplication da) {
        this.m_application = da;
    }

    public final void internalDestroy() {
        LOG.debug("Destroying AppSession " + this);
        this.destroyWindowSessions();
        try {
            this.destroy();
        }
        catch (Throwable x) {
            LOG.warn("Exception when destroying session", x);
        }
        this.unbindAll();
    }

    @Nonnull
    public DomApplication getApplication() {
        return this.m_application;
    }

    public void destroy() {
    }

    public final void valueBound(HttpSessionBindingEvent arg0) {
    }

    public final void valueUnbound(HttpSessionBindingEvent arg0) {
        this.internalDestroy();
    }

    Object findCachedObject(String classname) {
        return this.m_objCache.get(classname);
    }

    void putCachedObject(String classname, Object o) {
        this.m_objCache.put(classname, o);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void internalLockSession() {
        Thread t = Thread.currentThread();
        AppSession appSession = this;
        synchronized (appSession) {
            while (true) {
                if (this.m_lockingThread == null) {
                    this.m_lockingThread = t;
                    return;
                }
                if (this.m_lockingThread == t) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ix) {
                    throw new RuntimeException("Waiting for session lock was interrupted.", ix);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalUnlockSession() {
        Thread t = Thread.currentThread();
        AppSession appSession = this;
        synchronized (appSession) {
            if (this.m_lockingThread == null) {
                throw new IllegalStateException("Trying to unlock an AppSession while it's not being owned..");
            }
            if (this.m_lockingThread != t) {
                throw new IllegalStateException("Trying to unlock an AppSession while it's not being owned BY YOU");
            }
            this.m_lockingThread = null;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyWindowSessions() {
        Map<String, WindowSession> map;
        AppSession appSession = this;
        synchronized (appSession) {
            map = this.m_windowMap;
            this.m_windowMap = new HashMap<String, WindowSession>();
        }
        for (WindowSession cm : map.values()) {
            cm.destroyWindow(true);
            this.m_application.internalCallWindowSessionDestroyed(cm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void internalCheckExpiredWindowSessions() {
        ArrayList<WindowSession> droplist = null;
        long ets = System.currentTimeMillis() - (long)this.m_application.getWindowSessionTimeout() * 1000L * 60L;
        AppSession appSession = this;
        synchronized (appSession) {
            for (WindowSession cm : this.m_windowMap.values()) {
                if (cm.getLastUsed() >= ets) continue;
                if (droplist == null) {
                    droplist = new ArrayList<WindowSession>(10);
                }
                droplist.add(cm);
            }
            if (droplist == null) {
                return;
            }
            for (WindowSession cm : droplist) {
                this.m_windowMap.remove(cm.getWindowID());
            }
        }
        for (WindowSession cm : droplist) {
            System.out.println("cm: dropping window session " + cm.getWindowID() + " due to timeout");
            this.logUser(cm.getWindowID(), "cm: dropping window session " + cm.getWindowID() + " due to timeout");
            try {
                cm.destroyWindow(false);
                this.m_application.internalCallWindowSessionDestroyed(cm);
            }
            catch (Exception x) {
                this.logUser(cm.getWindowID(), "Exception in destroyConversations: " + x);
                LOG.warn("Exception in destroyConversations", (Throwable)x);
            }
        }
    }

    @Nonnull
    public final synchronized WindowSession createWindowSession() {
        WindowSession cm = new WindowSession(this);
        this.m_windowMap.put(cm.getWindowID(), cm);
        cm.internalTouched();
        this.m_application.internalCallWindowSessionCreated(cm);
        return cm;
    }

    @Nullable
    public final synchronized WindowSession findWindowSession(@Nonnull String wid) {
        WindowSession cm = this.m_windowMap.get(wid);
        if (cm != null) {
            cm.internalTouched();
            if (!this.resurrectWindowSession(cm)) {
                return null;
            }
        }
        return cm;
    }

    private synchronized boolean resurrectWindowSession(@Nonnull WindowSession cm) {
        cm.internalTouched();
        int tm = cm.getObituaryTimer();
        if (tm == -1) {
            return true;
        }
        cm.setObituaryTimer(-1);
        boolean res = Janitor.getJanitor().cancelJob(tm);
        System.out.println("session: resurrected window " + cm.getWindowID() + ", canceltask=" + res);
        this.logUser(cm.getWindowID(), "session: resurrected window " + cm.getWindowID() + ", canceltask=" + res);
        return res;
    }

    public synchronized void internalObituaryReceived(String cid, int obitPageTag) throws Exception {
        final WindowSession cm = this.m_windowMap.get(cid);
        if (cm == null) {
            this.logUser(cid, "Obituary ignored: the window ID is unknown");
            LOG.info("Obituary ignored: the window ID is unknown");
            return;
        }
        if (cm.getObituaryTimer() != -1) {
            this.logUser(cid, "Obituary ignored: the kill timer has already been started");
            LOG.info("Obituary ignored: the kill timer has already been started");
            return;
        }
        if (obitPageTag != cm.internalGetLastPageTag()) {
            LOG.info("Obituary ignored: the last page has a different page tag (the corpse arrived too late)");
            this.logUser(cid, "Obituary ignored: the last page has a different page tag (the corpse arrived too late)");
            return;
        }
        long ts = System.currentTimeMillis() - 2000L;
        if (cm.getLastUsed() > ts) {
            this.logUser(cid, "Obituary ignored: the last request was less than 2 secs ago (order problem)");
            LOG.info("Obituary ignored: the last request was less than 2 secs ago (order problem)");
            return;
        }
        int timer = Janitor.getJanitor().addTask(60, true, "DropWindow", new JanitorTask(){

            @Override
            public void run() throws Exception {
                AppSession.this.internalDropWindowSession(cm);
            }
        });
        cm.setObituaryTimer(timer);
        LOG.info("Obituary kill timer " + timer + " set to kill window=" + cm.getWindowID());
        this.logUser(cid, "Obituary kill timer " + timer + " set to kill window=" + cm.getWindowID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalDropWindowSession(WindowSession cm) {
        if (LOG.isInfoEnabled()) {
            LOG.info("session: destroying WindowSession=" + cm.getWindowID() + " because it's obituary was received.");
        }
        this.logUser(cm.getWindowID(), "session: destroying WindowSession=" + cm.getWindowID() + " because it's obituary was received.");
        AppSession appSession = this;
        synchronized (appSession) {
            if (cm.getObituaryTimer() == -1) {
                return;
            }
            this.m_windowMap.remove(cm.getWindowID());
        }
        cm.destroyWindow(false);
        this.m_application.internalCallWindowSessionDestroyed(cm);
    }

    public synchronized void dump() {
        if (LOG.isDebugEnabled()) {
            System.out.println("============= AppSession's WindowList =============");
            for (WindowSession cm : this.m_windowMap.values()) {
                cm.dump();
            }
        }
    }

    @Override
    @Nullable
    public Object getAttribute(@Nonnull String name) {
        return this.m_attributeMap.get(name);
    }

    @Override
    public void setAttribute(@Nonnull String name, @Nullable Object value) {
        if (this.m_attributeMap == Collections.EMPTY_MAP) {
            this.m_attributeMap = new HashMap<String, Object>();
        }
        if (value == null) {
            Object item = this.m_attributeMap.remove(name);
            if (item instanceof IAppSessionBindingListener) {
                ((IAppSessionBindingListener)item).unboundFromSession(this, name);
            }
        } else {
            this.m_attributeMap.put(name, value);
            if (value instanceof IAppSessionBindingListener) {
                ((IAppSessionBindingListener)value).boundToSession(this, name);
            }
        }
    }

    private void unbindAll() {
        if (this.m_attributeMap.size() == 0) {
            return;
        }
        for (String name : this.m_attributeMap.keySet()) {
            Object value = this.m_attributeMap.get(name);
            if (!(value instanceof IAppSessionBindingListener)) continue;
            try {
                ((IAppSessionBindingListener)value).unboundFromSession(this, name);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    synchronized void saveOldState(@Nonnull HttpSession httpSession) {
        for (WindowSession ws : this.m_windowMap.values()) {
            List<SavedPage> wl = ws.getSavedPageList();
            SavedWindow sw = new SavedWindow(ws.getWindowID(), wl);
            httpSession.setAttribute(ws.getWindowID(), (Object)sw);
            System.out.println("appSession: saved " + sw);
        }
    }

    public synchronized int getExceptionRetryCount() {
        return this.m_exceptionRetryCount;
    }

    public synchronized int incrementExceptionCount() {
        return ++this.m_exceptionRetryCount;
    }

    public synchronized void clearExceptionRetryCount() {
        this.m_exceptionRetryCount = 0;
    }

    public synchronized void log(@Nonnull UserLogItem uli) {
        while (this.m_itemList.size() > 400) {
            this.m_itemList.removeFirst();
        }
        this.m_itemList.addLast(uli);
    }

    @Nonnull
    public synchronized List<UserLogItem> getLogItems() {
        return new ArrayList<UserLogItem>(this.m_itemList);
    }

    public void logUser(@Nonnull String cid, @Nonnull String message) {
        this.log(new UserLogItem(cid, null, null, null, message));
    }
}

