/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.state;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.component.delayed.AsyncContainer;
import to.etc.domui.component.delayed.IAsyncRunnable;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.state.ConversationDestroyedException;
import to.etc.domui.state.DelayedActivitiesManager;
import to.etc.domui.state.DelayedActivityInfo;
import to.etc.domui.state.IConversationStateListener;
import to.etc.domui.state.IPageParameters;
import to.etc.domui.state.WindowSession;
import to.etc.webapp.query.IQContextContainer;
import to.etc.webapp.query.QContextContainer;
import to.etc.webapp.query.QDataContext;

public class ConversationContext
implements IQContextContainer {
    public static final Logger LOG = LoggerFactory.getLogger(ConversationContext.class);
    private boolean m_sessionDestroyed;
    @Nullable
    private String m_id;
    @Nullable
    private String m_fullId;
    @Nonnull
    private final Map<String, Page> m_pageMap = new HashMap<String, Page>();
    @Nonnull
    private Map<String, Object> m_map = Collections.EMPTY_MAP;
    @Nullable
    private WindowSession m_manager;
    @Nullable
    private DelayedActivitiesManager m_delayManager;
    @Nonnull
    private ConversationState m_state = ConversationState.DETACHED;
    @Nonnull
    private List<File> m_uploadList = Collections.EMPTY_LIST;

    public final String getId() {
        if (null == this.m_id) {
            throw new IllegalStateException("ID is null??");
        }
        return this.m_id;
    }

    final void initialize(@Nonnull WindowSession m, @Nonnull String id) {
        if (m == null) {
            throw new IllegalStateException("Internal: manager cannot be null, dude");
        }
        if (this.m_manager != null) {
            throw new IllegalStateException("Internal: manager is ALREADY set, dude");
        }
        if (this.m_id != null) {
            throw new IllegalStateException("ID set twice?");
        }
        this.m_manager = m;
        this.m_id = id;
        this.m_fullId = m.getWindowID() + "." + this.m_id;
    }

    public String getFullId() {
        if (null == this.m_fullId) {
            throw new IllegalStateException("fullID is null??");
        }
        return this.m_fullId;
    }

    @Nonnull
    public String toString() {
        return "conversation[" + this.getFullId() + "]";
    }

    public void onAttach() throws Exception {
    }

    public void onDetach() throws Exception {
    }

    public void onDestroy() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalAttach() throws Exception {
        LOG.debug("Attaching " + this);
        if (this.m_state != ConversationState.DETACHED) {
            throw new IllegalStateException("Wrong state for ATTACH: " + (Object)((Object)this.m_state));
        }
        for (Object o : this.m_map.values()) {
            if (!(o instanceof IConversationStateListener)) continue;
            try {
                ((IConversationStateListener)o).conversationAttached(this);
            }
            catch (Exception x) {
                x.printStackTrace();
                LOG.error("In calling attach listener", (Throwable)x);
            }
        }
        try {
            this.onAttach();
        }
        finally {
            this.m_state = ConversationState.ATTACHED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalDetach() throws Exception {
        LOG.debug("Detaching " + this);
        if (this.m_state != ConversationState.ATTACHED) {
            throw new IllegalStateException("Wrong state for DETACH: " + (Object)((Object)this.m_state) + " in " + this);
        }
        for (Object o : this.m_map.values()) {
            if (!(o instanceof IConversationStateListener)) continue;
            try {
                ((IConversationStateListener)o).conversationDetached(this);
            }
            catch (Exception x) {
                x.printStackTrace();
                LOG.error("In calling detach listener", (Throwable)x);
            }
        }
        try {
            this.onDetach();
        }
        finally {
            this.m_state = ConversationState.DETACHED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalDestroy(boolean sessionDestroyed) throws Exception {
        LOG.info("Destroying " + this);
        if (this.m_state == ConversationState.DESTROYED) {
            if (!sessionDestroyed) {
                throw new IllegalStateException("Wrong state for DESTROY: " + (Object)((Object)this.m_state));
            }
            return;
        }
        for (Page pg : this.m_pageMap.values()) {
            try {
                pg.getBody().onDestroy();
            }
            catch (Exception x) {
                if (sessionDestroyed) continue;
                System.err.println("Exception in page " + pg.getBody() + "'s onDestroy handler: " + x);
                x.printStackTrace();
            }
        }
        this.m_pageMap.clear();
        if (this.m_delayManager != null) {
            this.m_delayManager.terminate();
            this.m_delayManager = null;
        }
        for (Object o : this.m_map.values()) {
            if (!(o instanceof IConversationStateListener)) continue;
            try {
                ((IConversationStateListener)o).conversationDestroyed(this);
                this.getWindowSession().getApplication().internalCallConversationDestroyed(this);
            }
            catch (Exception x) {
                if (sessionDestroyed) continue;
                x.printStackTrace();
                LOG.error("In calling destroy listener", (Throwable)x);
            }
        }
        this.getWindowSession().getApplication().internalCallConversationDestroyed(this);
        try {
            this.onDestroy();
        }
        catch (Exception x) {
            if (!sessionDestroyed) {
                throw x;
            }
        }
        finally {
            this.m_state = ConversationState.DESTROYED;
            this.m_sessionDestroyed = sessionDestroyed;
            this.discardTempFiles();
        }
    }

    public void checkAttached() {
        if (this.m_state != ConversationState.ATTACHED) {
            throw new ConversationDestroyedException(this.toString(), String.valueOf((Object)this.m_state));
        }
    }

    public void destroy() {
        this.getWindowSession().destroyConversation(this);
        this.m_manager = null;
    }

    Page findPage(Class<? extends NodeBase> clz) {
        return this.m_pageMap.get(clz.getName());
    }

    public void internalRegisterPage(@Nonnull Page p, @Nonnull IPageParameters papa) {
        this.m_pageMap.put(p.getBody().getClass().getName(), p);
        p.internalInitialize(papa, this);
    }

    void destroyPage(@Nonnull Page pg) {
        try {
            pg.getBody().onDestroy();
        }
        catch (Exception x) {
            System.err.println("Exception in page " + pg.getBody() + "'s onDestroy handler: " + x);
            x.printStackTrace();
        }
        this.m_pageMap.remove(pg.getBody().getClass().getName());
    }

    @Nonnull
    public WindowSession getWindowSession() {
        if (null != this.m_manager) {
            return this.m_manager;
        }
        throw new IllegalStateException("Not initialized?");
    }

    public void setAttribute(String name, Object val) {
        Object old;
        if (this.m_map == Collections.EMPTY_MAP) {
            this.m_map = new HashMap<String, Object>();
        }
        if ((old = this.m_map.put(name, val)) != null && old instanceof IConversationStateListener) {
            try {
                ((IConversationStateListener)old).conversationDetached(this);
            }
            catch (Exception x) {
                x.printStackTrace();
                LOG.error("In calling detach listener", (Throwable)x);
            }
        }
    }

    @Nullable
    public Object getAttribute(String name) {
        return this.m_map.get(name);
    }

    synchronized DelayedActivitiesManager getDelayedActivitiesManager() {
        if (this.m_delayManager == null) {
            this.m_delayManager = new DelayedActivitiesManager(this);
        }
        return this.m_delayManager;
    }

    public DelayedActivityInfo scheduleDelayed(@Nonnull AsyncContainer container, @Nonnull IAsyncRunnable a) throws Exception {
        return this.getDelayedActivitiesManager().schedule(a, container);
    }

    public void startDelayedExecution() {
        if (this.m_delayManager != null) {
            this.m_delayManager.start();
        }
    }

    public void processDelayedResults(Page pg) throws Exception {
        DelayedActivitiesManager delayManager = this.m_delayManager;
        if (delayManager == null) {
            return;
        }
        delayManager.processDelayedResults(pg);
    }

    public boolean isPollCallbackRequired() {
        DelayedActivitiesManager delayManager = this.m_delayManager;
        return delayManager == null ? false : delayManager.callbackRequired();
    }

    public <T extends NodeContainer> void registerPoller(T nc) {
        this.getDelayedActivitiesManager().registerPoller(nc);
    }

    public <T extends NodeContainer> void unregisterPoller(T nc) {
        this.getDelayedActivitiesManager().unregisterPoller(nc);
    }

    public void registerTempFile(@Nonnull File f) {
        if (this.m_uploadList == Collections.EMPTY_LIST) {
            this.m_uploadList = new ArrayList<File>();
        }
        this.m_uploadList.add(f);
    }

    protected void discardTempFiles() {
        for (File f : this.m_uploadList) {
            try {
                f.delete();
            }
            catch (Exception exception) {}
        }
        this.m_uploadList.clear();
    }

    public void dump() {
        System.out.println("    Conversation: " + this.getId() + " in state " + (Object)((Object)this.m_state));
        if (this.m_delayManager == null) {
            System.out.println("      No delayed actions pending");
        } else {
            System.out.println("      Delayed action manager is present");
        }
        for (File df : this.m_uploadList) {
            System.out.println("      Uploaded file: " + df);
        }
        StringBuilder sb = new StringBuilder(128);
        for (Page pg : this.m_pageMap.values()) {
            sb.setLength(0);
            IPageParameters pp = pg.getPageParameters();
            sb.append("      Resident page: ");
            sb.append(pg.getBody().getClass().getName());
            sb.append(" [");
            sb.append(pg.getPageTag());
            sb.append("] ");
            if (pp == null) {
                sb.append("(no parameters)");
            } else {
                sb.append(pp.toString());
            }
            System.out.println(sb.toString());
        }
    }

    ConversationState getState() {
        return this.m_state;
    }

    public boolean isValid() {
        return this.m_state == ConversationState.ATTACHED;
    }

    @Nonnull
    public QContextContainer getContextContainer(@Nonnull String key) {
        key = "cc-" + key;
        QContextContainer cc = (QContextContainer)this.getAttribute(key);
        if (null == cc) {
            cc = new DomUIContextContainer();
            this.setAttribute(key, cc);
        }
        return cc;
    }

    @Nonnull
    public List<QContextContainer> getAllContextContainers() {
        ArrayList<QContextContainer> ccl = new ArrayList<QContextContainer>();
        for (Object o : this.m_map.values()) {
            if (!(o instanceof QContextContainer)) continue;
            ccl.add((QContextContainer)o);
        }
        return ccl;
    }

    private static final class DomUIContextContainer
    extends QContextContainer
    implements IConversationStateListener {
        private DomUIContextContainer() {
        }

        @Override
        public void conversationNew(@Nonnull ConversationContext cc) throws Exception {
            QDataContext c = this.internalGetSharedContext();
            if (c instanceof IConversationStateListener) {
                ((IConversationStateListener)c).conversationNew(cc);
            }
        }

        @Override
        public void conversationAttached(@Nonnull ConversationContext cc) throws Exception {
            QDataContext c = this.internalGetSharedContext();
            if (c instanceof IConversationStateListener) {
                ((IConversationStateListener)c).conversationAttached(cc);
            }
        }

        @Override
        public void conversationDetached(@Nonnull ConversationContext cc) throws Exception {
            QDataContext c = this.internalGetSharedContext();
            if (c instanceof IConversationStateListener) {
                ((IConversationStateListener)c).conversationDetached(cc);
            }
        }

        @Override
        public void conversationDestroyed(@Nonnull ConversationContext cc) throws Exception {
            QDataContext c = this.internalGetSharedContext();
            if (c instanceof IConversationStateListener) {
                ((IConversationStateListener)c).conversationDestroyed(cc);
            }
        }
    }

    static enum ConversationState {
        DETACHED,
        ATTACHED,
        DESTROYED;

    }
}

