/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.component.delayed.AsyncContainer;
import to.etc.domui.component.delayed.IActivity;
import to.etc.domui.component.delayed.IAsyncRunnable;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.DelayedActivityInfo;
import to.etc.domui.state.DelayedActivityState;
import to.etc.domui.state.DelayedProgressMonitor;
import to.etc.domui.state.IPolledForUpdate;
import to.etc.domui.util.DomUtil;

public class DelayedActivitiesManager
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DelayedActivitiesManager.class);
    private Thread m_executorThread;
    private List<DelayedActivityInfo> m_pendingQueue = new ArrayList<DelayedActivityInfo>();
    private List<DelayedActivityInfo> m_completionQueue = new ArrayList<DelayedActivityInfo>();
    private DelayedActivityInfo m_runningActivity;
    private boolean m_terminated;
    private Set<NodeContainer> m_pollSet = new HashSet<NodeContainer>();

    protected DelayedActivitiesManager(ConversationContext conversation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelayedActivityInfo schedule(@Nonnull IAsyncRunnable a, @Nonnull AsyncContainer ac) throws Exception {
        DelayedActivitiesManager delayedActivitiesManager = this;
        synchronized (delayedActivitiesManager) {
            for (DelayedActivityInfo tdai : this.m_pendingQueue) {
                if (tdai.getActivity() != a) continue;
                throw new IllegalStateException("The same activity instance is ALREADY scheduled!!");
            }
        }
        DelayedActivityInfo dai = new DelayedActivityInfo(this, a, ac);
        dai.callScheduled();
        DelayedActivitiesManager delayedActivitiesManager2 = this;
        synchronized (delayedActivitiesManager2) {
            this.m_pendingQueue.add(dai);
            return dai;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelActivity(IActivity a) {
        DelayedActivityInfo d = null;
        DelayedActivitiesManager delayedActivitiesManager = this;
        synchronized (delayedActivitiesManager) {
            for (DelayedActivityInfo dai : this.m_pendingQueue) {
                if (dai.getActivity() != a) continue;
                d = dai;
                break;
            }
        }
        if (d == null) {
            throw new IllegalStateException("Activity is not scheduled");
        }
        this.cancelActivity(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelActivity(DelayedActivityInfo dai) {
        Thread tr;
        DelayedActivitiesManager delayedActivitiesManager = this;
        synchronized (delayedActivitiesManager) {
            if (this.m_pendingQueue.remove(dai)) {
                dai.getContainer().confirmCancelled();
                return true;
            }
            if (this.m_runningActivity != dai) {
                return false;
            }
            tr = this.m_executorThread;
            this.m_runningActivity.getMonitor().cancel();
        }
        tr.interrupt();
        return true;
    }

    private void wakeupListeners(int lingertime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completionStateChanged(DelayedActivityInfo dai, int pct, String statusMsg) {
        DelayedActivitiesManager delayedActivitiesManager = this;
        synchronized (delayedActivitiesManager) {
            dai.setPercentageComplete(pct);
            dai.setStatusMessage(statusMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelayedActivityState getState() {
        DelayedActivitiesManager delayedActivitiesManager = this;
        synchronized (delayedActivitiesManager) {
            ArrayList<DelayedActivityState.Progress> pl = Collections.EMPTY_LIST;
            if (this.m_runningActivity != null) {
                int pct = this.m_runningActivity.getPercentageComplete();
                String statusMsg = this.m_runningActivity.getStatusMessage();
                if (pct > 0 || !DomUtil.isBlank(statusMsg)) {
                    pl = new ArrayList<DelayedActivityState.Progress>();
                    pl.add(new DelayedActivityState.Progress(this.m_runningActivity.getContainer(), pct, statusMsg));
                }
            }
            List<Object> comp = this.m_completionQueue.size() == 0 ? Collections.EMPTY_LIST : new ArrayList<DelayedActivityInfo>(this.m_completionQueue);
            this.m_completionQueue.clear();
            if (comp.size() == 0 && pl.size() == 0) {
                return null;
            }
            return new DelayedActivityState(pl, (List<DelayedActivityInfo>)comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Thread t;
        DelayedActivitiesManager delayedActivitiesManager = this;
        synchronized (delayedActivitiesManager) {
            if (this.m_executorThread != null) {
                return true;
            }
            if (this.m_pendingQueue.size() == 0) {
                return false;
            }
            this.m_executorThread = new Thread(this);
            this.m_executorThread.setName("xc");
            this.m_executorThread.setDaemon(true);
            this.m_executorThread.setPriority(1);
            t = this.m_executorThread;
        }
        t.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean callbackRequired() {
        DelayedActivitiesManager delayedActivitiesManager = this;
        synchronized (delayedActivitiesManager) {
            return this.m_pendingQueue.size() > 0 || this.m_completionQueue.size() > 0 || this.m_runningActivity != null || this.m_pollSet.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        DelayedActivitiesManager delayedActivitiesManager = this;
        synchronized (delayedActivitiesManager) {
            return this.m_terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Thread killme = null;
        DelayedActivityInfo pendingcorpse = null;
        DelayedActivitiesManager delayedActivitiesManager = this;
        synchronized (delayedActivitiesManager) {
            if (this.m_terminated) {
                return;
            }
            this.m_terminated = true;
            if (this.m_executorThread != null) {
                killme = this.m_executorThread;
                this.m_executorThread = null;
            }
            pendingcorpse = this.m_runningActivity;
            this.m_runningActivity = null;
            this.m_completionQueue.clear();
            this.m_pendingQueue.clear();
            this.wakeupListeners(100);
        }
        try {
            if (pendingcorpse != null) {
                pendingcorpse.getMonitor().cancel();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        try {
            if (killme != null) {
                killme.interrupt();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            block19: {
                DelayedActivitiesManager delayedActivitiesManager = this;
                // MONITORENTER : delayedActivitiesManager
                if (!this.m_terminated) break block19;
                // MONITOREXIT : delayedActivitiesManager
                DelayedActivitiesManager delayedActivitiesManager2 = this;
                // MONITORENTER : delayedActivitiesManager2
                this.m_executorThread = null;
                // MONITOREXIT : delayedActivitiesManager2
                return;
            }
            if (this.m_pendingQueue.size() != 0) break block20;
            // MONITOREXIT : delayedActivitiesManager
            DelayedActivitiesManager delayedActivitiesManager = this;
            break;
        }
        {
            catch (Exception x) {
                if (!this.isTerminated()) {
                    System.err.println("FATAL Exception in DelayedActivitiesManager.run()!??!?!?!?\nAsy tasks WILL NOT COMPLETE anymore.");
                    x.printStackTrace();
                }
                DelayedActivitiesManager delayedActivitiesManager = this;
                // MONITORENTER : delayedActivitiesManager
                this.m_executorThread = null;
                // MONITOREXIT : delayedActivitiesManager
                return;
            }
        }
        {
            DelayedActivityInfo dai;
            block20: {
                // MONITORENTER : delayedActivitiesManager
                this.m_executorThread = null;
                // MONITOREXIT : delayedActivitiesManager
                return;
            }
            this.m_runningActivity = dai = this.m_pendingQueue.remove(0);
            // MONITOREXIT : delayedActivitiesManager
            this.execute(dai);
            continue;
        }
        catch (Throwable throwable) {
            DelayedActivitiesManager delayedActivitiesManager = this;
            // MONITORENTER : delayedActivitiesManager
            this.m_executorThread = null;
            // MONITOREXIT : delayedActivitiesManager
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(DelayedActivityInfo dai) {
        DelayedProgressMonitor mon = new DelayedProgressMonitor(this, dai);
        dai.setMonitor(mon);
        Exception errorx = null;
        try {
            dai.checkIsPageConnected();
            dai.callBeforeListeners();
            dai.getActivity().run(mon);
        }
        catch (Exception x) {
            if (!(x instanceof InterruptedException)) {
                errorx = x;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception in async activity", (Throwable)x);
                }
            }
        }
        finally {
            dai.callAfterListeners();
        }
        DelayedActivitiesManager delayedActivitiesManager = this;
        synchronized (delayedActivitiesManager) {
            this.m_runningActivity = null;
            if (this.m_terminated) {
                return;
            }
            if (errorx != null) {
                dai.setException(errorx);
            }
            this.m_completionQueue.add(dai);
            this.wakeupListeners(1000);
        }
    }

    public void applyToTree(DelayedActivityState das) throws Exception {
        AsyncContainer c;
        for (DelayedActivityState.Progress p : das.getProgressList()) {
            c = p.getContainer();
            c.updateProgress(p.getPctComplete(), p.getMessage());
        }
        for (DelayedActivityInfo dai : das.getCompletionList()) {
            c = dai.getContainer();
            c.updateCompleted(dai);
        }
    }

    public void processDelayedResults(Page pg) throws Exception {
        DelayedActivityState das = this.getState();
        if (das != null) {
            this.applyToTree(das);
        }
        for (NodeContainer nc : this.m_pollSet) {
            ((IPolledForUpdate)((Object)nc)).checkForChanges();
        }
    }

    public <T extends NodeContainer> void registerPoller(T nc) {
        this.m_pollSet.add(nc);
    }

    public <T extends NodeBase> void unregisterPoller(T nc) {
        this.m_pollSet.remove(nc);
    }
}

