/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.state;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.component.delayed.AsyncContainer;
import to.etc.domui.component.delayed.IAsyncListener;
import to.etc.domui.component.delayed.IAsyncRunnable;
import to.etc.domui.server.DomApplication;
import to.etc.domui.state.DelayedActivitiesManager;
import to.etc.domui.state.DelayedProgressMonitor;

public class DelayedActivityInfo {
    private final DelayedActivitiesManager m_manager;
    private final AsyncContainer m_container;
    private final IAsyncRunnable m_activity;
    private DelayedProgressMonitor m_monitor;
    private Exception m_exception;
    private int m_pctComplete = -1;
    private String m_statusMessage;
    @Nonnull
    private final Map<IAsyncListener<?>, Object> m_listenerDataMap = new HashMap();

    protected DelayedActivityInfo(@Nonnull DelayedActivitiesManager manager, @Nonnull IAsyncRunnable activity, @Nonnull AsyncContainer ac) {
        this.m_activity = activity;
        this.m_manager = manager;
        this.m_container = ac;
    }

    public IAsyncRunnable getActivity() {
        return this.m_activity;
    }

    @Nonnull
    public DelayedProgressMonitor getMonitor() {
        if (this.m_monitor == null) {
            throw new IllegalStateException("? Unexpected access to monitor after task completed?");
        }
        return this.m_monitor;
    }

    void setMonitor(DelayedProgressMonitor monitor) {
        this.m_monitor = monitor;
    }

    public Exception getException() {
        return this.m_exception;
    }

    void setException(Exception exception) {
        this.m_exception = exception;
    }

    public void cancel() {
        this.m_manager.cancelActivity(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPercentageComplete() {
        DelayedActivitiesManager delayedActivitiesManager = this.m_manager;
        synchronized (delayedActivitiesManager) {
            return this.m_pctComplete;
        }
    }

    void setPercentageComplete(int pct) {
        this.m_pctComplete = pct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getStatusMessage() {
        DelayedActivitiesManager delayedActivitiesManager = this.m_manager;
        synchronized (delayedActivitiesManager) {
            return this.m_statusMessage;
        }
    }

    void setStatusMessage(String statusMessage) {
        this.m_statusMessage = statusMessage;
    }

    public AsyncContainer getContainer() {
        return this.m_container;
    }

    void callScheduled() throws Exception {
        for (IAsyncListener<?> al : this.m_container.getPage().getApplication().getAsyncListenerList()) {
            this.handleListenerScheduled(al);
        }
    }

    private <T> void handleListenerScheduled(IAsyncListener<T> al) throws Exception {
        T resval = al.onActivityScheduled(this.m_activity);
        this.m_listenerDataMap.put(al, resval);
    }

    public void callBeforeListeners() throws Exception {
        for (IAsyncListener<?> al : DomApplication.get().getAsyncListenerList()) {
            this.handleListenerBefore(al);
        }
    }

    private <T> void handleListenerBefore(IAsyncListener<T> al) throws Exception {
        Object context = this.m_listenerDataMap.get(al);
        al.onActivityStart(this.m_activity, context);
    }

    public void callAfterListeners() {
        for (IAsyncListener<?> al : DomApplication.get().getAsyncListenerList()) {
            this.handleListenerAfter(al);
        }
    }

    private <T> void handleListenerAfter(IAsyncListener<T> al) {
        try {
            Object context = this.m_listenerDataMap.get(al);
            al.onActivityEnd(this.m_activity, context);
        }
        catch (Exception x) {
            System.err.println("Ignored exception in IAsyncListener#onEnd: " + x);
            x.printStackTrace();
        }
    }

    public void checkIsPageConnected() {
        try {
            this.m_container.getPage();
        }
        catch (IllegalStateException x) {
            System.err.println("Ignored exception when container is not connected to page, something is about to fail because of " + x);
            x.printStackTrace();
        }
    }
}

