/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.state;

import to.etc.domui.component.delayed.IProgress;
import to.etc.domui.state.DelayedActivitiesManager;
import to.etc.domui.state.DelayedActivityCanceledException;
import to.etc.domui.state.DelayedActivityInfo;
import to.etc.domui.util.DomUtil;

public class DelayedProgressMonitor
implements IProgress {
    private DelayedActivitiesManager m_manager;
    private DelayedActivityInfo m_activity;
    private int m_maxWork = -1;
    private int m_currentWork;
    private boolean m_canceled;
    private String m_statusMessage;

    protected DelayedProgressMonitor(DelayedActivitiesManager manager, DelayedActivityInfo activity) {
        this.m_manager = manager;
        this.m_activity = activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        DelayedActivitiesManager delayedActivitiesManager = this.m_manager;
        synchronized (delayedActivitiesManager) {
            this.m_canceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        DelayedActivitiesManager delayedActivitiesManager = this.m_manager;
        synchronized (delayedActivitiesManager) {
            return this.m_canceled;
        }
    }

    @Override
    public void setCompleted(int work) {
        if (this.isCancelled()) {
            throw new DelayedActivityCanceledException();
        }
        if (work > this.m_currentWork && this.isReporting()) {
            if (work > this.m_maxWork) {
                work = this.m_maxWork;
            }
            this.m_currentWork = work;
            this.m_manager.completionStateChanged(this.m_activity, this.getPercentComplete(), this.m_statusMessage);
        }
    }

    @Override
    public void setTotalWork(int work) {
        if (this.isCancelled()) {
            throw new DelayedActivityCanceledException();
        }
        this.m_maxWork = work;
        this.m_manager.completionStateChanged(this.m_activity, 0, this.m_statusMessage);
    }

    public boolean isReporting() {
        return this.m_maxWork > 0 || !DomUtil.isBlank(this.m_statusMessage);
    }

    int getPercentComplete() {
        if (this.m_maxWork <= 0) {
            return 0;
        }
        int pct = 100 * this.m_currentWork / this.m_maxWork;
        return pct;
    }

    @Override
    public void setStatusMessage(String msg) {
        this.m_statusMessage = msg;
        if (this.isCancelled()) {
            throw new DelayedActivityCanceledException();
        }
        this.m_manager.completionStateChanged(this.m_activity, this.getPercentComplete(), this.m_statusMessage);
    }
}

