/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.state;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.ReloadingContextMaker;
import to.etc.domui.server.reloader.IReloadedClassesListener;
import to.etc.domui.state.AppSession;

public final class HttpSessionLink
implements IReloadedClassesListener,
HttpSessionBindingListener {
    private AppSession m_appSession;
    @Nonnull
    private final ReloadingContextMaker m_reloader;
    @Nonnull
    private final HttpSession m_httpSession;

    public HttpSessionLink(@Nonnull HttpSession sess, @Nonnull ReloadingContextMaker reloader) {
        this.m_reloader = reloader;
        this.m_httpSession = sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void classesReloaded() {
        AppSession old;
        HttpSessionLink httpSessionLink = this;
        synchronized (httpSessionLink) {
            old = this.m_appSession;
            this.m_appSession = null;
        }
        if (old != null) {
            old.saveOldState(this.m_httpSession);
            old.internalDestroy();
        }
    }

    public void valueBound(HttpSessionBindingEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUnbound(HttpSessionBindingEvent arg0) {
        AppSession old;
        HttpSessionLink httpSessionLink = this;
        synchronized (httpSessionLink) {
            old = this.m_appSession;
            this.m_appSession = null;
        }
        if (old != null) {
            old.internalDestroy();
        }
        this.m_reloader.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public AppSession getAppSession(@Nonnull DomApplication app) {
        AppSession s;
        HttpSessionLink httpSessionLink = this;
        synchronized (httpSessionLink) {
            s = this.m_appSession;
            if (s == null) {
                s = this.m_appSession = app.createSession();
            } else if (s.getApplication() != app) {
                throw new IllegalStateException("Different DomApplication instances??");
            }
        }
        return s;
    }
}

