/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.state;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.state.CidPair;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.IPageParameters;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.WindowSession;
import to.etc.domui.util.DomUtil;

public class PageMaker {
    @Nullable
    public static Page findPageInConversation(@Nonnull IRequestContext rctx, @Nonnull Class<? extends UrlPage> clz, @Nonnull String cid) throws Exception {
        if (cid == null) {
            return null;
        }
        CidPair cida = CidPair.decode(cid);
        WindowSession cm = rctx.getSession().findWindowSession(cida.getWindowId());
        if (cm == null) {
            throw new IllegalStateException("The WindowSession with wid=" + cida.getWindowId() + " has expired.");
        }
        ConversationContext cc = cm.findConversation(cida.getConversationId());
        if (cc == null) {
            return null;
        }
        return cc.findPage(clz);
    }

    @Nonnull
    static Page createPageWithContent(@Nonnull Constructor<? extends UrlPage> con, @Nonnull ConversationContext cc, @Nonnull IPageParameters pp) throws Exception {
        UrlPage nc = PageMaker.createPageContent(con, cc, pp);
        Page pg = new Page(nc);
        cc.internalRegisterPage(pg, pp);
        return pg;
    }

    @Nonnull
    private static UrlPage createPageContent(@Nonnull Constructor<? extends UrlPage> con, @Nonnull ConversationContext cc, @Nonnull IPageParameters pp) throws Exception {
        UrlPage p;
        Class<?>[] par = con.getParameterTypes();
        Object[] args = new Object[par.length];
        for (int i = 0; i < par.length; ++i) {
            Class<IPageParameters> pc = par[i];
            if (pc.isAssignableFrom(IPageParameters.class)) {
                args[i] = pp;
                continue;
            }
            if (pc.isAssignableFrom(PageParameters.class)) {
                if (pp instanceof PageParameters) {
                    args[i] = pp;
                    continue;
                }
                args[i] = pp.getUnlockedCopy();
                continue;
            }
            if (ConversationContext.class.isAssignableFrom(pc)) {
                args[i] = cc;
                continue;
            }
            throw new IllegalStateException("?? Cannot assign a value to constructor parameter [" + i + "]: " + pc + " of " + con);
        }
        try {
            p = DomUtil.nullChecked(con.newInstance(args));
        }
        catch (InvocationTargetException itx) {
            Throwable c = itx.getCause();
            if (c instanceof Exception) {
                throw (Exception)c;
            }
            if (c instanceof Error) {
                throw (Error)c;
            }
            throw itx;
        }
        return p;
    }

    @Nonnull
    public static <T extends UrlPage> Constructor<T> getBestPageConstructor(@Nonnull Class<T> clz, boolean hasparam) {
        Constructor<?>[] car = clz.getConstructors();
        Constructor<?> bestcc = null;
        int score = 0;
        for (Constructor<?> cc : car) {
            int mod = cc.getModifiers();
            if (!Modifier.isPublic(mod)) continue;
            Class<?>[] par = cc.getParameterTypes();
            int sc = -1;
            if (par == null || par.length == 0) {
                if (score < 1) {
                    sc = 1;
                }
            } else {
                sc = 3;
                int cnt = 0;
                int pcnt = 0;
                int nparam = 0;
                for (Class<?> pc : par) {
                    if (ConversationContext.class.isAssignableFrom(pc)) {
                        ++cnt;
                        sc += 2;
                        ++nparam;
                        continue;
                    }
                    if (!PageParameters.class.isAssignableFrom(pc) && !IPageParameters.class.isAssignableFrom(pc)) continue;
                    sc = hasparam ? ++sc : --sc;
                    ++pcnt;
                    ++nparam;
                }
                if (cnt > 1 || pcnt > 1) {
                    WindowSession.LOG.info("Skipping silly constructor: " + cc);
                    continue;
                }
                if (nparam != par.length) {
                    WindowSession.LOG.info("Not all parameters can be filled-in: " + cc);
                    continue;
                }
            }
            if (sc <= score) continue;
            bestcc = cc;
            score = sc;
        }
        if (bestcc == null) {
            throw new IllegalStateException("The Page class " + clz + " does not have a suitable constructor.");
        }
        return bestcc;
    }

    @Nonnull
    public static <T extends UrlPage> Constructor<T> getPageConstructor(@Nonnull Class<T> clz, @Nonnull Class<? extends ConversationContext> ccclz, boolean hasparam) {
        Constructor<?> bestcc = null;
        int score = 0;
        for (Constructor<?> cc : clz.getConstructors()) {
            Class<?>[] par;
            int mod = cc.getModifiers();
            if (!Modifier.isPublic(mod) || (par = cc.getParameterTypes()) == null || par.length == 0) continue;
            boolean acc = false;
            int sc = 5;
            for (Class<?> pc : par) {
                if (PageParameters.class.isAssignableFrom(pc)) {
                    if (hasparam) {
                        ++sc;
                        continue;
                    }
                    --sc;
                    continue;
                }
                if (ccclz.isAssignableFrom(pc)) {
                    acc = true;
                    continue;
                }
                sc = -100;
                break;
            }
            if (!acc || sc <= score) continue;
            score = sc;
            bestcc = cc;
        }
        if (bestcc == null) {
            throw new IllegalStateException("The Page class " + clz + " does not have a suitable constructor.");
        }
        return bestcc;
    }

    @Nonnull
    public static Class<? extends ConversationContext> getConversationType(@Nonnull Constructor<? extends UrlPage> clz) {
        Class<?> ccclz = null;
        for (Class<?> pc : clz.getParameterTypes()) {
            if (!ConversationContext.class.isAssignableFrom(pc)) continue;
            if (ccclz != null) {
                throw new IllegalStateException(clz + ": duplicate conversation contexts in constructor??");
            }
            ccclz = pc;
        }
        if (ccclz == null) {
            return ConversationContext.class;
        }
        return ccclz;
    }
}

