/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.state;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.converter.CompoundKeyConverter;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConverter;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.state.IPageParameters;
import to.etc.domui.trouble.MissingParameterException;
import to.etc.domui.trouble.MultipleParameterException;
import to.etc.domui.trouble.UnusableParameterException;
import to.etc.domui.util.DomUtil;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;
import to.etc.webapp.query.IIdentifyable;

public class PageParameters
implements IPageParameters,
Serializable {
    private Map<String, Object> m_map = new HashMap<String, Object>();
    private boolean m_readOnly = false;
    private int m_dataLength;

    public PageParameters() {
    }

    public PageParameters(Object ... list) {
        try {
            this.addParameters(list);
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }

    @Override
    @Nonnull
    public PageParameters getUnlockedCopy() {
        PageParameters clone = new PageParameters();
        for (Map.Entry<String, Object> entry : this.m_map.entrySet()) {
            clone.addParameter(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    public void setReadOnly() {
        this.m_readOnly = true;
    }

    private void writeable() {
        if (this.m_readOnly) {
            throw new IllegalStateException("This object is readonly and cannot be changed.");
        }
    }

    private void setParameter(String name, String value) {
        this.increaseLength(value);
        Object o = this.m_map.put(name, value);
        this.decreaseLength(o);
    }

    private void decreaseLength(@Nullable Object o) {
        if (o instanceof String) {
            this.m_dataLength -= ((String)o).length() + 2;
        } else if (o instanceof String[]) {
            for (String s : (String[])o) {
                this.decreaseLength(s);
            }
        }
    }

    private void increaseLength(@Nullable String value) {
        if (null == value) {
            return;
        }
        this.m_dataLength += value.length() + 2;
    }

    private void setParameter(String name, String[] values) {
        if (null != values) {
            for (String s : values) {
                this.increaseLength(s);
            }
        }
        Object o = this.m_map.put(name, values);
        this.decreaseLength(o);
    }

    @Nullable
    private String getOne(String name) {
        Object v = this.m_map.get(name);
        if (null == v) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        String[] ar = (String[])v;
        if (ar.length == 0) {
            return null;
        }
        if (ar.length == 1) {
            return ar[0];
        }
        throw new MultipleParameterException(name);
    }

    @Nonnull
    private String getOneNotNull(String name) {
        String v = this.getOne(name);
        if (null == v) {
            throw new MissingParameterException(name);
        }
        return v;
    }

    public void addParameters(Object ... plist) throws Exception {
        this.writeable();
        int ix = 0;
        int len = plist.length;
        while (ix < len) {
            Object k;
            if ((k = plist[ix++]) instanceof String) {
                if (ix >= len) {
                    throw new IllegalStateException("Missing value for key string '" + k + "'");
                }
                this.internalAdd((String)k, plist[ix++]);
                continue;
            }
            if (k == null) continue;
            ClassMetaModel cmm = MetaManager.findClassMeta(k.getClass());
            if (!cmm.isPersistentClass()) {
                throw new IllegalStateException("Instance of " + k.getClass() + " is not a persistent class");
            }
            PropertyMetaModel<?> pkpm = cmm.getPrimaryKey();
            if (pkpm == null) {
                throw new IllegalStateException("The instance of " + k.getClass() + " passed has no primary key defined");
            }
            Object key = pkpm.getValue(k);
            if (key == null) {
                throw new IllegalStateException("The instance of " + k.getClass() + " passed has a null primary key");
            }
            String pk = cmm.getClassBundle().getString("pk.name");
            if (pk == null) {
                pk = k.getClass().getName();
                pk = pk.substring(pk.lastIndexOf(46) + 1);
            }
            this.setParameter(pk, String.valueOf(key));
        }
    }

    private void internalAdd(String k, Object o) throws Exception {
        IConverter<Date> dateConv;
        this.writeable();
        if (o == null) {
            return;
        }
        if (o instanceof IIdentifyable) {
            this.setParameter(k, String.valueOf(((IIdentifyable)o).getId()));
            return;
        }
        if (o instanceof String[]) {
            String[] ar = (String[])o;
            if (ar.length > 0) {
                this.setParameter(k, ar);
            }
            return;
        }
        String keyval = null;
        ClassMetaModel cmm = MetaManager.findClassMeta(o.getClass());
        if (cmm.isPersistentClass()) {
            PropertyMetaModel<?> pkpm = cmm.getPrimaryKey();
            if (pkpm != null) {
                Object key = pkpm.getValue(o);
                if (key == null) {
                    throw new IllegalStateException("The instance of " + o.getClass() + " passed has a null primary key");
                }
                keyval = CompoundKeyConverter.INSTANCE.marshal(key);
            }
        } else if (o instanceof Date && null != (dateConv = ConverterRegistry.findURLConverter(Date.class))) {
            keyval = dateConv.convertObjectToString(Locale.getDefault(), (Date)o);
        }
        if (keyval == null) {
            keyval = String.valueOf(o);
        }
        this.setParameter(k, keyval);
    }

    public void addParameter(String name, Object value) {
        String s;
        this.writeable();
        if (value == null) {
            s = "null";
        } else if (value instanceof String) {
            s = (String)value;
        } else if (value instanceof Number) {
            s = value.toString();
        } else if (value instanceof Boolean) {
            s = value.toString();
        } else {
            if (value instanceof String[]) {
                this.setParameter(name, (String[])value);
                return;
            }
            throw new IllegalStateException("Cannot convert a " + value.getClass() + " to an URL parameter yet - parameter converters not implemented yet");
        }
        this.setParameter(name, s);
    }

    public void removeParameter(String name) {
        this.writeable();
        Object v = this.m_map.remove(name);
        this.decreaseLength(v);
    }

    @Override
    public boolean hasParameter(String name) {
        return this.m_map.containsKey(name);
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public int getInt(String name) {
        String v = this.getOneNotNull(name);
        try {
            return Integer.parseInt(v);
        }
        catch (Exception exception) {
            throw new UnusableParameterException(name, "int", v);
        }
    }

    @Override
    public int getInt(String name, int df) {
        String v = this.getOne(name);
        if (null != v && (v = v.trim()).length() > 0) {
            try {
                return Integer.parseInt(v);
            }
            catch (Exception x) {
                throw new UnusableParameterException(name, "int", v);
            }
        }
        return df;
    }

    @Override
    public long getLong(String name) {
        String v = this.getOneNotNull(name);
        try {
            return Long.parseLong(v);
        }
        catch (Exception exception) {
            throw new UnusableParameterException(name, "long", v);
        }
    }

    @Override
    public long getLong(String name, long df) {
        String v = this.getOne(name);
        if (null != v && (v = v.trim()).length() > 0) {
            try {
                return Long.parseLong(v);
            }
            catch (Exception x) {
                throw new UnusableParameterException(name, "long", v);
            }
        }
        return df;
    }

    @Override
    public boolean getBoolean(String name) {
        String v = this.getOneNotNull(name);
        try {
            return Boolean.parseBoolean(v);
        }
        catch (Exception exception) {
            throw new UnusableParameterException(name, "boolean", v);
        }
    }

    @Override
    public boolean getBoolean(String name, boolean df) {
        String v = this.getOne(name);
        if (null != v && (v = v.trim()).length() > 0) {
            try {
                v = v.toLowerCase();
                if (v.startsWith("y")) {
                    return true;
                }
                if (v.startsWith("n")) {
                    return false;
                }
                return Boolean.parseBoolean(v);
            }
            catch (Exception x) {
                throw new UnusableParameterException(name, "boolean", v);
            }
        }
        return df;
    }

    @Override
    public Long getLongW(String name) {
        String v = this.getOneNotNull(name);
        try {
            return Long.decode(v);
        }
        catch (Exception exception) {
            throw new UnusableParameterException(name, "long", v);
        }
    }

    @Override
    public Long getLongW(String name, long df) {
        return this.getLongW(name, (Long)df);
    }

    @Override
    public Long getLongW(String name, Long df) {
        String v = this.getOne(name);
        if (null != v && (v = v.trim()).length() > 0) {
            try {
                return Long.decode(v);
            }
            catch (Exception x) {
                throw new UnusableParameterException(name, "long", v);
            }
        }
        return df;
    }

    @Override
    @Nonnull
    public String getString(String name) {
        return this.getOneNotNull(name);
    }

    @Override
    @Nullable
    public String getString(String name, String df) {
        String v = this.getOne(name);
        return v == null ? df : v;
    }

    @Override
    @Nonnull
    public String[] getStringArray(@Nonnull String name) {
        String[] arr = this.getStringArray(name, null);
        if (null == arr) {
            throw new MissingParameterException(name);
        }
        return arr;
    }

    @Override
    @Nullable
    public String[] getStringArray(@Nonnull String name, @Nullable String[] deflt) {
        Object var = this.m_map.get(name);
        if (null != var) {
            if (var instanceof String) {
                return new String[]{(String)var};
            }
            String[] ar = (String[])var;
            if (ar.length >= 0) {
                return ar;
            }
        }
        return deflt;
    }

    @Nullable
    public Object getObject(String name) {
        return this.m_map.get(name);
    }

    public void putObject(@Nonnull String name, @Nullable Object value) {
        if (null == value) {
            this.m_map.remove(name);
        } else {
            this.m_map.put(name, value);
        }
    }

    @Nonnull
    public static PageParameters createFrom(IRequestContext ctx) {
        PageParameters pp = new PageParameters();
        for (String name : ctx.getParameterNames()) {
            String[] par;
            char c;
            if (name.length() <= 0 || (c = name.charAt(0)) == '_' || c == '$' || name.startsWith("webui") || (par = ctx.getParameters(name)) == null || par.length <= 0) continue;
            if (par.length == 1) {
                pp.setParameter(name, par[0]);
                continue;
            }
            pp.setParameter(name, par);
        }
        return pp;
    }

    @Nonnull
    public static PageParameters createFromEncodedUrlString(@Nonnull String paramsAsString) {
        String[] splits;
        PageParameters pp = new PageParameters();
        if (DomUtil.isBlank(paramsAsString)) {
            return pp;
        }
        if ((paramsAsString = paramsAsString.trim()).startsWith("?")) {
            paramsAsString = paramsAsString.substring(1);
        }
        if (DomUtil.isBlank(paramsAsString)) {
            return pp;
        }
        String asDecoded = StringTool.decodeURLEncoded((String)paramsAsString);
        for (String nameValue : splits = asDecoded.split("&")) {
            char c = nameValue.charAt(0);
            if (c == '_' || c == '$' || nameValue.startsWith("webui")) continue;
            String[] parts = nameValue.split("=");
            if (parts.length > 2 || parts.length == 0) {
                throw new IllegalArgumentException("Expected name=value pair, but found:" + nameValue);
            }
            if (parts.length != 2) continue;
            pp.m_map.put(parts[0], parts[1]);
        }
        return pp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> me : this.m_map.entrySet()) {
            String[] vals;
            if (me.getValue() instanceof String) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(me.getKey()).append('=').append(me.getValue());
                continue;
            }
            for (String s : vals = (String[])me.getValue()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(me.getKey()).append('=').append(s);
            }
        }
        return "Parameters: " + sb.toString();
    }

    @Override
    @Nonnull
    public String[] getParameterNames() {
        return this.m_map.keySet().toArray(new String[this.m_map.size()]);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PageParameters)) {
            return false;
        }
        PageParameters a = (PageParameters)obj;
        if (a.m_map.size() != this.m_map.size()) {
            return false;
        }
        for (String key : this.m_map.keySet()) {
            Object val;
            Object oval = a.m_map.get(key);
            if (this.compValues(oval, val = this.m_map.get(key))) continue;
            return false;
        }
        return true;
    }

    private boolean compValues(Object oval, Object val) {
        if (oval instanceof String && val instanceof String) {
            return oval.equals(val);
        }
        if (oval instanceof String[] && val instanceof String[]) {
            String[] a = (String[])oval;
            String[] b = (String[])val;
            if (a.length != b.length) {
                return false;
            }
            for (String av : a) {
                boolean found = false;
                for (String bv : b) {
                    if (!DomUtil.isEqual((Object)av, (Object)bv)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        throw new IllegalStateException("missing");
    }

    public static void applyChanges(PageParameters source, PageParameters changes) {
        for (String name : changes.getParameterNames()) {
            Object object;
            if (source.hasParameter(name)) {
                source.removeParameter(name);
            }
            if (null == (object = changes.getObject(name))) continue;
            source.addParameter(name, object);
        }
    }

    @Override
    @Nonnull
    public String calculateHashString() {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException x) {
            throw new RuntimeException("MISSING MANDATORY SECURITY DIGEST PROVIDER MD5: " + x.getMessage());
        }
        try {
            ArrayList<String> names = new ArrayList<String>(this.m_map.keySet());
            Collections.sort(names);
            for (String name : names) {
                Object val = this.m_map.get(name);
                if (null == val) continue;
                if (val instanceof String[]) {
                    Object[] allv = (String[])val;
                    Arrays.sort(allv);
                    for (Object s : allv) {
                        md.update(((String)s).getBytes("utf-8"));
                        md.update((byte)10);
                    }
                    continue;
                }
                md.update(val.toString().getBytes("utf-8"));
                md.update((byte)10);
            }
        }
        catch (UnsupportedEncodingException x) {
            throw WrappedException.wrap((Exception)x);
        }
        return StringTool.toHex((byte[])md.digest());
    }

    @Override
    public int getDataLength() {
        return this.m_dataLength;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Nonnull
    public static PageParameters decodeParameters(@Nullable String query) {
        if (null == query) {
            return new PageParameters();
        }
        String[] indiar = query.split("&");
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        for (String frag : indiar) {
            int pos = frag.indexOf(61);
            if (pos < 0) continue;
            String name = frag.substring(0, pos).toLowerCase();
            String value = frag.substring(pos + 1);
            name = StringTool.decodeURLEncoded((String)name);
            value = StringTool.decodeURLEncoded((String)value);
            ArrayList<String> l = (ArrayList<String>)map.get(name);
            if (null == l) {
                l = new ArrayList<String>();
                map.put(name, l);
            }
            l.add(value);
        }
        PageParameters pp = new PageParameters();
        for (Map.Entry me : map.entrySet()) {
            if (((List)me.getValue()).size() == 1) {
                pp.addParameter((String)me.getKey(), ((List)me.getValue()).get(0));
                continue;
            }
            pp.addParameter((String)me.getKey(), ((List)me.getValue()).toArray(new String[0]));
        }
        return pp;
    }
}

