/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.state;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.layout.IBreadCrumbTitler;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.IShelvedEntry;
import to.etc.domui.state.UIContext;
import to.etc.domui.state.WindowSession;
import to.etc.domui.util.DomUtil;
import to.etc.util.StringTool;

public final class ShelvedDomUIPage
implements IShelvedEntry {
    @Nonnull
    private final WindowSession m_session;
    @Nonnull
    private final Page m_page;

    public ShelvedDomUIPage(@Nonnull WindowSession ws, @Nonnull Page page) {
        this.m_page = page;
        this.m_session = ws;
    }

    @Override
    @Nonnull
    public String getName() {
        UrlPage body = this.getPage().getBody();
        if (body instanceof IBreadCrumbTitler) {
            return ((IBreadCrumbTitler)((Object)body)).getBreadcrumbName();
        }
        String pageTitle = body.getPageTitle();
        if (pageTitle != null && !StringTool.isBlank((String)pageTitle)) {
            return pageTitle;
        }
        String name = body.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    @Override
    @Nullable
    public String getTitle() {
        if (this.getPage().getBody() instanceof IBreadCrumbTitler) {
            IBreadCrumbTitler body = (IBreadCrumbTitler)((Object)this.getPage().getBody());
            return body.getBreadcrumbTitle();
        }
        return null;
    }

    @Nonnull
    public Page getPage() {
        return this.m_page;
    }

    @Override
    public void activate(@Nonnull RequestContextImpl ctx, boolean ajax) throws Exception {
        UIContext.internalSet(this.getPage());
        this.getPage().internalUnshelve();
        this.m_session.generateRedirect(ctx, this.getPage(), ajax);
    }

    @Override
    public void discard() {
        this.m_session.discardPage(this.getPage());
    }

    @Override
    public String getURL() {
        return DomUtil.createPageURL(this.getPage().getBody().getClass(), this.getPage().getPageParameters());
    }

    public String toString() {
        ConversationContext cc = this.getPage().internalGetConversation();
        return this.getPage() + " in " + cc + ": " + (cc == null ? "(null conv)" : cc.getState());
    }

    @Override
    public boolean isClose() {
        return false;
    }
}

