/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.state;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import to.etc.domui.dom.html.Page;
import to.etc.domui.login.ILoginAuthenticator;
import to.etc.domui.login.IUser;
import to.etc.domui.server.HttpServerRequestResponse;
import to.etc.domui.server.ILoginListener;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.IServerSession;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.trouble.NotLoggedInException;

public class UIContext {
    private static ThreadLocal<IRequestContext> m_current = new ThreadLocal();
    private static ThreadLocal<Page> m_page = new ThreadLocal();
    private static ThreadLocal<IUser> m_currentUser = new ThreadLocal();
    private static List<IgnoredHash> m_ignoredHashList = new ArrayList<IgnoredHash>();
    public static final String LOGIN_KEY = IUser.class.getName();

    @Nonnull
    public static IRequestContext getRequestContext() {
        IRequestContext rc = m_current.get();
        if (rc == null) {
            throw new IllegalStateException("No current request!");
        }
        return rc;
    }

    public static void internalSet(@Nonnull IRequestContext rc) throws Exception {
        m_current.set(rc);
        boolean ok = false;
        try {
            m_currentUser.set(UIContext.internalGetLoggedInUser(rc));
            ok = true;
        }
        finally {
            if (!ok) {
                UIContext.internalClear();
            }
        }
    }

    public static void internalClear() {
        m_current.set(null);
        m_currentUser.set(null);
        m_page.set(null);
    }

    public static void internalSet(Page pg) {
        m_page.set(pg);
    }

    @Nonnull
    public static Page getCurrentPage() {
        Page pg = m_page.get();
        if (pg == null) {
            throw new IllegalStateException("No current page");
        }
        return pg;
    }

    @Nullable
    public static Page internalGetPage() {
        return m_page.get();
    }

    @Nullable
    public static IRequestContext internalGetContext() {
        return m_current.get();
    }

    @Nonnull
    public static ConversationContext getCurrentConversation() {
        return UIContext.getCurrentPage().getConversation();
    }

    @Nullable
    public static IUser getCurrentUser() {
        return m_currentUser.get();
    }

    @Nonnull
    public static IUser getLoggedInUser() {
        IUser u = UIContext.getCurrentUser();
        if (u == null) {
            throw NotLoggedInException.create(UIContext.getRequestContext(), UIContext.getCurrentPage());
        }
        return u;
    }

    public static void registerTempFile(@Nonnull File tmpf) {
        ConversationContext cc = UIContext.getCurrentConversation();
        cc.registerTempFile(tmpf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUser internalGetLoggedInUser(IRequestContext rx) throws Exception {
        if (!(rx instanceof RequestContextImpl)) {
            return null;
        }
        RequestContextImpl rci = (RequestContextImpl)rx;
        HttpServerRequestResponse srr = null;
        if (rci.getRequestResponse() instanceof HttpServerRequestResponse) {
            srr = (HttpServerRequestResponse)rci.getRequestResponse();
        }
        if (srr != null) {
            HttpSession hs = srr.getRequest().getSession(false);
            if (hs == null) {
                return null;
            }
            HttpSession httpSession = hs;
            synchronized (httpSession) {
                String ruser;
                Object sval = hs.getAttribute(LOGIN_KEY);
                if (sval != null && sval instanceof IUser) {
                    return (IUser)sval;
                }
                Cookie[] car = srr.getRequest().getCookies();
                if (car != null) {
                    for (Cookie c : car) {
                        if (!c.getName().equals("domuiLogin")) continue;
                        String domval = c.getValue();
                        IUser user = UIContext.decodeCookie(rci, domval);
                        if (user != null) {
                            hs.setAttribute(LOGIN_KEY, (Object)user);
                            return user;
                        }
                        c.setMaxAge(10);
                        c.setValue("logout");
                        break;
                    }
                }
                if ((ruser = srr.getRequest().getRemoteUser()) != null) {
                    ILoginAuthenticator la = rci.getApplication().getLoginAuthenticator();
                    if (null == la) {
                        return null;
                    }
                    IUser user = la.authenticateUser(ruser, null);
                    if (user == null) {
                        throw new IllegalStateException("Internal: container has logged-in user '" + ruser + "', but authenticator class=" + la + " does not return an IUser for it!!");
                    }
                    hs.setAttribute(LOGIN_KEY, (Object)user);
                    return user;
                }
            }
        }
        return null;
    }

    private static synchronized void registerIgnoredHash(String hash) {
        m_ignoredHashList.add(new IgnoredHash(System.currentTimeMillis(), hash));
    }

    private static synchronized boolean isIgnoredHash(String hash) {
        long cts = System.currentTimeMillis() - 60000L;
        int i = m_ignoredHashList.size();
        while (--i >= 0) {
            IgnoredHash ih = m_ignoredHashList.get(i);
            if (ih.getHash().equalsIgnoreCase(hash)) {
                return true;
            }
            if (ih.getTs() >= cts) continue;
            m_ignoredHashList.remove(i);
        }
        return false;
    }

    private static IUser decodeCookie(RequestContextImpl rci, String cookie) {
        if (cookie == null) {
            return null;
        }
        String[] car = cookie.split(":");
        if (car.length != 3) {
            return null;
        }
        try {
            if (UIContext.isIgnoredHash(car[2])) {
                return null;
            }
            String uid = car[0];
            long ts = Long.parseLong(car[1]);
            ILoginAuthenticator la = rci.getApplication().getLoginAuthenticator();
            if (null == la) {
                return null;
            }
            return la.authenticateByCookie(uid, ts, car[2]);
        }
        catch (Exception x) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean login(String userid, String password) throws Exception {
        IRequestContext rcx = m_current.get();
        if (rcx == null) {
            throw new IllegalStateException("You can login from a server request only");
        }
        if (!(rcx instanceof RequestContextImpl)) {
            return false;
        }
        IServerSession hs = rcx.getServerSession(false);
        if (hs == null) {
            return false;
        }
        IServerSession iServerSession = hs;
        synchronized (iServerSession) {
            hs.setAttribute(LOGIN_KEY, null);
            ILoginAuthenticator la = rcx.getApplication().getLoginAuthenticator();
            if (la == null) {
                throw new IllegalStateException("There is no login authenticator set in the Application!");
            }
            IUser user = la.authenticateUser(userid, password);
            if (user == null) {
                return false;
            }
            hs.setAttribute(LOGIN_KEY, user);
            m_currentUser.set(user);
            List<ILoginListener> ll = rcx.getApplication().getLoginListenerList();
            for (ILoginListener l : ll) {
                l.userLogin(user);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logout() throws Exception {
        IRequestContext rcx = m_current.get();
        if (rcx == null) {
            throw new IllegalStateException("You can logout from a server request only");
        }
        if (!(rcx instanceof RequestContextImpl)) {
            return;
        }
        IServerSession hs = rcx.getServerSession(false);
        if (hs == null) {
            return;
        }
        UIContext.deleteLoginCookie(rcx);
        IServerSession iServerSession = hs;
        synchronized (iServerSession) {
            IUser user = UIContext.internalGetLoggedInUser(rcx);
            if (user == null) {
                return;
            }
            List<ILoginListener> ll = rcx.getApplication().getLoginListenerList();
            for (ILoginListener l : ll) {
                try {
                    l.userLogout(user);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            hs.setAttribute(LOGIN_KEY, null);
            m_currentUser.set(null);
            try {
                hs.invalidate();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public static Cookie createLoginCookie(long l) throws Exception {
        IUser user = m_currentUser.get();
        if (user == null) {
            return null;
        }
        IRequestContext rcx = m_current.get();
        if (rcx == null) {
            throw new IllegalStateException("You can login from a server request only");
        }
        if (!(rcx instanceof RequestContextImpl)) {
            return null;
        }
        RequestContextImpl ci = (RequestContextImpl)rcx;
        String auth = ci.getApplication().getLoginAuthenticator().calcCookieHash(user.getLoginID(), l);
        if (auth == null) {
            return null;
        }
        String value = user.getLoginID() + ":" + l + ":" + auth;
        Cookie k = new Cookie("domuiLogin", value);
        k.setMaxAge((int)((l - System.currentTimeMillis()) / 1000L));
        k.setPath(ci.getRequestResponse().getWebappContext());
        ci.getRequestResponse().addCookie(k);
        return k;
    }

    public static boolean deleteLoginCookie(IRequestContext rci) throws Exception {
        if (rci == null) {
            throw new IllegalStateException("You can logout from a server request only");
        }
        Cookie[] car = rci.getRequestResponse().getCookies();
        if (car != null) {
            for (Cookie c : car) {
                if (!c.getName().equals("domuiLogin")) continue;
                String[] var = c.getValue().split(":");
                if (var.length == 3) {
                    UIContext.registerIgnoredHash(var[2]);
                }
                Cookie k = new Cookie("domuiLogin", "logout");
                k.setMaxAge(60);
                k.setPath(rci.getRequestResponse().getWebappContext());
                rci.getRequestResponse().addCookie(k);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Cookie findCookie(@Nonnull String name) {
        IRequestContext rci = UIContext.getRequestContext();
        Cookie[] car = rci.getRequestResponse().getCookies();
        if (car == null || car.length == 0) {
            return null;
        }
        for (Cookie c : car) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public static String findCookieValue(@Nonnull String name) {
        Cookie c = UIContext.findCookie(name);
        return c == null ? null : c.getValue();
    }

    public static void setCookie(@Nonnull String name, String value, int maxage) {
        IRequestContext rci = UIContext.getRequestContext();
        Cookie k = new Cookie(name, value);
        k.setMaxAge(maxage);
        k.setPath("/" + rci.getRequestResponse().getWebappContext());
        rci.getRequestResponse().addCookie(k);
    }

    public static <T> T getSessionAttribute(Class<T> clz, String attrName, T defaultValue) {
        T val = UIContext.getSessionAttribute(clz, attrName);
        if (val != null) {
            return val;
        }
        UIContext.setSessionAttribute(attrName, defaultValue);
        return defaultValue;
    }

    public static <T> T getSessionAttribute(Class<T> clz, String attrName) {
        IRequestContext ctx = UIContext.getRequestContext();
        IServerSession hs = ctx.getServerSession(false);
        if (null == hs) {
            return null;
        }
        Object val = hs.getAttribute(attrName);
        if (val != null) {
            if (clz.isAssignableFrom(val.getClass())) {
                Object res = val;
                return (T)res;
            }
            throw new IllegalStateException("Session value of unexpected type: " + val.getClass().getCanonicalName() + ", expecting " + clz.getCanonicalName());
        }
        return null;
    }

    public static void setSessionAttribute(String attrName, Object value) {
        IRequestContext ctx = UIContext.getRequestContext();
        IServerSession hs = ctx.getServerSession(true);
        if (null == hs) {
            return;
        }
        hs.setAttribute(attrName, value);
    }

    private static final class IgnoredHash {
        private final long m_ts;
        private final String m_hash;

        public IgnoredHash(long ts, String hash) {
            this.m_ts = ts;
            this.m_hash = hash;
        }

        public long getTs() {
            return this.m_ts;
        }

        public String getHash() {
            return this.m_hash;
        }
    }
}

