/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.state;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.ApplicationRequestHandler;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.AppSession;
import to.etc.domui.state.CidPair;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.IPageParameters;
import to.etc.domui.state.IShelvedEntry;
import to.etc.domui.state.MoveMode;
import to.etc.domui.state.PageMaker;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.SavedPage;
import to.etc.domui.state.SavedWindow;
import to.etc.domui.state.ShelvedDomUIPage;
import to.etc.domui.state.UIContext;
import to.etc.domui.state.UserLogItem;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.INewPageInstantiated;
import to.etc.util.FileTool;
import to.etc.util.StringTool;

public final class WindowSession {
    static final Logger LOG = LoggerFactory.getLogger(WindowSession.class);
    @Nonnull
    private final AppSession m_appSession;
    @Nonnull
    private final String m_windowID;
    private final boolean m_developerMode;
    private final int m_id;
    private static int m_nextId;
    private final Map<String, ConversationContext> m_conversationMap = new HashMap<String, ConversationContext>();
    private final Map<String, Long> m_destroyedConversationMap = new HashMap<String, Long>();
    private final List<IShelvedEntry> m_shelvedPageStack = new ArrayList<IShelvedEntry>();
    private int m_nextCid;
    private boolean m_attached;
    @Nullable
    private Class<? extends ConversationContext> m_targetConversationClass;
    @Nullable
    private Class<? extends UrlPage> m_targetPageClass;
    @Nullable
    private IPageParameters m_targetPageParameters;
    @Nullable
    private ConversationContext m_targetConversation;
    @Nullable
    private MoveMode m_targetMode;
    @Nullable
    private String m_targetURL;
    private long m_lastUsed;
    private int m_obituaryTimer = -1;
    private int m_lastRequestedPageTag;
    private Map<String, Object> m_map = Collections.EMPTY_MAP;

    public WindowSession(@Nonnull AppSession session) {
        this.m_appSession = session;
        this.m_windowID = DomUtil.generateGUID();
        this.m_id = WindowSession.nextID();
        this.m_developerMode = session.getApplication().inDevelopmentMode();
    }

    private static synchronized int nextID() {
        return ++m_nextId;
    }

    @Nonnull
    public final DomApplication getApplication() {
        return this.m_appSession.getApplication();
    }

    @Nonnull
    public final String getWindowID() {
        return this.m_windowID;
    }

    synchronized int nextCID() {
        return ++this.m_nextCid;
    }

    @Nullable
    public ConversationContext findConversation(@Nonnull String cid) throws Exception {
        ConversationContext cc = this.m_conversationMap.get(cid);
        if (null != cc) {
            this.internalAttachConversations();
        }
        return cc;
    }

    @Nonnull
    List<ConversationContext> findConversationsFor(@Nonnull Class<? extends NodeBase> clz) throws Exception {
        ArrayList<ConversationContext> res = new ArrayList<ConversationContext>();
        for (ConversationContext cc : this.m_conversationMap.values()) {
            if (cc.findPage(clz) == null) continue;
            res.add(cc);
        }
        if (res.size() > 0) {
            this.internalAttachConversations();
        }
        return res;
    }

    void registerConversation(@Nonnull ConversationContext cc, @Nullable String cid) {
        if (cid == null) {
            cid = "c" + this.nextCID();
        }
        cc.initialize(this, cid);
        this.m_conversationMap.put(cc.getId(), cc);
    }

    public void internalAttachConversations() throws Exception {
        if (this.m_attached) {
            return;
        }
        for (ConversationContext cc : this.m_conversationMap.values()) {
            cc.internalAttach();
        }
        this.m_attached = true;
    }

    public void internalDetachConversations() {
        if (!this.m_attached) {
            return;
        }
        this.m_attached = false;
        for (ConversationContext cc : this.m_conversationMap.values()) {
            try {
                cc.internalDetach();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public void dump() {
        System.out.println("  " + this + ": Conversation list");
        for (ConversationContext cc : this.m_conversationMap.values()) {
            cc.dump();
        }
        System.out.println("  Page shelve");
        for (int i = 0; i < this.m_shelvedPageStack.size(); ++i) {
            IShelvedEntry se = this.m_shelvedPageStack.get(i);
            System.out.println("  " + i + ": " + se);
        }
    }

    void destroyWindow(boolean sessionDestroyed) {
        this.destroyConversations(sessionDestroyed);
        this.destroyDevelopmentStateFile();
    }

    void destroyConversations(boolean sessionDestroyed) {
        this.m_attached = false;
        for (ConversationContext cc : this.m_conversationMap.values()) {
            try {
                cc.internalDestroy(sessionDestroyed);
            }
            catch (Exception exception) {}
        }
        this.m_conversationMap.clear();
    }

    protected void destroyConversation(@Nonnull ConversationContext cc) {
        if (null == this.m_conversationMap.remove(cc.getId())) {
            return;
        }
        int i = this.m_shelvedPageStack.size();
        while (--i >= 0) {
            ShelvedDomUIPage sdp;
            IShelvedEntry she = this.m_shelvedPageStack.get(i);
            if (!(she instanceof ShelvedDomUIPage) || (sdp = (ShelvedDomUIPage)she).getPage().getConversation() != cc) continue;
            this.m_shelvedPageStack.remove(i);
        }
        try {
            if (cc.getState() == ConversationContext.ConversationState.ATTACHED) {
                cc.internalDetach();
            }
        }
        catch (Exception x) {
            LOG.error("Exception on onDetach() of destroyed conversation", (Throwable)x);
        }
        try {
            cc.internalDestroy(false);
        }
        catch (Exception x) {
            LOG.error("Exception in onDestroy() of destroyed conversation", (Throwable)x);
        }
        this.m_destroyedConversationMap.put(cc.getId(), System.currentTimeMillis());
    }

    public boolean isConversationDestroyed(@Nonnull String ccid) {
        boolean isdestroyed = this.m_destroyedConversationMap.containsKey(ccid);
        if (this.m_destroyedConversationMap.size() > 20) {
            long cts = System.currentTimeMillis() - 5000L;
            Iterator<Map.Entry<String, Long>> it = this.m_destroyedConversationMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Long> me = it.next();
                if (me.getValue() >= cts) continue;
                it.remove();
            }
        }
        return isdestroyed;
    }

    public ConversationContext createConversation(@Nonnull Class<? extends ConversationContext> clz) throws Exception {
        if (clz == null) {
            throw new IllegalStateException("Null");
        }
        ConversationContext cc = clz.newInstance();
        this.m_appSession.getApplication().internalCallConversationCreated(cc);
        return cc;
    }

    public void acceptNewConversation(@Nonnull ConversationContext cc) throws Exception {
        this.registerConversation(cc, null);
        cc.internalAttach();
        this.m_attached = true;
    }

    private void shelvePage(@Nonnull Page shelved) {
        if (shelved == null) {
            throw new IllegalStateException("Missing current page??");
        }
        this.m_shelvedPageStack.add(new ShelvedDomUIPage(this, shelved));
    }

    @Nonnull
    public List<IShelvedEntry> getShelvedPageStack() {
        return new ArrayList<IShelvedEntry>(this.m_shelvedPageStack);
    }

    public boolean handleExceptionGoto(@Nonnull RequestContextImpl ctx, @Nonnull Page currentpg, boolean ajax) throws Exception {
        MoveMode targetMode = this.getTargetMode();
        if (targetMode == null) {
            return false;
        }
        switch (targetMode) {
            default: {
                throw new IllegalStateException("UIGoto." + (Object)((Object)targetMode) + " is invalid when calling UIGoto from an exception listener");
            }
            case REPLACE: 
            case REDIRECT: 
            case NEW: 
            case SUB: 
        }
        return this.handleGoto(ctx, currentpg, ajax);
    }

    public boolean handleGoto(@Nonnull RequestContextImpl ctx, @Nonnull Page currentpg, boolean ajax) throws Exception {
        int psix;
        if (this.getTargetMode() == null) {
            return false;
        }
        if (this.getTargetMode() == MoveMode.BACK) {
            this.handleMoveBack(ctx, currentpg, ajax);
            return true;
        }
        if (this.getTargetMode() == MoveMode.REDIRECT) {
            String tu = this.m_targetURL;
            if (null == tu) {
                throw new IllegalStateException("No URL in redirect?");
            }
            if (tu.startsWith("/")) {
                tu = ctx.getRequestResponse().getHostURL() + tu.substring(1);
            } else if (tu.indexOf(58) == -1) {
                tu = ctx.getRelativePath(tu);
            }
            this.logUser(ctx, currentpg, "GOTO redirect to " + tu);
            this.generateRedirect(ctx, tu, ajax);
            return true;
        }
        Class<? extends UrlPage> clz = this.getTargetPageClass();
        if (clz == null) {
            return false;
        }
        ConversationContext cc = this.getTargetConversation();
        IPageParameters pp = this.getTargetPageParameters();
        Constructor<? extends UrlPage> bestpc = null;
        if (this.getTargetMode() == MoveMode.REPLACE) {
            int cursz = this.m_shelvedPageStack.size() - 1;
            if (cursz < 0) {
                cursz = 0;
            }
            this.clearShelve(cursz);
        }
        if ((psix = this.findInPageStack(cc, clz, pp)) != -1) {
            if (psix == this.m_shelvedPageStack.size() - 1) {
                this.logUser(ctx, currentpg, "GOTO " + (Object)((Object)this.getTargetMode()) + " to current page?");
            }
            this.clearShelve(psix + 1);
            this.internalAttachConversations();
            IShelvedEntry xse = this.m_shelvedPageStack.get(psix);
            if (!(xse instanceof ShelvedDomUIPage)) {
                throw new IllegalStateException("Shelve entry is not a domui page but " + xse);
            }
            Page currentPage = ((ShelvedDomUIPage)xse).getPage();
            if (currentPage == currentpg) {
                this.logUser(ctx, currentpg, "GOTO " + (Object)((Object)this.getTargetMode()) + " to current page - ignored");
                return false;
            }
            this.logUser(ctx, currentpg, "GOTO " + (Object)((Object)this.getTargetMode()) + " and unshelve page " + currentPage);
            UIContext.internalSet(currentPage);
            currentPage.internalUnshelve();
            this.generateRedirect(ctx, currentPage, ajax);
            this.saveWindowState();
            return true;
        }
        if (this.getTargetMode() == MoveMode.NEW || this.mustResetShelve(clz)) {
            this.clearShelve(0);
        } else if (this.getTargetMode() == MoveMode.SUB) {
            currentpg.internalShelve();
        } else if (this.getTargetMode() != MoveMode.REPLACE) {
            throw new IllegalStateException("Internal: don't know how to handle shelve mode " + (Object)((Object)this.getTargetMode()));
        }
        if (cc == null) {
            Class<? extends ConversationContext> coclz = this.getTargetConversationClass();
            if (coclz == null) {
                bestpc = PageMaker.getBestPageConstructor(clz, pp != null);
                coclz = PageMaker.getConversationType(bestpc);
            } else {
                bestpc = PageMaker.getPageConstructor(clz, coclz, pp != null);
            }
            cc = this.createConversation(coclz);
            this.acceptNewConversation(cc);
        } else {
            bestpc = PageMaker.getPageConstructor(clz, cc.getClass(), pp != null);
        }
        if (pp == null) {
            pp = new PageParameters();
        }
        Page currentPage = PageMaker.createPageWithContent(bestpc, cc, pp);
        this.logUser(ctx, currentpg, "GOTO " + (Object)((Object)this.getTargetMode()) + " to NEW page " + currentPage);
        UIContext.internalSet(currentPage);
        this.shelvePage(currentPage);
        this.callNewPageCreatedListeners(currentPage);
        this.generateRedirect(ctx, currentPage, ajax);
        this.saveWindowState();
        return true;
    }

    private boolean mustResetShelve(@Nonnull Class<? extends UrlPage> clz) {
        Class<? extends UrlPage> ac = this.m_appSession.getApplication().getRootPage();
        if (ac == null) {
            return false;
        }
        return clz.getName().equals(ac.getName());
    }

    void generateRedirect(@Nonnull RequestContextImpl ctx, @Nonnull Page to, boolean ajax) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(ctx.getRelativePath(to.getBody().getClass().getName()));
        sb.append('.');
        sb.append(ctx.getApplication().getUrlExtension());
        sb.append('?');
        StringTool.encodeURLEncoded((Appendable)sb, (String)"$cid");
        sb.append('=');
        sb.append(to.getConversation().getFullId());
        IPageParameters pp = to.getPageParameters();
        if (pp.getDataLength() > 1024) {
            to.getConversation().setAttribute("__ORIPP", pp);
            String hashString = pp.calculateHashString();
            PageParameters rpp = new PageParameters();
            pp = rpp;
            rpp.addParameter("xxxpck", hashString);
        }
        if (pp != null) {
            DomUtil.addUrlParameters(sb, pp, false);
        }
        this.generateRedirect(ctx, sb.toString(), ajax);
    }

    private void generateRedirect(@Nonnull RequestContextImpl ctx, @Nonnull String url, boolean ajax) throws Exception {
        if (ajax) {
            ApplicationRequestHandler.generateAjaxRedirect(ctx, url);
        } else {
            ApplicationRequestHandler.generateHttpRedirect(ctx, url, "Redirecting");
        }
    }

    private void handleMoveBack(@Nonnull RequestContextImpl ctx, @Nonnull Page currentpg, boolean ajax) throws Exception {
        int ix = this.m_shelvedPageStack.size() - 2;
        if (ix < 0) {
            this.clearShelve(0);
            Class<? extends UrlPage> clz = this.getApplication().getRootPage();
            this.logUser(ctx, currentpg, "GOTO root page");
            if (clz != null) {
                this.internalSetNextPage(MoveMode.NEW, this.getApplication().getRootPage(), null, null, null);
                this.handleGoto(ctx, currentpg, ajax);
            } else {
                this.generateRedirect(ctx, ctx.getRelativePath(""), ajax);
            }
            this.saveWindowState();
            return;
        }
        this.clearShelve(ix + 1);
        IShelvedEntry se = this.m_shelvedPageStack.get(ix);
        se.activate(ctx, ajax);
        this.logUser(ctx, currentpg, "Goto shelved page " + se.getURL());
        this.saveWindowState();
    }

    private void logUser(@Nonnull RequestContextImpl ctx, @Nonnull Page page, String string) {
        ConversationContext conversation = page.internalGetConversation();
        String cid = conversation == null ? null : conversation.getFullId();
        ctx.getSession().log(new UserLogItem(cid, page.getBody().getClass().getName(), null, null, string));
    }

    public void clearGoto() {
        this.m_targetConversationClass = null;
        this.m_targetPageClass = null;
        this.m_targetPageParameters = null;
        this.m_targetConversation = null;
        this.m_targetMode = null;
    }

    public void internalSetNextPage(@Nonnull MoveMode m, @Nullable Class<? extends UrlPage> clz, @Nullable ConversationContext cc, @Nullable Class<? extends ConversationContext> ccclz, @Nullable IPageParameters pp) {
        this.m_targetMode = m;
        this.m_targetPageClass = clz;
        this.m_targetConversationClass = ccclz;
        this.m_targetPageParameters = pp;
        this.m_targetConversation = cc;
    }

    public void internalSetRedirect(@Nonnull String targeturl) {
        this.m_targetMode = MoveMode.REDIRECT;
        this.m_targetURL = targeturl;
    }

    @Nullable
    public Class<? extends UrlPage> getTargetPageClass() {
        return this.m_targetPageClass;
    }

    @Nullable
    public IPageParameters getTargetPageParameters() {
        return this.m_targetPageParameters;
    }

    @Nullable
    public Class<? extends ConversationContext> getTargetConversationClass() {
        return this.m_targetConversationClass;
    }

    @Nullable
    public ConversationContext getTargetConversation() {
        return this.m_targetConversation;
    }

    @Nullable
    public MoveMode getTargetMode() {
        return this.m_targetMode;
    }

    private void clearShelve(int ix) {
        if (ix == 0) {
            this.m_shelvedPageStack.clear();
            this.destroyConversations(false);
            return;
        }
        if (ix < 0) {
            throw new IllegalStateException("?? index is invalid: " + ix);
        }
        while (this.m_shelvedPageStack.size() > ix) {
            IShelvedEntry se = this.m_shelvedPageStack.remove(this.m_shelvedPageStack.size() - 1);
            se.discard();
        }
    }

    void discardPage(@Nonnull Page pg) {
        boolean destroyc = true;
        ConversationContext conversation = pg.internalGetConversation();
        int i = this.m_shelvedPageStack.size();
        while (--i >= 0) {
            ShelvedDomUIPage sdp;
            IShelvedEntry se = this.m_shelvedPageStack.get(i);
            if (!(se instanceof ShelvedDomUIPage) || (sdp = (ShelvedDomUIPage)se).getPage().internalGetConversation() != conversation) continue;
            destroyc = false;
            break;
        }
        if (destroyc) {
            if (null != conversation) {
                this.destroyConversation(conversation);
            }
        } else {
            pg.getConversation().destroyPage(pg);
        }
    }

    public Page tryToMakeOrGetPage(@Nonnull IRequestContext rctx, @Nonnull Class<? extends UrlPage> clz, @Nullable PageParameters papa, @Nullable String action) throws Exception {
        int psix;
        ConversationContext cc = null;
        String cid = rctx.getParameter("$cid");
        if (cid != null) {
            CidPair cida = CidPair.decode(cid);
            cid = cida.getConversationId();
            cc = this.findConversation(cid);
        }
        if (cc != null && (psix = this.findInPageStack(cc, clz, papa)) != -1) {
            this.clearShelve(psix + 1);
            this.internalAttachConversations();
            ShelvedDomUIPage sdp = (ShelvedDomUIPage)this.m_shelvedPageStack.get(psix);
            Page pg = sdp.getPage();
            if (pg.isShelved()) {
                pg.internalUnshelve();
            }
            this.saveWindowState();
            return pg;
        }
        if (action != null && papa == null) {
            return null;
        }
        this.clearShelve(0);
        Constructor<? extends UrlPage> bestpc = PageMaker.getBestPageConstructor(clz, true);
        Class<? extends ConversationContext> ccclz = PageMaker.getConversationType(bestpc);
        ConversationContext coco = this.createConversation(ccclz);
        this.registerConversation(coco, cid);
        ConversationContext.LOG.debug("Created conversation=" + coco + " for new page=" + clz);
        this.internalAttachConversations();
        if (null == papa) {
            IllegalStateException ex = new IllegalStateException("Internal: trying to create a page for an AJAX request??");
            throw ex;
        }
        Page newpg = PageMaker.createPageWithContent(bestpc, coco, papa);
        this.shelvePage(newpg);
        this.callNewPageCreatedListeners(newpg);
        this.saveWindowState();
        return newpg;
    }

    private void callNewPageCreatedListeners(@Nonnull Page pg) throws Exception {
        for (INewPageInstantiated npi : this.getApplication().getNewPageInstantiatedListeners()) {
            npi.newPageCreated(pg.getBody());
        }
    }

    private int findInPageStack(@Nullable ConversationContext cc, @Nonnull Class<? extends UrlPage> clz, @Nullable IPageParameters papa) throws Exception {
        int ix = this.m_shelvedPageStack.size();
        while (--ix >= 0) {
            ShelvedDomUIPage sdp;
            IShelvedEntry se = this.m_shelvedPageStack.get(ix);
            if (!(se instanceof ShelvedDomUIPage) || !(sdp = (ShelvedDomUIPage)se).getPage().getBody().getClass().getName().equals(clz.getName()) || cc != null && cc != sdp.getPage().getConversation()) continue;
            if (papa == null) {
                return ix;
            }
            if (!papa.equals(sdp.getPage().getPageParameters())) continue;
            return ix;
        }
        return -1;
    }

    public boolean isPageOnStack(@Nonnull Class<? extends UrlPage> clz, @Nonnull IPageParameters papa) throws Exception {
        int ix = this.m_shelvedPageStack.size();
        while (--ix >= 0) {
            ShelvedDomUIPage sdp;
            IShelvedEntry se = this.m_shelvedPageStack.get(ix);
            if (!(se instanceof ShelvedDomUIPage) || !(sdp = (ShelvedDomUIPage)se).getPage().getBody().getClass().getName().equals(clz.getName()) || !sdp.getPage().getPageParameters().equals(papa)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public String toString() {
        return "Window[" + this.m_id + ":" + this.m_windowID + "]";
    }

    public long getLastUsed() {
        return this.m_lastUsed;
    }

    void internalTouched() {
        this.m_lastUsed = System.currentTimeMillis();
    }

    int getObituaryTimer() {
        return this.m_obituaryTimer;
    }

    void setObituaryTimer(int obituaryTimer) {
        this.m_obituaryTimer = obituaryTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalSetLastPage(@Nonnull Page page) {
        AppSession appSession = this.m_appSession;
        synchronized (appSession) {
            this.m_lastRequestedPageTag = page.getPageTag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int internalGetLastPageTag() {
        AppSession appSession = this.m_appSession;
        synchronized (appSession) {
            return this.m_lastRequestedPageTag;
        }
    }

    public void setAttribute(@Nonnull String name, @Nullable Object val) {
        if (this.m_map == Collections.EMPTY_MAP) {
            this.m_map = new HashMap<String, Object>();
        }
        if (val == null) {
            this.m_map.remove(name);
        } else {
            this.m_map.put(name, val);
        }
    }

    @Nullable
    public Object getAttribute(@Nonnull String name) {
        return this.m_map.get(name);
    }

    public void addShelveEntry(int depth, @Nonnull IShelvedEntry entry) {
        if (depth > 0) {
            throw new IllegalArgumentException("Depth must be <= 0");
        }
        int ix = this.m_shelvedPageStack.size() + depth;
        if (ix < 0) {
            throw new IllegalArgumentException("Depth of " + depth + " invalid: max is " + -this.m_shelvedPageStack.size());
        }
        this.m_shelvedPageStack.add(ix, entry);
    }

    public boolean insertShelveEntry(int depth, @Nonnull Class<? extends UrlPage> clz, @Nonnull IPageParameters parameters) throws Exception {
        boolean res = null != this.insertShelveEntryMain(depth, clz, parameters);
        this.saveWindowState();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Page insertShelveEntryMain(int depth, @Nonnull Class<? extends UrlPage> clz, @Nonnull IPageParameters parameters) throws Exception {
        if (this.isPageOnStack(clz, parameters)) {
            return null;
        }
        Constructor<? extends UrlPage> bestpc = PageMaker.getBestPageConstructor(clz, true);
        Class<? extends ConversationContext> ccclz = PageMaker.getConversationType(bestpc);
        ConversationContext coco = this.createConversation(ccclz);
        boolean ok = false;
        Page prevpage = UIContext.internalGetPage();
        try {
            this.registerConversation(coco, null);
            ConversationContext.LOG.debug("Created conversation=" + coco + " for new page=" + clz);
            this.internalAttachConversations();
            if (coco.getState() == ConversationContext.ConversationState.DETACHED) {
                coco.internalAttach();
            }
            Page newpg = PageMaker.createPageWithContent(bestpc, coco, parameters);
            if (depth > 0) {
                throw new IllegalArgumentException("Depth must be <= 0");
            }
            int ix = this.m_shelvedPageStack.size() + depth;
            if (ix < 0) {
                throw new IllegalArgumentException("Depth of " + depth + " invalid: max is " + -this.m_shelvedPageStack.size());
            }
            this.m_shelvedPageStack.add(ix, new ShelvedDomUIPage(this, newpg));
            this.getApplication().getInjector().injectPageValues(newpg.getBody(), parameters);
            newpg.setInjected(true);
            UIContext.internalSet(newpg);
            newpg.internalFullBuild();
            this.callNewPageCreatedListeners(newpg);
            newpg.internalShelve();
            ok = true;
            Page page = newpg;
            return page;
        }
        finally {
            UIContext.internalSet(prevpage);
            try {
                if (!ok) {
                    this.destroyConversation(coco);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    @Nonnull
    List<SavedPage> getSavedPageList() {
        ArrayList<SavedPage> res = new ArrayList<SavedPage>(this.m_shelvedPageStack.size());
        for (IShelvedEntry se : this.m_shelvedPageStack) {
            if (!(se instanceof ShelvedDomUIPage)) continue;
            ShelvedDomUIPage dp = (ShelvedDomUIPage)se;
            res.add(new SavedPage(dp.getPage().getBody().getClass().getName(), dp.getPage().getPageParameters()));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String internalAttemptReload(@Nonnull HttpSession hs, @Nonnull Class<? extends UrlPage> clz2, @Nonnull PageParameters pageParameters, @Nonnull String oldWindowId) {
        List list;
        SavedWindow sw = (SavedWindow)hs.getAttribute(oldWindowId);
        if (null != sw) {
            hs.removeAttribute(oldWindowId);
            list = sw.getPageList();
            System.out.println("arh: reload " + oldWindowId + " using session state " + sw);
        } else {
            File f;
            block16: {
                String string;
                if (!this.m_developerMode) {
                    return null;
                }
                f = WindowSession.getStateFile(oldWindowId);
                if (!f.exists()) {
                    return null;
                }
                try {
                    list = (List)FileTool.loadSerialized((File)f);
                    if (null != list) break block16;
                    string = null;
                }
                catch (Exception x) {
                    String string2;
                    try {
                        string2 = null;
                    }
                    catch (Throwable throwable) {
                        FileTool.closeAll((Object[])new Object[]{f});
                        throw throwable;
                    }
                    FileTool.closeAll((Object[])new Object[]{f});
                    return string2;
                }
                FileTool.closeAll((Object[])new Object[]{f});
                return string;
            }
            FileTool.closeAll((Object[])new Object[]{f});
            System.out.println("arh: reload " + oldWindowId + " using file " + f + ", " + list);
        }
        String conversationId = null;
        try {
            this.internalAttachConversations();
            for (SavedPage sp : list) {
                try {
                    ConversationContext cc;
                    Class<? extends UrlPage> clz = this.m_appSession.getApplication().loadPageClass(sp.getClassName());
                    Page pg = this.insertShelveEntryMain(0, clz, sp.getParameters());
                    if (null == pg || !clz2.getName().equals(sp.getClassName()) || !sp.getParameters().equals(pageParameters) || null == (cc = pg.internalGetConversation())) continue;
                    conversationId = cc.getId();
                }
                catch (Exception x) {
                    System.err.println("domui: developer page reload failed: " + x);
                    x.printStackTrace();
                    LOG.info("Cannot reload " + sp.getClassName() + ": " + x);
                }
            }
            this.saveWindowState();
            Iterator x = conversationId;
            return x;
        }
        catch (Exception x) {
            System.err.println("domui: developer reload failed: " + x);
            x.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.internalDetachConversations();
        }
    }

    @Nonnull
    private static File getStateFile(@Nonnull String sessionID) {
        File tmpdir = FileTool.getTmpDir();
        return new File(tmpdir, "domui-session-" + sessionID);
    }

    private void saveWindowState() {
        if (!this.m_developerMode) {
            return;
        }
        try {
            FileTool.saveSerialized((File)WindowSession.getStateFile(this.getWindowID()), (Serializable)((Serializable)((Object)this.getSavedPageList())));
        }
        catch (Exception x) {
            LOG.error("Failed to save developer mode window state: " + x, (Throwable)x);
        }
    }

    private void destroyDevelopmentStateFile() {
        if (!this.m_developerMode) {
            return;
        }
        File sf = WindowSession.getStateFile(this.getWindowID());
        if (sf.exists()) {
            sf.delete();
        }
    }
}

