/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.testsupport;

import java.io.File;
import java.io.StringWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.HtmlFullRenderer;
import to.etc.domui.dom.IBrowserOutput;
import to.etc.domui.dom.PrettyXmlOutputWriter;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.BrowserVersion;
import to.etc.domui.server.ConfigParameters;
import to.etc.domui.server.DomApplication;
import to.etc.domui.state.AppSession;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.UIContext;
import to.etc.domui.state.WindowSession;
import to.etc.domui.testsupport.TestRequestContext;

public class TUtilDomUI {
    private static volatile AppSession m_session;
    private static DomApplication m_application;

    public static synchronized void setApplication(DomApplication application) throws Exception {
        ConfigParameters cp = new ConfigParameters(){

            @Override
            public String getString(@Nonnull String name) {
                return null;
            }

            @Override
            @Nonnull
            public File getWebFileRoot() {
                return new File("/tmp");
            }
        };
        application.internalInitialize(cp, false);
        m_application = application;
    }

    public static synchronized DomApplication getApplication() throws Exception {
        if (m_application == null) {
            m_application = new DomApplication(){

                @Override
                public Class<? extends UrlPage> getRootPage() {
                    return null;
                }
            };
            ConfigParameters cp = new ConfigParameters(){

                @Override
                @Nullable
                public String getString(@Nonnull String name) {
                    return null;
                }

                @Override
                @Nonnull
                public File getWebFileRoot() {
                    return new File("/tmp");
                }
            };
            m_application.internalInitialize(cp, false);
        }
        return m_application;
    }

    public static AppSession getAppSession() throws Exception {
        TUtilDomUI.getApplication();
        if (m_session == null) {
            m_session = new AppSession(TUtilDomUI.getApplication());
        }
        return m_session;
    }

    public static BrowserVersion getBrowserVersion() {
        return TUtilDomUI.getBrowserVersionFFox30();
    }

    public static BrowserVersion getBrowserVersionIE7() {
        return BrowserVersion.parseUserAgent("Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 2.0.50727)");
    }

    public static BrowserVersion getBrowserVersionIE8() {
        return BrowserVersion.parseUserAgent("Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; .NET CLR 2.0.50727)");
    }

    public static BrowserVersion getBrowserVersionFFox30() {
        return BrowserVersion.parseUserAgent("Mozilla/5.0 (X11; U; Linux x86_64; en-US; rv:1.9.0.14) Gecko/2009090217 Ubuntu/9.04 (jaunty) Firefox/3.0.14");
    }

    public static BrowserVersion getBrowserVersionKonqueror() {
        return BrowserVersion.parseUserAgent("Mozilla/5.0 (compatible; Konqueror/3.5; Linux; en_US) KHTML/3.5.10 (like Gecko) (Debian)");
    }

    private static Page initPage(UrlPage pg, PageParameters pp) throws Exception {
        TUtilDomUI.getApplication();
        if (pp == null) {
            pp = new PageParameters();
        }
        Page p = new Page(pg);
        WindowSession ws = new WindowSession(TUtilDomUI.getAppSession());
        ConversationContext cc = new ConversationContext();
        ws.acceptNewConversation(cc);
        p.internalInitialize(pp, cc);
        cc.internalRegisterPage(p, pp);
        return p;
    }

    public static Page createPage(Class<? extends UrlPage> clz, PageParameters pp) throws Exception {
        if (pp == null) {
            pp = new PageParameters();
        }
        UrlPage pg = clz.newInstance();
        Page p = TUtilDomUI.initPage(pg, pp);
        return p;
    }

    public static Page createPage(Class<? extends UrlPage> clz) throws Exception {
        return TUtilDomUI.createPage(clz, null);
    }

    public static UrlPage createBody() throws Exception {
        return TUtilDomUI.createPage(UrlPage.class).getBody();
    }

    public static UrlPage createBody(PageParameters pp) throws Exception {
        return TUtilDomUI.createPage(UrlPage.class, pp).getBody();
    }

    public static <T extends UrlPage> T createBody(Class<T> clz, PageParameters pp) throws Exception {
        return (T)TUtilDomUI.createPage(clz, pp).getBody();
    }

    public static <T extends UrlPage> T createBody(Class<T> clz) throws Exception {
        return (T)TUtilDomUI.createPage(clz, null).getBody();
    }

    public static HtmlFullRenderer getFullRenderer(IBrowserOutput o) throws Exception {
        BrowserVersion bv = TUtilDomUI.getBrowserVersion();
        return TUtilDomUI.getApplication().findRendererFor(bv, o);
    }

    public static String getFullRenderText(Page pg) throws Exception {
        return TUtilDomUI.getFullRenderText(TUtilDomUI.getBrowserVersion(), pg);
    }

    public static String getFullRenderText(NodeBase nd) throws Exception {
        return TUtilDomUI.getFullRenderText(TUtilDomUI.getBrowserVersion(), nd.getPage());
    }

    public static String getFullRenderText(BrowserVersion bv, Page pg) throws Exception {
        StringWriter sw = new StringWriter();
        PrettyXmlOutputWriter ro = new PrettyXmlOutputWriter(sw);
        HtmlFullRenderer hr = TUtilDomUI.getFullRenderer(ro);
        TestRequestContext ctx = new TestRequestContext();
        UIContext.internalSet(pg);
        UIContext.internalSet(ctx);
        pg.internalFullBuild();
        hr.render(ctx, pg);
        pg.internalClearDeltaFully();
        return sw.getBuffer().toString();
    }
}

