/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.testsupport.ui;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import to.etc.domui.annotations.UIUrlParameter;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.input.DateInput;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.util.DomUtil;

public class DateInputTestPage
extends UrlPage {
    private boolean m_withtime;
    @Nullable
    private Div m_result;

    @UIUrlParameter(name="withtime")
    public boolean isWithtime() {
        return this.m_withtime;
    }

    public void setWithtime(boolean withtime) {
        this.m_withtime = withtime;
    }

    @Override
    public void createContent() throws Exception {
        final DateInput di = new DateInput(this.isWithtime());
        this.preventAlertsFromOpening();
        this.add(di);
        di.setTestID("datein");
        DefaultButton button = new DefaultButton("Click", new IClicked<DefaultButton>(){

            @Override
            public void clicked(DefaultButton clickednode) throws Exception {
                Date dt = (Date)di.getValueSafe();
                Div result = DateInputTestPage.this.m_result;
                if (null == result) {
                    result = new Div();
                    DateInputTestPage.this.m_result = result;
                    DateInputTestPage.this.add(result);
                    result.setTestID("result");
                }
                result.removeAllChildren();
                if (dt == null) {
                    result.setText("error");
                } else {
                    SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
                    result.setText(df.format(dt));
                }
            }
        });
        button.setTestID("btn");
        this.add(button);
        DefaultButton clear = new DefaultButton("Click", new IClicked<DefaultButton>(){

            @Override
            public void clicked(DefaultButton clickednode) throws Exception {
                di.setValue(null);
                Div result = DateInputTestPage.this.m_result;
                if (null != result) {
                    result.remove();
                    DateInputTestPage.this.m_result = null;
                }
            }
        });
        clear.setTestID("clear");
        this.add(clear);
    }

    protected void preventAlertsFromOpening() {
        StringBuilder sb = new StringBuilder();
        sb.append("var defaultAlert = alert;");
        sb.append("alert = function(message){");
        sb.append("\t\tconsole.log('Alert blocked: ' + message);");
        sb.append("}");
        this.appendCreateJS(DomUtil.nullChecked(sb.toString()));
    }
}

