/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.themes;

import javax.annotation.concurrent.Immutable;
import to.etc.util.StringTool;

@Immutable
public final class CssColor {
    private final int m_r;
    private final int m_g;
    private final int m_b;
    private boolean m_hsl;
    private double m_h;
    private double m_hsl_s;
    private double m_hsl_l;
    private double m_hsv_v;
    private double m_hsv_s;

    public CssColor(double rin, double gin, double bin) {
        this((int)(rin + 0.5), (int)(gin + 0.5), (int)(bin + 0.5));
    }

    public CssColor(int rin, int gin, int bin) {
        int n = rin < 0 ? 0 : (this.m_r = rin > 255 ? 255 : rin);
        int n2 = gin < 0 ? 0 : (this.m_g = gin > 255 ? 255 : gin);
        this.m_b = bin < 0 ? 0 : (bin > 255 ? 255 : bin);
    }

    public CssColor(CssColor in) {
        this.m_g = in.m_g;
        this.m_r = in.m_r;
        this.m_b = in.m_b;
    }

    public CssColor(String rgbin) {
        int iv;
        String rgb = rgbin.trim();
        if (rgb.startsWith("#")) {
            rgb = rgb.substring(1).trim();
        }
        try {
            iv = Integer.parseInt(rgb, 16);
        }
        catch (Exception x) {
            System.out.println("Invalid color value: " + rgbin);
            iv = 0x3388EE;
        }
        this.m_r = iv >> 16 & 0xFF;
        this.m_g = iv >> 8 & 0xFF;
        this.m_b = iv & 0xFF;
    }

    public double luminance() {
        return (double)(this.m_r + this.m_g + this.m_b) / 3.0;
    }

    public boolean isLight() {
        return this.luminance() >= 128.0;
    }

    public boolean isDark() {
        return this.luminance() < 128.0;
    }

    public CssColor brighter(double factor) {
        if (factor < 0.0 || factor > 1.0) {
            throw new IllegalStateException("Factor must be 0..1");
        }
        int dr = 255 - this.m_r;
        int dg = 255 - this.m_g;
        int db = 255 - this.m_b;
        return new CssColor((double)this.m_r + (double)dr * factor, (double)this.m_g + (double)dg * factor, (double)this.m_b + (double)db * factor);
    }

    public CssColor lighter(double factor) {
        return this.brighter(factor);
    }

    public CssColor darker(double factor) {
        if (factor < 0.0 || factor >= 1.0) {
            throw new IllegalStateException("Factor must be 0..1");
        }
        factor = 1.0 - factor;
        return new CssColor((double)this.m_r * factor, (double)this.m_g * factor, (double)this.m_b * factor);
    }

    public CssColor inverse() {
        return new CssColor(255 - this.m_r, 255 - this.m_g, 255 - this.m_b);
    }

    public CssColor lume(double factor) {
        if (this.isLight()) {
            return this.darker(factor);
        }
        return this.lighter(factor);
    }

    public CssColor saturate(double factor) {
        double s = this.getHsvS();
        if ((s *= factor) > 1.0) {
            s = 1.0;
        }
        return CssColor.createHSV(this.getHsvH(), s, this.getHsvV());
    }

    public double luminanceContrast(CssColor other) {
        return CssColor.luminanceContrast(this, other);
    }

    public static double luminanceContrast(CssColor a, CssColor b) {
        double l1 = a.luminance();
        double l2 = b.luminance();
        if (l2 > l1) {
            double t = l1;
            l1 = l2;
            l2 = t;
        }
        return (l1 + 0.5) / (l2 + 0.5);
    }

    public double brightnessDifference(CssColor col) {
        return CssColor.brightnessDifference(this, col);
    }

    public static double brightnessDifference(CssColor a, CssColor b) {
        double bb;
        double ba = a.colorBrightness();
        return ba > (bb = b.colorBrightness()) ? ba - bb : bb - ba;
    }

    public double colorBrightness() {
        return ((double)this.m_r * 299.0 + (double)this.m_g * 587.0 + (double)this.m_b * 114.0) / 255000.0;
    }

    public double colorContrast(CssColor col) {
        return CssColor.colorContrast(this, col);
    }

    public static double colorContrast(CssColor a, CssColor b) {
        int dr = Math.abs(a.m_r - b.m_r);
        int dg = Math.abs(a.m_g - b.m_g);
        int db = Math.abs(a.m_b - b.m_b);
        return ((double)dr + (double)dg + (double)db) / 768.0;
    }

    public String toString() {
        return "#" + StringTool.intToStr((int)this.m_r, (int)16, (int)2) + StringTool.intToStr((int)this.m_g, (int)16, (int)2) + StringTool.intToStr((int)this.m_b, (int)16, (int)2);
    }

    public String det() {
        return this.toString() + " (lum=" + this.luminance() + ", bri=" + this.colorBrightness() + ")";
    }

    private void calcHSLOld() {
        int lm;
        if (this.m_hsl) {
            return;
        }
        int um = this.m_r;
        if (this.m_g > um) {
            um = this.m_g;
        }
        if (this.m_b > um) {
            um = this.m_b;
        }
        if (this.m_g < (lm = this.m_r)) {
            lm = this.m_g;
        }
        if (this.m_b < lm) {
            lm = this.m_b;
        }
        this.m_hsl_l = (double)(lm + um) / 510.0;
        this.m_hsv_v = (double)um / 255.0;
        if (um - lm == 0) {
            this.m_hsl_s = 0.0;
            this.m_hsv_s = 0.0;
            this.m_h = 0.0;
        } else {
            double d = (double)(um - lm) / 255.0;
            this.m_hsl_s = this.m_hsl_l > 0.0 ? d / (1.0 - Math.abs(2.0 * this.m_hsl_l - 1.0)) : 0.0;
            this.m_hsv_s = um - lm == 0 ? 0.0 : d / this.m_hsv_v;
            this.m_h = Math.acos(((double)this.m_r - 0.5 * (double)this.m_g - 0.5 * (double)this.m_b) / Math.sqrt(this.m_r * this.m_r + this.m_b * this.m_b + this.m_g * this.m_g - this.m_r * this.m_g - this.m_r * this.m_b - this.m_g * this.m_b)) / Math.PI * 180.0;
            if (this.m_b > this.m_g) {
                this.m_h = 360.0 - this.m_h;
            }
        }
        this.m_hsl = true;
    }

    public double getHslL() {
        this.calcHSL();
        return this.m_hsl_l;
    }

    public double getHsvV() {
        this.calcHSL();
        return this.m_hsv_v;
    }

    public double getHslS() {
        this.calcHSL();
        return this.m_hsl_s;
    }

    public double getHsvS() {
        this.calcHSL();
        return this.m_hsv_s;
    }

    public double getHslH() {
        this.calcHSL();
        return this.m_h;
    }

    public double getHsvH() {
        this.calcHSL();
        return this.m_h;
    }

    public static CssColor createHSL(double h, double s, double l) {
        int b;
        int g;
        int r;
        double d = s * (1.0 - Math.abs(2.0 * l - 1.0));
        double m = 255.0 * (l - 0.5 * d);
        double mod2 = h / 60.0;
        int fac = (int)(mod2 / 2.0);
        double x = d * (1.0 - Math.abs((mod2 -= (double)(fac * 2)) - 1.0));
        int sextant = (int)(h / 60.0);
        switch (sextant) {
            default: {
                throw new IllegalArgumentException("Bad h=" + h);
            }
            case 0: {
                r = (int)(255.0 * d + m);
                g = (int)(255.0 * x + m);
                b = (int)m;
                break;
            }
            case 1: {
                r = (int)(255.0 * x + m);
                g = (int)(255.0 * d + m);
                b = (int)m;
                break;
            }
            case 2: {
                r = (int)m;
                g = (int)(255.0 * d + m);
                b = (int)(255.0 * x + m);
                break;
            }
            case 3: {
                r = (int)m;
                g = (int)(255.0 * x + m);
                b = (int)(255.0 * d + m);
                break;
            }
            case 4: {
                r = (int)(255.0 * x + m);
                g = (int)m;
                b = (int)(255.0 * d + m);
                break;
            }
            case 5: {
                r = (int)(255.0 * d + m);
                g = (int)m;
                b = (int)(255.0 * x + m);
            }
        }
        return new CssColor(r, g, b);
    }

    private void calcHSL() {
        double max;
        if (this.m_hsl) {
            return;
        }
        double r = (double)this.m_r / 255.0;
        double g = (double)this.m_g / 255.0;
        double b = (double)this.m_b / 255.0;
        double min = r;
        if (g < min) {
            min = g;
        }
        if (b < min) {
            min = b;
        }
        if (g > (max = r)) {
            max = g;
        }
        if (b > max) {
            max = b;
        }
        this.m_hsl_l = (max + min) / 2.0;
        this.m_hsv_v = max;
        double d = max - min;
        this.m_hsl_s = max == min ? 0.0 : (this.m_hsl_l > 0.5 ? d / (2.0 - max - min) : d / (max + min));
        double d2 = this.m_hsv_s = max == 0.0 ? 0.0 : d / max;
        if (max == min) {
            this.m_h = 0.0;
        } else {
            if (max == r) {
                this.m_h = (g - b) / d + (double)(g < b ? 6 : 0);
            } else if (max == g) {
                this.m_h = (b - r) / d + 2.0;
            } else if (max == b) {
                this.m_h = (r - g) / d + 4.0;
            } else {
                throw new IllegalStateException();
            }
            this.m_h = this.m_h / 6.0 * 360.0;
        }
        this.m_hsl = true;
    }

    public static CssColor createHSV(double h, double s, double v) {
        double b;
        double g;
        double r;
        double i = Math.floor((h /= 360.0) * 6.0);
        double f = h * 6.0 - i;
        double p = v * (1.0 - s);
        double q = v * (1.0 - f * s);
        double t = v * (1.0 - (1.0 - f) * s);
        switch ((int)i % 6) {
            default: {
                throw new IllegalStateException();
            }
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        return new CssColor(255.0 * r, 255.0 * g, 255.0 * b);
    }

    public static void main(String[] args) {
        CssColor c = new CssColor(206, 206, 250);
        System.out.println("HSL=" + c.getHslH() + ", " + c.getHslS() + ", " + c.getHslL());
        System.out.println("HSV=" + c.getHsvH() + ", " + c.getHsvS() + ", " + c.getHsvV());
        CssColor nw = CssColor.createHSV(c.getHsvH(), 1.0, c.getHsvV());
        System.out.println("new = " + nw);
        System.out.println("HSL=" + nw.getHslH() + ", " + nw.getHslS() + ", " + nw.getHslL());
        System.out.println("HSV=" + nw.getHsvH() + ", " + nw.getHsvS() + ", " + nw.getHsvV());
    }
}

