/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.themes;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.server.BrowserVersion;
import to.etc.domui.server.DomApplication;
import to.etc.domui.themes.DefaultThemeVariant;
import to.etc.domui.themes.FragmentedThemeStore;
import to.etc.domui.themes.ITheme;
import to.etc.domui.themes.IThemeFactory;
import to.etc.domui.themes.StyleException;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.js.RhinoExecutor;
import to.etc.domui.util.js.RhinoExecutorFactory;
import to.etc.domui.util.js.RhinoTemplate;
import to.etc.domui.util.js.RhinoTemplateCompiler;
import to.etc.domui.util.resources.ClasspathInventory;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.domui.util.resources.ResourceDependencies;
import to.etc.domui.util.resources.ResourceDependencyList;
import to.etc.util.FileTool;
import to.etc.util.StringTool;

@DefaultNonNull
public class FragmentedThemeFactory {
    private static final IThemeFactory INSTANCE = new IThemeFactory(){

        @Override
        @Nonnull
        public ITheme getTheme(@Nonnull DomApplication da, @Nonnull String themeName) throws Exception {
            FragmentedThemeFactory stf = new FragmentedThemeFactory(da, themeName);
            return stf.createTheme();
        }
    };
    private final DomApplication m_application;
    private final String m_themeName;
    @Nullable
    private String m_stylesheet;
    private final List<String> m_searchList = new ArrayList<String>();
    @Nullable
    private RhinoExecutor m_executor;
    private List<String> m_inheritanceStack = new ArrayList<String>();
    private ResourceDependencyList m_rdl = new ResourceDependencyList();

    public static IThemeFactory getInstance() {
        return INSTANCE;
    }

    protected FragmentedThemeFactory(DomApplication da, String themeName) {
        this.m_application = da;
        this.m_themeName = themeName;
    }

    @Nonnull
    protected RhinoExecutor executor() throws Exception {
        RhinoExecutor executor = this.m_executor;
        if (null == executor) {
            executor = this.m_executor = RhinoExecutorFactory.getInstance().createExecutor();
            executor.eval((Class)Object.class, "icon = new Object();", "internal");
            executor.put("themeName", this.m_themeName);
            executor.put("themePath", "$THEME/" + this.m_themeName + "/");
            this.m_application.augmentThemeMap(executor);
        }
        return executor;
    }

    protected ITheme createTheme() throws Exception {
        this.loadStyleInfo();
        ResourceDependencies rd = this.m_rdl.createDependencies();
        this.m_searchList.add("$themes/css-all");
        return new FragmentedThemeStore(this.m_application, DomUtil.nullChecked(this.m_stylesheet).getBytes("utf-8"), this.executor(), this.m_searchList, rd);
    }

    protected void loadStyleInfo() throws Exception {
        String[] ar = this.m_themeName.split("/");
        if (ar.length != 4) {
            throw new StyleException("The theme name '" + this.m_themeName + "' is invalid for " + this.getClass() + ": expecting styleName/icon/color/variant");
        }
        String styleName = ar[0];
        String iconName = ar[1];
        String colorName = ar[2];
        String variant = ar[3];
        this.loadColors(colorName);
        this.loadIcons(iconName, variant);
        this.loadStyle(styleName, variant);
    }

    protected void loadStyle(String styleName, String variant) throws Exception {
        if (!variant.equals(DefaultThemeVariant.INSTANCE.getVariantName())) {
            styleName = styleName + "-" + variant;
        }
        this.loadClear();
        this.setInheritence("internalInheritStyle");
        this.internalInheritStyle(styleName);
        StringBuilder sb = new StringBuilder(65536);
        this.executor().put("browser", BrowserVersion.parseUserAgent("Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; .NET CLR 2.0.50727)"));
        this.getFragments(sb, this.m_inheritanceStack, ".frag.css", Check.CHECK, this.m_rdl);
        this.m_stylesheet = sb.toString();
    }

    public void internalInheritStyle(String styleName) throws Exception {
        String dirname = this.normalizeName("themes/css-" + styleName);
        if (this.m_inheritanceStack.contains(dirname)) {
            throw new StyleException(this.m_themeName + ": style set '" + styleName + "' is used before (cyclic loop in styles, or double inheritance)");
        }
        this.m_inheritanceStack.add(0, dirname);
        this.m_searchList.add(0, dirname);
        this.loadScript("$" + dirname + "/style.props.js");
    }

    protected void loadIcons(String iconName, String variant) throws Exception {
        this.loadClear();
        this.setInheritence("internalInheritIcon");
        if (!DefaultThemeVariant.INSTANCE.getVariantName().equals(variant)) {
            String dirname = this.normalizeName("themes/" + iconName + "-icons-" + variant);
            if (this.m_inheritanceStack.contains(dirname)) {
                throw new StyleException(this.m_themeName + ": icon variant set '" + dirname + "' is used before (cyclic loop in styles, or double inheritance)");
            }
            this.m_inheritanceStack.add(0, dirname);
            this.m_searchList.add(0, dirname);
        }
        this.internalInheritIcon(iconName);
        this.loadFragments("iconset:" + iconName, ".props.js", "icon.props.js");
    }

    public void internalInheritIcon(String iconName) throws Exception {
        String dirname = this.normalizeName("themes/" + iconName + "-icons");
        if (this.m_inheritanceStack.contains(dirname)) {
            throw new StyleException(this.m_themeName + ": icon set '" + iconName + "' is used before (cyclic loop in styles, or double inheritance)");
        }
        this.m_inheritanceStack.add(0, dirname);
        this.m_searchList.add(0, dirname);
        this.loadScript("$" + dirname + "/icon.props.js");
    }

    protected void loadColors(String colorName) throws Exception {
        this.loadClear();
        this.setInheritence("internalInheritColor");
        this.internalInheritColor(colorName);
    }

    public void internalInheritColor(String colorName) throws Exception {
        String fullname = this.normalizeName("themes/" + colorName + ".color.js").replace("domui.", "orange.");
        if (this.m_inheritanceStack.contains(fullname)) {
            throw new StyleException(this.m_themeName + ": color set '" + colorName + "' is used before (cyclic loop in styles, or double inheritance)");
        }
        this.m_inheritanceStack.add(0, fullname);
        this.loadScript("$" + fullname);
        this.m_searchList.add(0, this.normalizeName("themes/" + colorName + "-colors"));
    }

    protected ResourceDependencyList getCurrentDependencies() {
        return this.m_rdl;
    }

    protected void loadClear() {
        this.m_inheritanceStack.clear();
    }

    private void setInheritence(String methodname) throws Exception {
        this.executor().put("collector", this);
        this.executor().eval((Class)Object.class, "function inherit(s) { collector." + methodname + "(s); }", "internal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadScript(String pname) throws Exception {
        IResourceRef ires = this.findRef(this.m_rdl, pname);
        if (null == ires) {
            throw new StyleException("The " + pname + " file is not found.");
        }
        InputStream is = ires.getInputStream();
        if (null == is) {
            throw new StyleException("The " + pname + " file is not found.");
        }
        System.out.println("css: loading " + pname + " as " + ires);
        try {
            InputStreamReader r = new InputStreamReader(is, "utf-8");
            this.executor().eval((Class)Object.class, (Reader)r, pname);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    private void loadFragments(String setname, String fragmentSuffix, String ignoreName) throws Exception {
        long ts = System.nanoTime();
        List<String> reslist = this.collectFragments(this.m_inheritanceStack, fragmentSuffix);
        int count = 0;
        for (String name : reslist) {
            if (ignoreName != null && name.endsWith("/" + ignoreName)) continue;
            String full = "$" + name;
            this.loadScript(full);
            ++count;
        }
        ts = System.nanoTime() - ts;
        System.out.println("css: loading " + setname + "+: loaded " + count + " fragments took " + StringTool.strNanoTime((long)ts));
    }

    private String normalizeName(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        return name;
    }

    private void getFragments(StringBuilder target, List<String> directory, String suffix, Check loadType, IResourceDependencyList rdl) throws Exception {
        long ts = System.nanoTime();
        List<String> reslist = this.collectFragments(directory, suffix);
        int count = 0;
        for (String name : reslist) {
            String full = "$" + name;
            this.appendFragment(target, full, loadType, rdl);
            ++count;
        }
        ts = System.nanoTime() - ts;
        System.out.println("css: theme '" + this.m_themeName + "' loading " + directory + "+: loaded " + count + " fragments took " + StringTool.strNanoTime((long)ts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendFragment(StringBuilder target, String fullPathName, Check loadType, IResourceDependencyList rdl) throws Exception {
        IResourceRef ires = this.findRef(rdl, fullPathName);
        if (null == ires) {
            throw new StyleException("The " + fullPathName + " file/resource is not found.");
        }
        InputStream is = ires.getInputStream();
        if (null == is) {
            throw new StyleException("The " + fullPathName + " file/resource is not found.");
        }
        String source = FileTool.readStreamAsString((InputStream)is, (String)"utf-8");
        RhinoTemplateCompiler rtc = new RhinoTemplateCompiler();
        RhinoTemplate tmpl = rtc.compile(new StringReader(source), fullPathName);
        switch (loadType) {
            default: {
                throw new IllegalStateException("Bad?");
            }
            case NONE: {
                target.append(source);
                return;
            }
            case CHECK: 
        }
        target.append(source);
        tmpl.execute((Appendable)new StringBuilder(), this.executor().newScope());
        return;
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    protected IResourceRef findRef(@Nonnull IResourceDependencyList rdl, @Nonnull String rurl) throws Exception {
        try {
            IResourceRef ires = this.m_application.getResource(rurl, rdl);
            return ires;
        }
        catch (ThingyNotFoundException thingyNotFoundException) {
            return null;
        }
    }

    public List<String> collectFragments(List<String> directoryStack, String suffix) throws Exception {
        if (!suffix.startsWith(".")) {
            suffix = "." + suffix;
        }
        suffix = suffix.toLowerCase();
        Map<String, String> frags = this.collectFragments(directoryStack);
        ArrayList<String> names = new ArrayList<String>(frags.keySet());
        Collections.sort(names);
        ArrayList<String> res = new ArrayList<String>(names.size());
        for (String name : names) {
            if (!name.toLowerCase().endsWith(suffix)) continue;
            String map = frags.get(name);
            String full = map + "/" + name;
            res.add(full);
        }
        return res;
    }

    private Map<String, String> collectFragments(List<String> directoryStack) throws Exception {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String inh : directoryStack) {
            this.collectFragments(res, inh);
        }
        return res;
    }

    private void collectFragments(Map<String, String> nameSet, String inh) {
        String pkgres = "resources/" + inh;
        List<String> kns = ClasspathInventory.getInstance().getPackageInventory(pkgres);
        for (String s : kns) {
            nameSet.put(s, inh);
        }
        File wad = this.m_application.getAppFile(inh);
        if (wad != null && wad.isDirectory()) {
            for (File far : wad.listFiles()) {
                if (!far.isFile()) continue;
                nameSet.put(far.getName(), inh);
            }
        }
    }

    protected String getThemeName() {
        return this.m_themeName;
    }

    protected DomApplication getApplication() {
        return this.m_application;
    }

    @Nullable
    protected String getStylesheet() {
        return DomUtil.nullChecked(this.m_stylesheet);
    }

    protected List<String> getSearchList() {
        return this.m_searchList;
    }

    private static enum Check {
        NONE,
        CHECK;

    }
}

