/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.themes;

import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.server.DomApplication;
import to.etc.domui.themes.ITheme;
import to.etc.domui.themes.StyleException;
import to.etc.domui.util.js.IScriptScope;
import to.etc.domui.util.resources.ByteArrayResourceRef;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.domui.util.resources.ResourceDependencies;

public class FragmentedThemeStore
implements ITheme {
    private final DomApplication m_app;
    private final byte[] m_styleSheetBytes;
    private final List<String> m_themeInheritanceStack;
    private final ResourceDependencies m_dependencies;
    private final IScriptScope m_propertyScope;

    public FragmentedThemeStore(DomApplication app, byte[] tbytes, IScriptScope themeProperties, List<String> themeInheritanceStack, ResourceDependencies deps) {
        this.m_app = app;
        this.m_propertyScope = themeProperties;
        this.m_themeInheritanceStack = themeInheritanceStack;
        this.m_dependencies = deps;
        this.m_styleSheetBytes = tbytes;
    }

    private byte[] getStyleSheetBytes() {
        return this.m_styleSheetBytes;
    }

    @Override
    @Nonnull
    public ResourceDependencies getDependencies() {
        return this.m_dependencies;
    }

    @Override
    @Nonnull
    public IScriptScope getPropertyScope() {
        return this.m_propertyScope;
    }

    @Override
    @Nonnull
    public String translateResourceName(@Nonnull String name) {
        try {
            IScriptScope ss = this.getPropertyScope().getValue(IScriptScope.class, "icon");
            if (null == ss) {
                return name;
            }
            String val = ss.getValue(String.class, name);
            return val == null ? name : val;
        }
        catch (Exception x) {
            throw new StyleException("The 'icon' mapping for '" + name + "' results in an exception: " + name);
        }
    }

    @Override
    @Nonnull
    public IResourceRef getThemeResource(@Nonnull String name, @Nonnull IResourceDependencyList rdl) throws Exception {
        if ("style.theme.css".equals(name)) {
            byte[] data = this.getStyleSheetBytes();
            return new ByteArrayResourceRef(data, "style.theme.css", this.getDependencies());
        }
        int i = this.m_themeInheritanceStack.size();
        while (--i >= 0) {
            String sitem = this.m_themeInheritanceStack.get(i);
            String real = "$" + sitem + "/" + name;
            IResourceRef rr = this.m_app.getResource(real, rdl);
            if (rr == null || !rr.exists()) continue;
            return rr;
        }
        return new IResourceRef(){

            @Override
            public InputStream getInputStream() throws Exception {
                return null;
            }

            @Override
            public boolean exists() {
                return false;
            }
        };
    }
}

