/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.themes;

import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import to.etc.domui.server.DomApplication;
import to.etc.domui.themes.ITheme;
import to.etc.domui.themes.StyleException;
import to.etc.domui.util.js.IScriptScope;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.domui.util.resources.ResourceDependencies;

@Immutable
public final class SimpleTheme
implements ITheme {
    @Nonnull
    private final DomApplication m_da;
    @Nonnull
    private final String m_styleName;
    @Nonnull
    private final ResourceDependencies m_rd;
    @Nonnull
    private final IScriptScope m_propertyScope;
    @Nonnull
    private final List<String> m_searchpath;

    public SimpleTheme(@Nonnull DomApplication da, @Nonnull String styleName, @Nonnull IScriptScope themeProperties, @Nonnull ResourceDependencies rd, @Nonnull List<String> searchpath) {
        this.m_da = da;
        this.m_styleName = styleName;
        this.m_propertyScope = themeProperties;
        this.m_rd = rd;
        this.m_searchpath = searchpath;
    }

    @Override
    @Nonnull
    public ResourceDependencies getDependencies() {
        return this.m_rd;
    }

    @Override
    @Nonnull
    public IScriptScope getPropertyScope() {
        return this.m_propertyScope;
    }

    @Override
    @Nonnull
    public IResourceRef getThemeResource(@Nonnull String name, @Nonnull IResourceDependencyList rdl) throws Exception {
        for (String sitem : this.m_searchpath) {
            String real = sitem + "/" + name;
            IResourceRef rr = this.m_da.getResource(real, rdl);
            if (rr == null || !rr.exists()) continue;
            return rr;
        }
        return new IResourceRef(){

            @Override
            public InputStream getInputStream() throws Exception {
                return null;
            }

            @Override
            public boolean exists() {
                return false;
            }
        };
    }

    @Override
    @Nonnull
    public String translateResourceName(@Nonnull String name) {
        try {
            IScriptScope ss = this.getPropertyScope().getValue(IScriptScope.class, "icon");
            if (null == ss) {
                return name;
            }
            String val = ss.getValue(String.class, name);
            return val == null ? name : val;
        }
        catch (Exception x) {
            throw new StyleException("The 'icon' mapping for '" + name + "' results in an exception: " + name);
        }
    }
}

