/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.themes;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import to.etc.domui.server.DomApplication;
import to.etc.domui.themes.ITheme;
import to.etc.domui.themes.IThemeFactory;
import to.etc.domui.themes.SimpleTheme;
import to.etc.domui.themes.StyleException;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.util.js.RhinoExecutor;
import to.etc.domui.util.js.RhinoExecutorFactory;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.domui.util.resources.ResourceDependencyList;

public class SimpleThemeFactory
implements IThemeFactory {
    public static final SimpleThemeFactory INSTANCE = new SimpleThemeFactory();
    private DomApplication m_application;
    private String m_themeName;
    private String m_styleName;
    private String m_iconName;
    private String m_colorName;
    private RhinoExecutor m_executor;
    private String m_variantName;

    private SimpleThemeFactory() {
    }

    private SimpleThemeFactory(DomApplication da, String themeName) {
        this.m_application = da;
        this.m_themeName = themeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ITheme getTheme(@Nonnull DomApplication da, @Nonnull String themeName) throws Exception {
        SimpleThemeFactory stf = new SimpleThemeFactory(da, themeName);
        try {
            SimpleTheme simpleTheme = stf.createTheme();
            return simpleTheme;
        }
        finally {
            try {
                stf.close();
            }
            catch (Exception exception) {}
        }
    }

    private RhinoExecutor executor() throws Exception {
        if (this.m_executor == null) {
            this.m_executor = RhinoExecutorFactory.getInstance().createExecutor();
            this.m_executor.eval((Class)Object.class, "icon = new Object();", "internal");
            this.m_executor.put("themeName", this.m_themeName);
            this.m_executor.put("themePath", "$THEME/" + this.m_themeName + "/");
            this.m_application.augmentThemeMap(this.m_executor);
        }
        return this.m_executor;
    }

    private SimpleTheme createTheme() throws Exception {
        String[] ar = this.m_themeName.split("\\/");
        if (ar.length != 4) {
            throw new StyleException("The theme name '" + this.m_themeName + "' is invalid for the factory SimpleThemeFactory: expecting theme/icon/color");
        }
        this.m_styleName = ar[0];
        this.m_iconName = ar[1];
        this.m_colorName = ar[2];
        this.m_variantName = ar[3];
        ResourceDependencyList rdl = new ResourceDependencyList();
        this.executor().eval((Class)Object.class, "icon = new Object();", "internal");
        this.loadProperties("$themes/" + this.m_colorName + ".color.js", rdl);
        this.loadProperties("$themes/" + this.m_iconName + ".icons.js", rdl);
        this.loadProperties("$themes/css-" + this.m_styleName + "/style.props.js", rdl);
        ArrayList<String> searchpath = new ArrayList<String>(3);
        searchpath.add("$themes/" + this.m_iconName + "-icons");
        searchpath.add("$themes/" + this.m_colorName + "-colors");
        searchpath.add("$themes/css-" + this.m_styleName);
        searchpath.add("$themes/all");
        return new SimpleTheme(this.m_application, this.m_styleName, this.executor(), rdl.createDependencies(), searchpath);
    }

    private void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(String rurl, ResourceDependencyList rdl) throws Exception {
        IResourceRef ires = SimpleThemeFactory.findRef(this.m_application, rurl, rdl);
        if (null == ires || !ires.exists()) {
            return;
        }
        InputStream is = ires.getInputStream();
        try {
            InputStreamReader isr = new InputStreamReader(is, "utf-8");
            this.executor().eval((Class)Object.class, (Reader)isr, rurl);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected static IResourceRef findRef(@Nonnull DomApplication da, @Nonnull String rurl, @Nonnull IResourceDependencyList rdl) throws Exception {
        try {
            IResourceRef ires = da.getResource(rurl, rdl);
            return ires;
        }
        catch (ThingyNotFoundException thingyNotFoundException) {
            return null;
        }
    }
}

