/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.themes;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.server.BrowserVersion;
import to.etc.domui.server.DomApplication;
import to.etc.domui.themes.ITheme;
import to.etc.domui.themes.IThemeFactory;
import to.etc.domui.themes.IThemeVariant;
import to.etc.domui.themes.ThemeModifyableResource;
import to.etc.domui.themes.ThemeResourceFactory;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.util.js.IScriptScope;
import to.etc.domui.util.js.RhinoTemplateCompiler;
import to.etc.domui.util.resources.IIsModified;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.domui.util.resources.ResourceDependencies;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;

public final class ThemeManager {
    private final DomApplication m_application;
    private IThemeFactory m_themeFactory;
    private String m_currentTheme = "domui";
    private final Map<String, ThemeRef> m_themeMap = new HashMap<String, ThemeRef>();
    private static final long OLD_THEME_TIME = 300000L;
    private int m_themeReapCount;
    private long m_themeNextReapTS;

    public ThemeManager(DomApplication application) {
        this.m_application = application;
    }

    public synchronized void setCurrentTheme(@Nonnull String currentTheme) {
        if (null == currentTheme) {
            throw new IllegalArgumentException("This cannot be null");
        }
        this.m_currentTheme = currentTheme;
    }

    @Nonnull
    public synchronized String getCurrentTheme() {
        return this.m_currentTheme;
    }

    @Nonnull
    public synchronized IThemeFactory getThemeFactory() {
        if (this.m_themeFactory == null) {
            throw new IllegalStateException("Theme factory cannot be null");
        }
        return this.m_themeFactory;
    }

    public synchronized void setThemeFactory(@Nonnull IThemeFactory themer) {
        if (themer == null) {
            throw new IllegalStateException("Theme factory cannot be null");
        }
        this.m_themeFactory = themer;
        this.m_themeMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ITheme getTheme(String themeName, @Nullable IResourceDependencyList rdl) {
        ThemeManager themeManager = this;
        synchronized (themeManager) {
            ITheme theme;
            ThemeRef tr;
            if (this.m_themeReapCount++ > 1000) {
                this.m_themeReapCount = 0;
                this.checkReapThemes();
            }
            if (!((tr = this.m_themeMap.get(themeName)) == null || tr.getDependencies() != null && tr.getDependencies().isModified())) {
                if (rdl != null && tr.getDependencies() != null) {
                    rdl.add(tr.getDependencies());
                }
                tr.setLastuse(System.currentTimeMillis());
                return tr.getTheme();
            }
            try {
                theme = this.getThemeFactory().getTheme(this.m_application, themeName);
            }
            catch (Exception x) {
                throw WrappedException.wrap((Exception)x);
            }
            if (null == theme) {
                throw new IllegalStateException("Theme factory returned null!?");
            }
            ResourceDependencies deps = null;
            if (this.m_application.inDevelopmentMode()) {
                ThemeModifyableResource tmr = new ThemeModifyableResource(theme.getDependencies(), 3000);
                deps = new ResourceDependencies(new IIsModified[]{tmr});
            }
            tr = new ThemeRef(theme, deps);
            if (rdl != null && deps != null) {
                rdl.add(deps);
            }
            this.m_themeMap.put(themeName, tr);
            return theme;
        }
    }

    private synchronized void checkReapThemes() {
        long ts = System.currentTimeMillis();
        if (ts < this.m_themeNextReapTS) {
            return;
        }
        ArrayList<ThemeRef> list = new ArrayList<ThemeRef>(this.m_themeMap.values());
        Collections.sort(list, new Comparator<ThemeRef>(){

            @Override
            public int compare(ThemeRef a, ThemeRef b) {
                long d = a.getLastuse() - b.getLastuse();
                return d == 0L ? 0 : (d > 0L ? 1 : -1);
            }
        });
        long abstime = ts - 300000L;
        int i = list.size() - 1;
        while (--i >= 0) {
            ThemeRef tr = (ThemeRef)list.get(i);
            if (tr.getLastuse() >= abstime) continue;
            list.remove(i);
        }
        this.m_themeNextReapTS = ts + 300000L;
    }

    public String getThemeReplacedString(@Nonnull IResourceDependencyList rdl, String rurl) throws Exception {
        return this.getThemeReplacedString(rdl, rurl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getThemeReplacedString(@Nonnull IResourceDependencyList rdl, @Nonnull String rurl, @Nullable BrowserVersion bv) throws Exception {
        long ts = System.nanoTime();
        IResourceRef ires = this.m_application.getResource(rurl, rdl);
        if (!ires.exists()) {
            System.out.println(">>>> RESOURCE ERROR: " + rurl + ", ref=" + ires);
            throw new ThingyNotFoundException("Unexpected: cannot get input stream for IResourceRef rurl=" + rurl + ", ref=" + ires);
        }
        String[] spl = ThemeResourceFactory.splitThemeURL(rurl);
        ITheme theme = this.getTheme(spl[0], null);
        IScriptScope ss = theme.getPropertyScope();
        ss = ss.newScope();
        if (bv != null) {
            ss.put("browser", bv);
        }
        this.m_application.augmentThemeMap(ss);
        InputStream is = ires.getInputStream();
        if (is == null) {
            System.out.println(">>>> RESOURCE ERROR: " + rurl + ", ref=" + ires);
            throw new ThingyNotFoundException("Unexpected: cannot get input stream for IResourceRef rurl=" + rurl + ", ref=" + ires);
        }
        try {
            InputStreamReader r = new InputStreamReader(is, "utf-8");
            StringBuilder sb = new StringBuilder(65536);
            RhinoTemplateCompiler rtc = new RhinoTemplateCompiler();
            rtc.execute((Appendable)sb, (Reader)r, rurl, ss);
            ts = System.nanoTime() - ts;
            if (bv != null) {
                System.out.println("theme-replace: " + rurl + " for " + bv.getBrowserName() + ":" + bv.getMajorVersion() + " took " + StringTool.strNanoTime((long)ts));
            } else {
                System.out.println("theme-replace: " + rurl + " for all browsers took " + StringTool.strNanoTime((long)ts));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public IScriptScope getThemeMap(String themeName, IResourceDependencyList rdlin) throws Exception {
        ITheme ts = this.getTheme(themeName, rdlin);
        return ts.getPropertyScope();
    }

    @Nonnull
    public String getThemedResourceRURL(@Nonnull IThemeVariant themeStyle, @Nonnull String path) {
        if (!path.startsWith("THEME/")) {
            if (path.startsWith("ICON/")) {
                throw new IllegalStateException("Bad ROOT: ICON/. Use THEME/ instead.");
            }
            return path;
        }
        path = path.substring(6);
        if (path == null) {
            throw new NullPointerException();
        }
        ITheme theme = this.getTheme(this.getCurrentTheme() + "/" + themeStyle.getVariantName(), null);
        String newicon = theme.translateResourceName(path);
        return "$THEME/" + this.getCurrentTheme() + "/" + themeStyle.getVariantName() + "/" + newicon;
    }

    private static class ThemeRef {
        private final ITheme m_theme;
        private long m_lastuse;
        private final IIsModified m_rdl;

        public ThemeRef(ITheme theme, IIsModified rdl) {
            this.m_theme = theme;
            this.m_rdl = rdl;
        }

        public ITheme getTheme() {
            return this.m_theme;
        }

        public long getLastuse() {
            return this.m_lastuse;
        }

        public void setLastuse(long lastuse) {
            this.m_lastuse = lastuse;
        }

        public IIsModified getDependencies() {
            return this.m_rdl;
        }
    }
}

