/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.themes;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.server.BrowserVersion;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IExtendedParameterInfo;
import to.etc.domui.server.parts.IBufferedPartFactory;
import to.etc.domui.server.parts.IUrlPart;
import to.etc.domui.server.parts.PartResponse;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.util.FileTool;
import to.etc.webapp.core.ServerTools;

@DefaultNonNull
public final class ThemePartFactory
implements IBufferedPartFactory,
IUrlPart {
    @Override
    public boolean accepts(@Nonnull String rurl) {
        int dot1 = rurl.lastIndexOf(46);
        if (dot1 == -1) {
            return false;
        }
        int dot2 = rurl.lastIndexOf(46, dot1 - 1);
        if (dot2 == -1) {
            return false;
        }
        return rurl.substring(dot2 + 1, dot1).equals("theme");
    }

    @Override
    @Nonnull
    public Object decodeKey(@Nonnull String rurl, @Nonnull IExtendedParameterInfo param) throws Exception {
        String iv = param.getParameter("iv");
        int val = 0;
        if (null != iv) {
            val = Integer.parseInt(iv);
        }
        return new Key(param.getBrowserVersion(), rurl, val);
    }

    @Override
    public void generate(@Nonnull PartResponse pr, @Nonnull DomApplication da, @Nonnull Object k, @Nonnull IResourceDependencyList rdl) throws Exception {
        Key key = (Key)k;
        if (!da.inDevelopmentMode()) {
            pr.setCacheTime(da.getDefaultExpiryTime());
        }
        String content = da.getThemeReplacedString(rdl, key.getRurl(), key.getBrowserVersion());
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(pr.getOutputStream()));
        pw.append(content);
        pw.close();
        pr.setMime(ServerTools.getExtMimeType((String)FileTool.getFileExtension((String)key.getRurl())));
    }

    private static final class Key {
        private String m_rurl;
        private String m_browserID;
        private BrowserVersion m_bv;
        private int m_iv;

        public Key(BrowserVersion bv, String rurl, int iv) {
            this.m_bv = bv;
            this.m_browserID = bv.getBrowserName() + "/" + bv.getMajorVersion();
            this.m_rurl = rurl;
            this.m_iv = iv;
        }

        public String toString() {
            return "[themed:" + this.m_rurl + ", browser=" + this.m_bv + "]";
        }

        public BrowserVersion getBrowserVersion() {
            return this.m_bv;
        }

        public String getRurl() {
            return this.m_rurl;
        }

        public int getIv() {
            return this.m_iv;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_browserID == null ? 0 : this.m_browserID.hashCode());
            result = 31 * result + (this.m_rurl == null ? 0 : this.m_rurl.hashCode());
            result = 31 * result + this.m_iv;
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.m_browserID == null ? other.m_browserID != null : !this.m_browserID.equals(other.m_browserID)) {
                return false;
            }
            if (this.m_rurl == null) {
                if (other.m_rurl != null) {
                    return false;
                }
            } else {
                if (!this.m_rurl.equals(other.m_rurl)) {
                    return false;
                }
                if (this.m_iv != other.m_iv) {
                    return false;
                }
            }
            return true;
        }
    }
}

