/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.themes;

import javax.annotation.Nonnull;
import to.etc.domui.server.DomApplication;
import to.etc.domui.themes.ITheme;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceFactory;
import to.etc.domui.util.resources.IResourceRef;

public final class ThemeResourceFactory
implements IResourceFactory {
    public static final String PREFIX = "$THEME/";

    @Override
    public int accept(@Nonnull String name) {
        return name.startsWith(PREFIX) ? 30 : -1;
    }

    public static final String[] splitThemeURL(String name) {
        if (!name.startsWith(PREFIX)) {
            throw new IllegalArgumentException("Not a theme RURL: '" + name + "'");
        }
        String real = name.substring(PREFIX.length());
        int pos = real.lastIndexOf(47);
        if (pos == -1) {
            throw new ThingyNotFoundException("Bad theme URL (missing current theme): " + name);
        }
        String themename = real.substring(0, pos);
        String filename = real.substring(pos + 1);
        if (themename.length() == 0) {
            throw new ThingyNotFoundException("Bad theme URL (empty current theme): " + name);
        }
        return new String[]{themename, filename};
    }

    @Override
    @Nonnull
    public IResourceRef getResource(@Nonnull DomApplication da, @Nonnull String name, @Nonnull IResourceDependencyList rdl) throws Exception {
        String[] spl = ThemeResourceFactory.splitThemeURL(name);
        String themename = spl[0];
        String filename = spl[1];
        ITheme theme = da.getTheme(themename, rdl);
        if (null == theme) {
            throw new IllegalStateException("Unexpected null from theme factory");
        }
        IResourceRef rr = theme.getThemeResource(filename, rdl);
        if (null == rr || !rr.exists()) {
            throw new ThingyNotFoundException("The theme resource '" + name + "' cannot be found");
        }
        return rr;
    }
}

