/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.trouble;

import to.etc.domui.dom.html.Page;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.util.DomUtil;
import to.etc.util.StringTool;

public class NotLoggedInException
extends RuntimeException {
    private final String m_url;

    public NotLoggedInException(String url) {
        super("You need to be logged in");
        this.m_url = url;
    }

    public String getURL() {
        return this.m_url;
    }

    public static NotLoggedInException create(IRequestContext ctx, Page page) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(ctx.getRelativePath(ctx.getInputPath()));
        sb.append('?');
        StringTool.encodeURLEncoded((Appendable)sb, (String)"$cid");
        sb.append('=');
        sb.append(ctx.getWindowSession().getWindowID());
        if (page != null) {
            sb.append('.').append(page.getConversation().getId());
        } else {
            sb.append(".x");
        }
        DomUtil.addUrlParameters(sb, ctx, false);
        return new NotLoggedInException(sb.toString());
    }
}

