/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.delayed.AsyncContainer;
import to.etc.domui.component.delayed.IAsyncRunnable;
import to.etc.domui.component.delayed.IProgress;
import to.etc.domui.component.layout.Dialog;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.logic.ILogicContext;
import to.etc.domui.logic.LogicContextImpl;
import to.etc.domui.util.Msgs;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.webapp.nls.CodeException;
import to.etc.webapp.query.QContextManager;
import to.etc.webapp.query.QDataContext;

public abstract class AsyncDialogTask
implements IAsyncRunnable {
    @Nullable
    private QDataContext m_dc;
    @Nullable
    private LogicContextImpl m_lc;
    private boolean m_done;
    private boolean m_defaultOnCompleted;

    protected abstract void execute(@Nonnull IProgress var1) throws Exception;

    @Override
    public void run(@Nonnull IProgress p) throws Exception {
        try {
            this.execute(p);
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{this.m_dc});
            this.m_dc = null;
            this.m_lc = null;
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{this.m_dc});
        this.m_dc = null;
        this.m_lc = null;
    }

    private synchronized boolean isDone() {
        return this.m_done;
    }

    private synchronized void done() {
        this.m_done = true;
    }

    @Nonnull
    protected QDataContext dc() throws Exception {
        QDataContext dc = this.m_dc;
        if (null == dc) {
            if (this.isDone()) {
                throw new IllegalStateException("You cannot use the task context after completion. Use the page's instead");
            }
            dc = this.m_dc = QContextManager.createUnmanagedContext();
        }
        return dc;
    }

    @Nonnull
    protected ILogicContext lc() throws Exception {
        LogicContextImpl lc = this.m_lc;
        if (null == lc) {
            lc = this.m_lc = new LogicContextImpl(this.dc());
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted(boolean cancelled, @Nullable Exception errorException) throws Exception {
        AsyncDialogTask asyncDialogTask = this;
        synchronized (asyncDialogTask) {
            this.m_defaultOnCompleted = true;
        }
    }

    private synchronized boolean isDefault() {
        return this.m_defaultOnCompleted;
    }

    public static void runInDialog(@Nonnull NodeContainer addTo, final @Nonnull AsyncDialogTask task, @Nonnull String dialogTitle, boolean isAbortable, final boolean autoClose) {
        final Dialog dlg = new Dialog(true, false, dialogTitle);
        addTo.add(dlg);
        dlg.setAutoClose(false);
        AsyncContainer pd = new AsyncContainer(new IAsyncRunnable(){

            @Override
            public void run(@Nonnull IProgress p) throws Exception {
                task.run(p);
            }

            @Override
            public void onCompleted(boolean cancelled, @Nullable Exception errorException) throws Exception {
                task.onCompleted(cancelled, errorException);
                boolean haserror = false;
                if (task.isDefault() && errorException != null) {
                    haserror = true;
                    if (errorException instanceof CodeException) {
                        CodeException cx = (CodeException)((Object)errorException);
                        String msg = cx.getMessage();
                        dlg.add(msg);
                    } else {
                        String msg = errorException.getMessage();
                        if (StringTool.isBlank((String)msg)) {
                            msg = errorException.toString();
                        }
                        dlg.add(msg);
                    }
                }
                if (!haserror) {
                    if (autoClose) {
                        dlg.close();
                    } else {
                        dlg.add(Msgs.BUNDLE.getString("async.dialog.completed"));
                    }
                }
            }
        });
        if (!isAbortable) {
            pd.setAbortable(false);
        }
        dlg.add(pd);
    }
}

