/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.impl.ExpandedDisplayProperty;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.util.INodeContentRenderer;

public class DisplayPropertyNodeContentRenderer
implements INodeContentRenderer<Object> {
    private List<ExpandedDisplayProperty<?>> m_list;
    private List<ExpandedDisplayProperty<?>> m_flat;

    public DisplayPropertyNodeContentRenderer(ClassMetaModel cmm, List<ExpandedDisplayProperty<?>> list) {
        this.m_list = list;
    }

    private void prepare() {
        if (this.m_flat != null) {
            return;
        }
        this.m_flat = ExpandedDisplayProperty.flatten(this.m_list);
    }

    @Override
    public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable Object object, @Nullable Object parameters) throws Exception {
        this.prepare();
        StringBuilder sb = new StringBuilder();
        for (ExpandedDisplayProperty<?> xdp : this.m_flat) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            String s = xdp.getPresentationString(object);
            sb.append(s);
        }
        node.add(sb.toString());
    }
}

