/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util;

import javax.annotation.Nonnull;
import to.etc.domui.component.misc.ALink;
import to.etc.domui.dom.html.BR;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.DomApplication;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.UIContext;
import to.etc.domui.util.DomUtil;
import to.etc.util.WrappedException;
import to.etc.webapp.mailer.ITextLinkRenderer;
import to.etc.webapp.mailer.TextLinkInfo;
import to.etc.webapp.query.IIdentifyable;

public final class DomUILinkedTextRenderer
implements ITextLinkRenderer {
    private NodeContainer m_c;

    public void setContainer(@Nonnull NodeContainer c) {
        this.m_c = c;
    }

    public void appendLink(@Nonnull String rurl, @Nonnull String text) {
        ALink link;
        String query;
        String page;
        int pos = rurl.indexOf(63);
        if (pos == -1) {
            page = rurl;
            query = null;
        } else {
            page = rurl.substring(0, pos);
            query = rurl.substring(pos);
        }
        String ext = DomApplication.get().getUrlExtension();
        if (!page.endsWith("." + ext)) {
            rurl = UIContext.getRequestContext().getRelativePath(rurl);
            link = new ALink(rurl, null, null);
        } else {
            Class<?> clz;
            page = page.substring(0, page.length() - ext.length() - 1);
            try {
                clz = this.m_c.getClass().getClassLoader().loadClass(page);
            }
            catch (Exception x) {
                throw WrappedException.wrap((Exception)x);
            }
            if (!UrlPage.class.isAssignableFrom(clz)) {
                throw new IllegalStateException("Class " + clz + " is not a DomUI class");
            }
            Class<?> pageClz = clz;
            PageParameters pp = new PageParameters();
            if (null != query) {
                String[] ar;
                for (String param : ar = query.substring(1).split("&")) {
                    String val;
                    String name;
                    pos = param.indexOf(61);
                    if (pos != -1) {
                        name = param.substring(0, pos);
                        val = param.substring(pos + 1);
                    } else {
                        name = param;
                        val = "";
                    }
                    pp.addParameter(name, val);
                }
            }
            link = new ALink(pageClz, pp);
        }
        this.m_c.add(link);
        link.add(text);
    }

    public void appendText(@Nonnull String text) {
        int pos = 0;
        int len = text.length();
        while (pos < len) {
            int nl = text.indexOf("\n", pos);
            if (nl == -1) {
                DomUtil.renderHtmlString(this.m_c, text.substring(pos));
                return;
            }
            if (nl > pos) {
                DomUtil.renderHtmlString(this.m_c, text.substring(pos, nl));
            }
            pos = nl + 1;
            this.m_c.add(new BR());
        }
    }

    public static void register(@Nonnull Class<? extends IIdentifyable<?>> dataClass, @Nonnull Class<? extends UrlPage> page, String paramName) {
        TextLinkInfo.register(dataClass, (String)(DomUtil.createPageRURL(page, null) + "?" + paramName + "={id}"));
    }

    public static void register(@Nonnull String linkName, @Nonnull Class<? extends UrlPage> page, @Nonnull String paramName) {
        TextLinkInfo.register((String)linkName, (String)(DomUtil.createPageRURL(page, null) + "?" + paramName + "={id}"));
    }
}

