/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.annotations.UIMenu;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.misc.WindowParameters;
import to.etc.domui.dom.errors.IErrorFence;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.BR;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IHasModifiedIndication;
import to.etc.domui.dom.html.IUserInputModifiedFence;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.Span;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.THead;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.WrappedHttpServetResponse;
import to.etc.domui.state.AppSession;
import to.etc.domui.state.IPageParameters;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.UIContext;
import to.etc.domui.state.WindowSession;
import to.etc.domui.trouble.Trouble;
import to.etc.domui.trouble.UIException;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.HtmlTextScanner;
import to.etc.domui.util.IExecute;
import to.etc.domui.util.Msgs;
import to.etc.util.ByteArrayUtil;
import to.etc.util.ExceptionClassifier;
import to.etc.util.FileTool;
import to.etc.util.HtmlScanner;
import to.etc.util.StringTool;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.nls.BundleRef;
import to.etc.webapp.nls.NlsContext;
import to.etc.webapp.query.IIdentifyable;

public final class DomUtil {
    public static final Logger USERLOG = LoggerFactory.getLogger((String)"to.etc.domui.userAction");
    public static final String DOCROOT = "https://etc.to/confluence/";
    private static int m_guidSeed;
    private static final char[] BASE64MAP;
    private static String m_lorem;

    private DomUtil() {
    }

    @Nonnull
    public static <T> T nullChecked(@Nullable T in) {
        if (null == in) {
            throw new IllegalStateException("Unexpected thingy is null: " + in);
        }
        return in;
    }

    @Deprecated
    @Nonnull
    public static <T> T badCheck(T in) {
        return in;
    }

    public static final void setPageCompatibility(@Nonnull HttpServletResponse req, @Nullable String comp) throws IOException {
        if (!(req instanceof WrappedHttpServetResponse)) {
            return;
        }
        WrappedHttpServetResponse wsr = (WrappedHttpServetResponse)req;
        wsr.setIeEmulationMode(comp);
    }

    @Deprecated
    public static final void ie8Capable(HttpServletResponse req) throws IOException {
    }

    public static final boolean isEqualOLD(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static final boolean isEqual(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Date && b instanceof Date) {
            return ((Date)a).compareTo((Date)b) == 0;
        }
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            return ((BigDecimal)a).compareTo((BigDecimal)b) == 0;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        if (a.getClass().isArray() && b.getClass().isArray()) {
            return Arrays.equals((Object[])a, (Object[])b);
        }
        return a.equals(b);
    }

    @Deprecated
    public static final boolean isEqualIgnoreCase(@Nullable String a, @Nullable String b) {
        return StringTool.isEqualIgnoreCase((String)a, (String)b);
    }

    public static final boolean isEqual(Object ... ar) {
        if (ar.length < 2) {
            throw new IllegalStateException("Silly.");
        }
        Object a = ar[0];
        int i = ar.length;
        while (--i >= 1) {
            if (DomUtil.isEqual(a, ar[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> T getValueSafe(IControl<T> node) {
        try {
            return node.getValue();
        }
        catch (ValidationException x) {
            return null;
        }
    }

    public static boolean classResourceExists(Class<?> clz, String name) {
        InputStream is = clz.getResourceAsStream(name);
        if (is == null) {
            return false;
        }
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static final Class<?> findClass(@Nonnull ClassLoader cl, @Nonnull String name) {
        try {
            return cl.loadClass(name);
        }
        catch (Exception x) {
            return null;
        }
    }

    public static boolean isIntegerType(Class<?> clz) {
        return clz == Integer.TYPE || clz == Integer.class || clz == Long.TYPE || clz == Long.class || clz == Short.class || clz == Short.TYPE;
    }

    public static boolean isDoubleOrWrapper(Class<?> clz) {
        return clz == Double.class || clz == Double.TYPE;
    }

    public static boolean isFloatOrWrapper(Class<?> clz) {
        return clz == Float.class || clz == Float.TYPE;
    }

    public static boolean isIntegerOrWrapper(Class<?> clz) {
        return clz == Integer.class || clz == Integer.TYPE;
    }

    public static boolean isShortOrWrapper(Class<?> clz) {
        return clz == Short.class || clz == Short.TYPE;
    }

    public static boolean isByteOrWrapper(Class<?> clz) {
        return clz == Byte.class || clz == Byte.TYPE;
    }

    public static boolean isLongOrWrapper(Class<?> clz) {
        return clz == Long.class || clz == Long.TYPE;
    }

    public static boolean isBooleanOrWrapper(Class<?> clz) {
        return clz == Boolean.class || clz == Boolean.TYPE;
    }

    public static boolean isRealType(Class<?> clz) {
        return clz == Float.TYPE || clz == Float.class || clz == Double.class || clz == Double.TYPE;
    }

    public static boolean isBasicType(Class<?> t) {
        if (t.isPrimitive()) {
            return true;
        }
        return DomUtil.isIntegerOrWrapper(t) || DomUtil.isLongOrWrapper(t) || DomUtil.isShortOrWrapper(t) || DomUtil.isByteOrWrapper(t) || DomUtil.isDoubleOrWrapper(t) || DomUtil.isFloatOrWrapper(t) || DomUtil.isBooleanOrWrapper(t) || t == String.class || t == BigDecimal.class || t == BigInteger.class || t == Date.class || Enum.class.isAssignableFrom(t);
    }

    public static final Object getClassValue(@Nonnull Object inst, @Nonnull String name) throws Exception {
        Method m;
        if (inst == null) {
            throw new IllegalStateException("The input object is null");
        }
        Class<?> clz = inst.getClass();
        try {
            m = clz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException x) {
            throw new IllegalStateException("Unknown method '" + name + "()' on class=" + clz);
        }
        try {
            return m.invoke(inst, new Object[0]);
        }
        catch (IllegalAccessException iax) {
            throw new IllegalStateException("Cannot call method '" + name + "()' on class=" + clz + ": " + iax);
        }
        catch (InvocationTargetException itx) {
            Throwable c = itx.getCause();
            if (c instanceof Exception) {
                throw (Exception)c;
            }
            if (c instanceof Error) {
                throw (Error)c;
            }
            throw itx;
        }
    }

    public static Object getPropertyValue(@Nonnull Object base, @Nonnull String path) {
        int pos = 0;
        int len = path.length();
        Object next = base;
        while (pos < len) {
            String name;
            if (next == null) {
                return null;
            }
            int npos = path.indexOf(46, pos);
            if (npos == -1) {
                name = path.substring(pos);
                pos = len;
            } else {
                name = path.substring(pos, npos);
                pos = npos;
            }
            if (name.length() == 0) {
                throw new IllegalStateException("Invalid property path: " + path);
            }
            next = DomUtil.getSinglePropertyValue(next, name);
            if (pos >= len) continue;
            if (path.charAt(pos) != '.') {
                throw new IllegalStateException("Invalid property path: " + path);
            }
            ++pos;
        }
        return next;
    }

    private static Object getSinglePropertyValue(Object base, String name) {
        try {
            StringBuilder sb = new StringBuilder(name.length() + 3);
            sb.append("get");
            if (Character.isUpperCase(name.charAt(0))) {
                sb.append(name);
            } else {
                sb.append(Character.toUpperCase(name.charAt(0)));
                sb.append(name, 1, name.length());
            }
            Method m = base.getClass().getMethod(sb.toString(), new Class[0]);
            return m.invoke(base, new Object[0]);
        }
        catch (NoSuchMethodException x) {
            throw new IllegalStateException("No property '" + name + "' on class=" + base.getClass());
        }
        catch (Exception x) {
            Trouble.wrapException(x);
            return null;
        }
    }

    public static String createRandomColor() {
        int value = (int)(1.6777215E7 * Math.random());
        return "#" + StringTool.intToStr((int)value, (int)16, (int)6);
    }

    @Nonnull
    public static IErrorFence getMessageFence(@Nonnull NodeBase in) {
        IErrorFence ef;
        NodeContainer nc;
        NodeBase start = in;
        if (in instanceof NodeContainer && (nc = (NodeContainer)in).getDelegate() != null && null != (ef = DomUtil.getMessageFence(nc.getDelegate()))) {
            return ef;
        }
        while (true) {
            IErrorFence errorFence;
            if (start == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Cannot locate error fence. Did you call an error routine on an unattached Node?\nThe path followed upwards was: ");
                start = in;
                while (true) {
                    if (start != in) {
                        sb.append(" -> ");
                    }
                    sb.append(start.toString());
                    if (!start.hasParent()) break;
                    start = start.getParent();
                }
                throw new IllegalStateException(sb.toString());
            }
            if (start instanceof NodeContainer && (errorFence = (nc = (NodeContainer)start).getErrorFence()) != null) {
                return errorFence;
            }
            if (start.hasParent()) {
                start = start.getParent();
                continue;
            }
            start = null;
        }
    }

    @Nonnull
    public static String generateGUID() {
        int sidx;
        byte[] bin = new byte[18];
        ByteArrayUtil.setInt((byte[])bin, (int)0, (int)m_guidSeed);
        ByteArrayUtil.setShort((byte[])bin, (int)4, (short)((short)(Math.random() * 65536.0)));
        long v = System.currentTimeMillis() / 1000L - (long)(m_guidSeed * 60);
        ByteArrayUtil.setInt((byte[])bin, (int)6, (int)((int)v));
        ByteArrayUtil.setLong((byte[])bin, (int)10, (long)System.nanoTime());
        StringBuilder sb = new StringBuilder((bin.length + 2) / 3 * 4);
        for (sidx = 0; sidx < bin.length - 2; sidx += 3) {
            sb.append(BASE64MAP[bin[sidx] >>> 2 & 0x3F]);
            sb.append(BASE64MAP[bin[sidx + 1] >>> 4 & 0xF | bin[sidx] << 4 & 0x3F]);
            sb.append(BASE64MAP[bin[sidx + 2] >>> 6 & 3 | bin[sidx + 1] << 2 & 0x3F]);
            sb.append(BASE64MAP[bin[sidx + 2] & 0x3F]);
        }
        if (sidx < bin.length) {
            sb.append(BASE64MAP[bin[sidx] >>> 2 & 0x3F]);
            if (sidx < bin.length - 1) {
                sb.append(BASE64MAP[bin[sidx + 1] >>> 4 & 0xF | bin[sidx] << 4 & 0x3F]);
                sb.append(BASE64MAP[bin[sidx + 1] << 2 & 0x3F]);
            } else {
                sb.append(BASE64MAP[bin[sidx] << 4 & 0x3F]);
            }
        }
        return sb.toString();
    }

    public static void addUrlParameters(StringBuilder sb, IRequestContext ctx, boolean first) {
        for (String name : ctx.getParameterNames()) {
            String[] parameters;
            if (name.equals("$cid") || null == (parameters = ctx.getParameters(name))) continue;
            for (String value : parameters) {
                if (first) {
                    sb.append('?');
                    first = false;
                } else {
                    sb.append('&');
                }
                StringTool.encodeURLEncoded((Appendable)sb, (String)name);
                sb.append('=');
                StringTool.encodeURLEncoded((Appendable)sb, (String)value);
            }
        }
    }

    public static void addUrlParameters(@Nonnull StringBuilder sb, @Nonnull IPageParameters ctx, boolean first) {
        DomUtil.addUrlParameters(sb, ctx, first, Collections.EMPTY_SET);
    }

    public static void addUrlParameters(@Nonnull StringBuilder sb, @Nonnull IPageParameters ctx, boolean first, @Nonnull Set<String> skipset) {
        if (ctx == null) {
            return;
        }
        for (String name : ctx.getParameterNames()) {
            String[] values;
            if (name.equals("$cid") || skipset.contains(name)) continue;
            for (String value : values = ctx.getStringArray(name)) {
                if (first) {
                    sb.append('?');
                    first = false;
                } else {
                    sb.append('&');
                }
                StringTool.encodeURLEncoded((Appendable)sb, (String)name);
                sb.append('=');
                StringTool.encodeURLEncoded((Appendable)sb, (String)value);
            }
        }
    }

    public static String getApplicationURL() {
        return ((RequestContextImpl)UIContext.getRequestContext()).getRequestResponse().getApplicationURL();
    }

    public static String getApplicationContext() {
        return ((RequestContextImpl)UIContext.getRequestContext()).getRequestResponse().getWebappContext();
    }

    public static String getRelativeApplicationResourceURL(String resource) {
        return "/" + DomUtil.getApplicationContext() + "/" + resource;
    }

    public static String createPageURL(Class<? extends UrlPage> clz, IPageParameters pp) {
        StringBuilder sb = new StringBuilder();
        sb.append(UIContext.getRequestContext().getRelativePath(clz.getName()));
        sb.append('.');
        sb.append(DomApplication.get().getUrlExtension());
        if (pp != null) {
            DomUtil.addUrlParameters(sb, pp, true);
        }
        return sb.toString();
    }

    @Nonnull
    public static String createPageRURL(@Nonnull Class<? extends UrlPage> clz, @Nullable IPageParameters pp) {
        StringBuilder sb = new StringBuilder();
        sb.append(clz.getName());
        sb.append('.');
        sb.append(DomApplication.get().getUrlExtension());
        if (pp != null) {
            DomUtil.addUrlParameters(sb, pp, true);
        }
        return sb.toString();
    }

    public static String createPageURL(@Nonnull String webAppUrl, @Nonnull Class<? extends UrlPage> clz, @Nullable IPageParameters pp) {
        StringBuilder sb = new StringBuilder();
        sb.append(webAppUrl);
        sb.append(clz.getName());
        sb.append('.');
        sb.append(DomApplication.get().getUrlExtension());
        if (pp != null) {
            DomUtil.addUrlParameters(sb, pp, true);
        }
        return sb.toString();
    }

    public static String createPageURL(String rurl, IPageParameters pageParameters) {
        StringBuilder sb = new StringBuilder();
        if (DomUtil.isRelativeURL(rurl)) {
            RequestContextImpl ctx = (RequestContextImpl)UIContext.getRequestContext();
            sb.append(ctx.getRelativePath(rurl));
        } else {
            sb.append(rurl);
        }
        if (pageParameters != null) {
            DomUtil.addUrlParameters(sb, pageParameters, true);
        }
        return sb.toString();
    }

    @Nonnull
    public static String getAdjustedPageUrl(@Nonnull Page page, @Nullable IPageParameters pp) {
        PageParameters newpp = DomUtil.mergePageParameters(pp);
        StringBuilder sb = DomUtil.getPageContextURL(page);
        DomUtil.addUrlParameters(sb, newpp, false);
        return sb.toString();
    }

    @Nonnull
    public static String getAdjustedComponentUrl(@Nonnull NodeBase component, @Nonnull String command, @Nullable IPageParameters pp) {
        PageParameters newpp = DomUtil.mergePageParameters(pp);
        newpp.addParameter("webuia", command);
        newpp.addParameter("webuic", component.getActualID());
        StringBuilder sb = DomUtil.getPageContextURL(component.getPage());
        DomUtil.addUrlParameters(sb, newpp, false);
        return sb.toString();
    }

    @Nonnull
    private static PageParameters mergePageParameters(@Nullable IPageParameters pp) {
        PageParameters newpp = PageParameters.createFrom(UIContext.getRequestContext());
        if (null != pp) {
            for (String name : pp.getParameterNames()) {
                String value = pp.getString(name);
                newpp.addParameter(name, value);
            }
        }
        return newpp;
    }

    @Nonnull
    private static StringBuilder getPageContextURL(@Nonnull Page page) {
        StringBuilder sb = new StringBuilder();
        sb.append(UIContext.getRequestContext().getRelativePath(page.getBody().getClass().getName()));
        sb.append(".").append(DomApplication.get().getUrlExtension());
        sb.append("?");
        sb.append("$cid");
        sb.append("=");
        StringTool.encodeURLEncoded((Appendable)sb, (String)page.getConversation().getFullId());
        return sb;
    }

    public static String calculateURL(IRequestContext ci, String rurl) {
        int pos = rurl.indexOf(":/");
        if (pos > 0 && pos < 20) {
            return rurl;
        }
        if (rurl.startsWith("www.")) {
            return "http://" + rurl;
        }
        if (rurl.startsWith("/")) {
            return rurl;
        }
        return ci.getRelativePath(rurl);
    }

    public static void buildTree(NodeBase p) throws Exception {
        p.build();
        if (p instanceof NodeContainer) {
            NodeContainer nc = (NodeContainer)p;
            for (NodeBase c : nc) {
                DomUtil.buildTree(c);
            }
        }
    }

    public static <T extends NodeBase> T findComponentInTree(NodeBase p, Class<T> clz) throws Exception {
        if (clz.isAssignableFrom(p.getClass())) {
            return (T)p;
        }
        p.build();
        if (p instanceof NodeContainer) {
            NodeContainer nc = (NodeContainer)p;
            for (NodeBase c : nc) {
                T res = DomUtil.findComponentInTree(c, clz);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public static String nlsLabel(String label) {
        if (label == null || label.length() == 0) {
            return label;
        }
        if (label.charAt(0) != '~') {
            return label;
        }
        if (label.startsWith("~~")) {
            return label.substring(1);
        }
        return "???" + label.substring(1) + "???";
    }

    public static void adjustTableColspans(Table table) {
        TD td;
        int count;
        TR tr;
        TBody tb;
        int maxcol = 0;
        for (NodeBase b : table) {
            if (!(b instanceof TBody)) continue;
            tb = (TBody)b;
            for (NodeBase b2 : tb) {
                if (!(b2 instanceof TR)) continue;
                tr = (TR)b2;
                count = 0;
                for (NodeBase b3 : tr) {
                    if (!(b3 instanceof TD)) continue;
                    td = (TD)b3;
                    count += td.getColspan() > 0 ? td.getColspan() : 1;
                }
                if (count <= maxcol) continue;
                maxcol = count;
            }
        }
        for (NodeBase b : table) {
            if (!(b instanceof TBody)) continue;
            tb = (TBody)b;
            for (NodeBase b2 : tb) {
                if (!(b2 instanceof TR)) continue;
                tr = (TR)b2;
                count = 0;
                for (NodeBase b3 : tr) {
                    if (!(b3 instanceof TD)) continue;
                    td = (TD)b3;
                    count += td.getColspan() > 0 ? td.getColspan() : 1;
                }
                if (count >= maxcol) continue;
                if (tr.getChildCount() == 0) {
                    System.out.println("?? Silly empty row in table");
                    continue;
                }
                TD td2 = (TD)tr.getChild(tr.getChildCount() - 1);
                td2.setColspan(maxcol - count + 1);
            }
        }
    }

    public static void balanceTable(Table t) {
        ArrayList<List<TD>> matrix = new ArrayList<List<TD>>(40);
        int rowindex = 0;
        boolean maxcols = false;
        for (NodeBase l0 : t) {
            if (l0 instanceof THead || l0 instanceof TBody) {
                for (NodeBase trb : (NodeContainer)l0) {
                    if (!(trb instanceof TR)) {
                        throw new IllegalStateException("Unexpected child of type " + l0 + " in TBody/THead node (expecting TR)");
                    }
                    TR tr = (TR)trb;
                    int minrowspan = 1;
                    List<TD> baserowlist = DomUtil.getTdList(matrix, rowindex);
                    boolean colindex = false;
                    for (NodeBase tdb : tr) {
                        if (!(tdb instanceof TD)) {
                            throw new IllegalStateException("Unexpected child of type " + tr + " in TBody/THead node (expecting TD)");
                        }
                        TD td = (TD)tdb;
                        int colspan = td.getColspan();
                        int rowspan = td.getRowspan();
                        if (colspan < 1) {
                            colspan = 1;
                        }
                        if (rowspan >= 1) continue;
                        rowspan = 1;
                    }
                    rowindex += minrowspan;
                }
                continue;
            }
            throw new IllegalStateException("Unexpected child of type " + l0 + " in TABLE node");
        }
    }

    private static List<TD> getTdList(List<List<TD>> matrix, int row) {
        while (matrix.size() <= row) {
            matrix.add(new ArrayList());
        }
        return matrix.get(row);
    }

    public static void stripHtml(StringBuilder sb, String in) {
        String tag;
        HtmlScanner hs = new HtmlScanner();
        int lpos = 0;
        hs.setDocument(in);
        while ((tag = hs.nextTag()) != null) {
            int len = hs.getPos() - lpos;
            if (len > 0) {
                sb.append(in, lpos, hs.getPos());
            }
            hs.skipTag();
            lpos = hs.getPos();
        }
        if (hs.getPos() < in.length()) {
            sb.append(in, hs.getPos(), in.length());
        }
    }

    public static void dumpException(Exception x) {
        x.printStackTrace();
        Throwable next = null;
        Throwable curr = x;
        while (curr != null) {
            next = curr.getCause();
            if (next == curr) {
                next = null;
            }
            if (curr instanceof SQLException) {
                SQLException sx = (SQLException)curr;
                while (sx.getNextException() != null) {
                    sx = sx.getNextException();
                    System.err.println("SQL NextException: " + sx);
                }
            }
            curr = next;
        }
    }

    public static void dumpExceptionIfSevere(@Nonnull Exception x) {
        if (ExceptionClassifier.getInstance().isSevereException((Throwable)x)) {
            DomUtil.dumpException(x);
        }
    }

    public static void dumpException(@Nonnull StringBuilder sb, Throwable x) {
        StringTool.strStacktrace((Appendable)sb, (Throwable)x);
        Throwable next = null;
        Throwable curr = x;
        while (curr != null) {
            next = curr.getCause();
            if (next == curr) {
                next = null;
            }
            if (curr instanceof SQLException) {
                SQLException sx = (SQLException)curr;
                while (sx.getNextException() != null) {
                    sx = sx.getNextException();
                    sb.append("SQL NextException: " + sx).append("\n");
                }
            }
            curr = next;
        }
    }

    public static void dumpRequest(HttpServletRequest req) {
        System.out.println("---- request parameter dump ----");
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String val = req.getParameter(name);
            System.out.println(name + ": " + val);
        }
        System.out.println("---- end request parameter dump ----");
    }

    public static String getJavaResourceRURL(Class<?> resourceBase, String name) {
        if (name.startsWith("/")) {
            return "$RES/" + name.substring(1);
        }
        String rb = resourceBase.getName();
        int pos = rb.lastIndexOf(46);
        if (pos == -1) {
            throw new IllegalStateException("??");
        }
        return "$RES/" + rb.substring(0, pos + 1).replace('.', '/') + name;
    }

    @Nonnull
    public static String convertToID(@Nonnull String id) {
        StringBuilder sb = new StringBuilder();
        int len = id.length();
        for (int i = 0; i < len; ++i) {
            char c = id.charAt(i);
            if (c == ' ') {
                sb.append('_');
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '-') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasResource(Class<? extends UrlPage> clz, String cn) {
        InputStream is = null;
        try {
            is = clz.getResourceAsStream(cn);
            boolean bl = is != null;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getClassNameOnly(Class<?> clz) {
        String cn = clz.getName();
        return cn.substring(cn.lastIndexOf(46) + 1);
    }

    public static BundleRef findBundle(UIMenu ma, Class<?> clz) {
        if (ma != null && ma.bundleBase() != Object.class) {
            String s = ma.bundleName();
            if (s.length() == 0) {
                s = "messages";
            }
            return BundleRef.create(ma.bundleBase(), (String)s);
        }
        if (clz != null) {
            String s = clz.getName();
            BundleRef br = BundleRef.create(clz, (String)(s = s.substring(s.lastIndexOf(46) + 1)));
            if (br.exists()) {
                return br;
            }
            return BundleRef.create(clz, (String)"messages");
        }
        return null;
    }

    public static BundleRef getClassBundle(Class<?> clz) {
        String s = clz.getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        return BundleRef.create(clz, (String)s);
    }

    public static BundleRef getPackageBundle(Class<?> base) {
        return BundleRef.create(base, (String)"messages");
    }

    @Nonnull
    public static String calcPageTitle(Class<?> clz) {
        String s;
        UIMenu ma = clz.getAnnotation(UIMenu.class);
        Locale loc = NlsContext.getLocale();
        BundleRef br = DomUtil.findBundle(ma, clz);
        if (ma != null && br != null) {
            if (ma.titleKey().length() != 0) {
                return br.getString(loc, ma.titleKey());
            }
            if (ma.baseKey().length() != 0 && (s = br.findMessage(loc, ma.baseKey() + ".title")) != null) {
                return s;
            }
            if (ma.labelKey().length() > 0) {
                return br.getString(loc, ma.labelKey());
            }
            if (ma.baseKey().length() != 0 && (s = br.findMessage(loc, ma.baseKey() + ".label")) != null) {
                return s;
            }
        }
        if ((s = (br = DomUtil.getClassBundle(clz)).findMessage(loc, "title")) != null) {
            return s;
        }
        s = br.findMessage(loc, "label");
        if (s != null) {
            return s;
        }
        br = DomUtil.getPackageBundle(clz);
        String root = clz.getName();
        s = br.findMessage(loc, (root = root.substring(root.lastIndexOf(46) + 1)) + ".title");
        if (s != null) {
            return s;
        }
        s = br.findMessage(loc, root + ".label");
        if (s != null) {
            return s;
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(clz);
        String name = cmm.getUserEntityName();
        if (name != null) {
            return name;
        }
        s = clz.getName();
        return s.substring(s.lastIndexOf(46) + 1);
    }

    public static String calcPageLabel(Class<?> clz) {
        String s;
        UIMenu ma = clz.getAnnotation(UIMenu.class);
        Locale loc = NlsContext.getLocale();
        BundleRef br = DomUtil.findBundle(ma, clz);
        if (ma != null && br != null) {
            if (ma.titleKey().length() != 0) {
                return br.getString(loc, ma.titleKey());
            }
            if (ma.baseKey().length() != 0 && (s = br.findMessage(loc, ma.baseKey() + ".label")) != null) {
                return s;
            }
            if (ma.labelKey().length() > 0) {
                return br.getString(loc, ma.labelKey());
            }
            if (ma.baseKey().length() != 0 && (s = br.findMessage(loc, ma.baseKey() + ".title")) != null) {
                return s;
            }
        }
        if ((s = (br = DomUtil.getClassBundle(clz)).findMessage(loc, "label")) != null) {
            return s;
        }
        s = br.findMessage(loc, "title");
        if (s != null) {
            return s;
        }
        br = DomUtil.getPackageBundle(clz);
        String root = clz.getName();
        s = br.findMessage(loc, (root = root.substring(root.lastIndexOf(46) + 1)) + ".label");
        if (s != null) {
            return s;
        }
        s = br.findMessage(loc, root + ".title");
        if (s != null) {
            return s;
        }
        return null;
    }

    public static BundleRef findPageBundle(UrlPage urlPage) {
        if (urlPage == null) {
            throw new NullPointerException("Page cannot be null here");
        }
        UIMenu uim = urlPage.getClass().getAnnotation(UIMenu.class);
        if (uim != null && (uim.bundleBase() != Object.class || uim.bundleName().length() != 0)) {
            BundleRef br = DomUtil.findBundle(uim, urlPage.getClass());
            if (!br.exists()) {
                throw new ProgrammerErrorException("@UIMenu bundle specified (" + uim.bundleBase() + "," + uim.bundleName() + ") but does not exist on page class " + urlPage.getClass());
            }
            return br;
        }
        String fullname = urlPage.getClass().getName();
        int ix = fullname.lastIndexOf(46);
        String cn = fullname.substring(ix + 1);
        BundleRef br = BundleRef.create(urlPage.getClass(), (String)cn);
        if (br.exists()) {
            return br;
        }
        br = BundleRef.create(urlPage.getClass(), (String)"messages");
        if (br.exists()) {
            return br;
        }
        return null;
    }

    public static void renderHtmlString(NodeContainer d, String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder(text.length());
        List<NodeContainer> nodestack = Collections.EMPTY_LIST;
        int ix = 0;
        int len = text.length();
        NodeContainer top = d;
        while (true) {
            char c;
            if (ix < len && (c = text.charAt(ix)) != '<') {
                sb.append(c);
                ++ix;
                continue;
            }
            if (ix >= len) break;
            int tix = ix + 1;
            String tag = null;
            while (tix < len) {
                char c2;
                if ((c2 = text.charAt(tix++)) != '>') continue;
                tag = text.substring(ix, tix);
                break;
            }
            if (tag == null) {
                sb.append('<');
                ++ix;
                continue;
            }
            if (tag.equalsIgnoreCase("<br>") || tag.equalsIgnoreCase("<br/>") || tag.equalsIgnoreCase("<br />")) {
                DomUtil.appendOptionalText(top, sb);
                top.add(new BR());
                ix = tix;
                continue;
            }
            if (tag.equalsIgnoreCase("<b>") || tag.equalsIgnoreCase("<strong>")) {
                DomUtil.appendOptionalText(top, sb);
                ix = tix;
                Span n = new Span();
                n.setCssClass("ui-txt-b");
                nodestack = DomUtil.appendContainer(nodestack, n);
                top.add(n);
                top = n;
                continue;
            }
            if (tag.equalsIgnoreCase("<i>") || tag.equalsIgnoreCase("<em>")) {
                DomUtil.appendOptionalText(top, sb);
                ix = tix;
                Span n = new Span();
                n.setCssClass("ui-txt-i");
                nodestack = DomUtil.appendContainer(nodestack, n);
                top.add(n);
                top = n;
                continue;
            }
            if (tag.startsWith("</")) {
                if ((tag = tag.substring(2, tag.length() - 1).trim()).equalsIgnoreCase("b") || tag.equalsIgnoreCase("i") || tag.equalsIgnoreCase("strong") || tag.equalsIgnoreCase("em")) {
                    ix = tix;
                    DomUtil.appendOptionalText(top, sb);
                    if (nodestack.size() <= 0) continue;
                    nodestack.remove(nodestack.size() - 1);
                    if (nodestack.size() == 0) {
                        top = d;
                        continue;
                    }
                    top = nodestack.get(nodestack.size() - 1);
                    continue;
                }
                sb.append('<');
                ++ix;
                continue;
            }
            sb.append('<');
            ++ix;
        }
        if (sb.length() > 0) {
            top.add(sb.toString());
        }
    }

    public static void htmlRemoveUnsafe(StringBuilder outsb, String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        new HtmlTextScanner().scan(outsb, text);
    }

    public static String htmlRemoveUnsafe(String html) {
        if (html == null || html.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(html.length() + 20);
        DomUtil.htmlRemoveUnsafe(sb, html);
        return sb.toString();
    }

    public static void htmlRemoveAll(StringBuilder outsb, String text, boolean lf) {
        if (text == null || text.length() == 0) {
            return;
        }
        new HtmlTextScanner().scanAndRemove(outsb, text, lf);
    }

    public static String htmlRemoveAll(String html, boolean lf) {
        if (html == null || html.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(html.length() + 20);
        DomUtil.htmlRemoveAll(sb, html, lf);
        return sb.toString();
    }

    public static List<NodeContainer> appendContainer(List<NodeContainer> stack, NodeContainer it) {
        if (stack == Collections.EMPTY_LIST) {
            stack = new ArrayList<NodeContainer>();
        }
        stack.add(it);
        return stack;
    }

    private static void appendOptionalText(NodeContainer nc, StringBuilder sb) {
        if (sb.length() == 0) {
            return;
        }
        nc.add(sb.toString());
        sb.setLength(0);
    }

    public static void renderErrorMessage(NodeContainer d, UIMessage m) {
        if (d.getCssClass() == null) {
            d.setCssClass("ui-msg ui-msg-" + m.getType().name().toLowerCase());
        }
        d.setUserObject(m);
        String text = m.getErrorLocation() != null ? "<b>" + m.getErrorLocation() + ":</b> " + m.getMessage() : m.getMessage();
        DomUtil.renderHtmlString(d, text);
        NodeBase errorNode = m.getErrorNode();
        if (errorNode != null) {
            errorNode.addCssClass("ui-input-err");
        }
    }

    @Deprecated
    public static Long getLongParameter(IPageParameters pp, String name, Long def) {
        String s = pp.getString(name, null);
        if (s == null || s.trim().length() == 0) {
            return def;
        }
        try {
            return Long.valueOf(s.trim());
        }
        catch (Exception x) {
            throw new UIException(Msgs.BUNDLE, "x.invalid.parameter", name);
        }
    }

    public static int pixelSize(String css) {
        return DomUtil.pixelSize(css, -1);
    }

    public static int pixelSize(String css, int defaultVal) {
        if (css == null || !css.endsWith("px")) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(css.substring(0, css.length() - 2).trim());
        }
        catch (Exception x) {
            return defaultVal;
        }
    }

    public static int percentSize(String css) {
        if (css == null || !css.endsWith("%")) {
            return -1;
        }
        try {
            return Integer.parseInt(css.substring(0, css.length() - 1).trim());
        }
        catch (Exception x) {
            return -1;
        }
    }

    public static Object walkTree(NodeBase root, IPerNode handler) throws Exception {
        if (root == null) {
            return null;
        }
        Object v = handler.before(root);
        if (v == IPerNode.SKIP) {
            return null;
        }
        if (v != null) {
            return v;
        }
        if (root instanceof NodeContainer) {
            NodeContainer nc = (NodeContainer)root;
            int len = nc.getChildCount();
            for (int i = 0; i < len; ++i) {
                NodeBase ch = nc.getChild(i);
                v = DomUtil.walkTree(ch, handler);
                if (v == null) continue;
                return v;
            }
        }
        return handler.after(root);
    }

    public static void clearModifiedFlag(NodeBase root) {
        try {
            DomUtil.walkTree(root, new IPerNode(){

                @Override
                public Object before(NodeBase n) throws Exception {
                    if (n instanceof IHasModifiedIndication) {
                        ((IHasModifiedIndication)((Object)n)).setModified(false);
                    }
                    return null;
                }

                @Override
                public Object after(NodeBase n) throws Exception {
                    return null;
                }
            });
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public static boolean isModified(NodeBase root) {
        try {
            Object res = DomUtil.walkTree(root, new IPerNode(){

                @Override
                public Object before(NodeBase n) throws Exception {
                    if (n instanceof IHasModifiedIndication && ((IHasModifiedIndication)((Object)n)).isModified()) {
                        return Boolean.TRUE;
                    }
                    if (n instanceof IUserInputModifiedFence) {
                        return SKIP;
                    }
                    return null;
                }

                @Override
                public Object after(NodeBase n) throws Exception {
                    return null;
                }
            });
            return res != null;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public static void setModifiedFlag(NodeBase node) {
        for (NodeBase n = node; n != null; n = (NodeBase)((Object)n.findParent(IUserInputModifiedFence.class))) {
            boolean wasModifiedBefore = false;
            if (n instanceof IHasModifiedIndication) {
                wasModifiedBefore = ((IHasModifiedIndication)((Object)n)).isModified();
                ((IHasModifiedIndication)((Object)n)).setModified(true);
            }
            if (!(n instanceof IUserInputModifiedFence)) continue;
            if (!wasModifiedBefore) {
                ((IUserInputModifiedFence)((Object)n)).onModifyFlagRaised();
            }
            if (!((IUserInputModifiedFence)((Object)n)).isFinalUserInputModifiedFence()) continue;
            return;
        }
    }

    @Deprecated
    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isRelativeURL(String in) {
        if (in == null) {
            return false;
        }
        return !in.startsWith("http:") && !in.startsWith("https:") && !in.startsWith("/");
    }

    public static <T> boolean isIn(T value, T ... values) {
        for (T item : values) {
            if (!item.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static String createOpenWindowJS(@Nonnull Class<?> targetClass, @Nullable IPageParameters targetParameters, @Nullable WindowParameters newWindowParameters) {
        RequestContextImpl ctx = (RequestContextImpl)UIContext.getRequestContext();
        WindowSession cm = ctx.getSession().createWindowSession();
        StringBuilder sb = new StringBuilder();
        sb.append(ctx.getRelativePath(targetClass.getName()));
        sb.append(".ui?");
        StringTool.encodeURLEncoded((Appendable)sb, (String)"$cid");
        sb.append('=');
        sb.append(cm.getWindowID());
        sb.append(".x");
        if (targetParameters != null) {
            DomUtil.addUrlParameters(sb, targetParameters, false);
        }
        return DomUtil.createOpenWindowJS(sb.toString(), newWindowParameters);
    }

    @Nonnull
    public static String createOpenWindowJS(@Nonnull String url, @Nullable WindowParameters newWindowParameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("DomUI.openWindow('");
        sb.append(url);
        sb.append("','");
        String name = null;
        if (newWindowParameters != null) {
            name = newWindowParameters.getName();
        }
        if (DomUtil.isBlank(name)) {
            name = "window" + DomUtil.generateGUID();
        }
        sb.append(name);
        sb.append("','");
        if (newWindowParameters == null) {
            sb.append("resizable=yes,scrollbars=yes,toolbar=no,location=no,directories=no,status=yes,menubar=yes,copyhistory=no");
        } else {
            sb.append("resizable=");
            sb.append(newWindowParameters.isResizable() ? "yes" : "no");
            sb.append(",scrollbars=");
            sb.append(newWindowParameters.isShowScrollbars() ? "yes" : "no");
            sb.append(",toolbar=");
            sb.append(newWindowParameters.isShowToolbar() ? "yes" : "no");
            sb.append(",location=");
            sb.append(newWindowParameters.isShowLocation() ? "yes" : "no");
            sb.append(",directories=");
            sb.append(newWindowParameters.isShowDirectories() ? "yes" : "no");
            sb.append(",status=");
            sb.append(newWindowParameters.isShowStatus() ? "yes" : "no");
            sb.append(",menubar=");
            sb.append(newWindowParameters.isShowMenubar() ? "yes" : "no");
            sb.append(",copyhistory=");
            sb.append(newWindowParameters.isCopyhistory() ? "yes" : "no");
            if (newWindowParameters.getWidth() > 0) {
                sb.append(",width=");
                sb.append(newWindowParameters.getWidth());
            }
            if (newWindowParameters.getHeight() > 0) {
                sb.append(",height=");
                sb.append(newWindowParameters.getHeight());
            }
        }
        sb.append("');");
        return sb.toString();
    }

    public static boolean isWhitespace(char c) {
        return c == '\u00a0' || Character.isWhitespace(c);
    }

    public static StackTraceElement[] getTracepoint() {
        try {
            throw new Exception();
        }
        catch (Exception x) {
            return x.getStackTrace();
        }
    }

    public static String getLorem() throws Exception {
        if (null == m_lorem) {
            InputStream is = DomUtil.class.getResourceAsStream("lorem.txt");
            try {
                m_lorem = FileTool.readStreamAsString((InputStream)is, (String)"utf-8");
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return m_lorem;
    }

    public static <V, T extends IIdentifyable<V>> boolean containsLongIdentifyable(@Nonnull Collection<T> set, @Nonnull T lookingFor) {
        Object id = lookingFor.getId();
        if (null == id) {
            throw new IllegalStateException(lookingFor + ": id is null");
        }
        for (IIdentifyable member : set) {
            Object mid = member.getId();
            if (null == mid || !mid.equals(id)) continue;
            return true;
        }
        return false;
    }

    public static <V, T extends IIdentifyable<V>> int indexOfLongIdentifyable(@Nonnull List<T> list, @Nonnull T lookingFor) {
        if (list == null) {
            return -1;
        }
        Object id = lookingFor.getId();
        if (null == id) {
            throw new IllegalStateException(lookingFor + ": id is null");
        }
        int i = list.size();
        while (--i >= 0) {
            Object mid = ((IIdentifyable)list.get(i)).getId();
            if (null == mid || !mid.equals(id)) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public static <V, T extends IIdentifyable<V>> List<T> merge(@Nonnull List<T> mergeSource, @Nonnull T item) {
        if (!DomUtil.containsLongIdentifyable(mergeSource, item)) {
            if (mergeSource == Collections.EMPTY_LIST) {
                mergeSource = new ArrayList<T>();
            }
            mergeSource.add(item);
        }
        return mergeSource;
    }

    public static <V, T extends IIdentifyable<V>> List<T> merge(@Nonnull List<T> mergeSource, @Nonnull List<T> toJoinItems) {
        for (IIdentifyable item : toJoinItems) {
            mergeSource = DomUtil.merge(mergeSource, item);
        }
        return mergeSource;
    }

    public static <T> boolean contains(T[] array, T lookingFor) {
        return DomUtil.indexOf(array, lookingFor) != -1;
    }

    public static <T> int indexOf(T[] array, T lookingFor) {
        if (array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!DomUtil.isEqual(array[i], lookingFor)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static Object getSessionAttribute(@Nonnull String attribute, boolean doReset) {
        IRequestContext ctx = UIContext.getRequestContext();
        AppSession ses = ctx.getSession();
        Object val = ses.getAttribute(attribute);
        if (doReset) {
            ses.setAttribute(attribute, null);
        }
        return val;
    }

    public static void setSessionAttribute(@Nonnull String attribute, @Nullable Object value) {
        IRequestContext ctx = UIContext.getRequestContext();
        AppSession ses = ctx.getSession();
        ses.setAttribute(attribute, value);
    }

    @Nullable
    public static String getHintValue(String componentTypeHint, String name) {
        String[] frags;
        if (null == componentTypeHint) {
            return null;
        }
        name = name.toLowerCase();
        int l = name.length();
        for (String frag : frags = componentTypeHint.split(";")) {
            if (!frag.toLowerCase().startsWith(name)) continue;
            if (frag.length() == l) {
                return "";
            }
            char c = frag.charAt(l);
            if (c != '=') continue;
            return frag.substring(l + 1);
        }
        return null;
    }

    @Nonnull
    public static String getComponentDetails(NodeBase n) {
        if (null == n) {
            return "null";
        }
        return n.getComponentInfo();
    }

    public static void main(String[] args) {
        String html = "<p>This is <i>just</i> some html with<br>a new line <b>and a bold tag</b>";
        String uns = DomUtil.htmlRemoveUnsafe(html);
        System.out.println("uns=" + uns);
    }

    @Nonnull
    public static List<UIMessage> addSingleShotMessage(@Nonnull NodeBase node, @Nonnull UIMessage message) {
        WindowSession ws = node.getPage().getConversation().getWindowSession();
        List msgl = null;
        Object stored = ws.getAttribute("uigoto.msgs");
        msgl = stored != null && stored instanceof List ? (List)stored : new ArrayList(1);
        msgl.add(message);
        ws.setAttribute("uigoto.msgs", msgl);
        return msgl;
    }

    public static String calcNodeText(@Nonnull NodeContainer nc) {
        StringBuilder sb = new StringBuilder();
        DomUtil.calcNodeText(sb, nc);
        return sb.toString();
    }

    private static void calcNodeText(@Nonnull StringBuilder sb, @Nonnull NodeContainer nc) {
        for (NodeBase nb : nc) {
            if (nb instanceof TextNode) {
                String text = ((TextNode)nb).getText();
                if (text == null || DomUtil.appendPartial(sb, text)) continue;
                return;
            }
            if (!(nb instanceof NodeContainer)) continue;
            DomUtil.calcNodeText(sb, (NodeContainer)nb);
        }
    }

    public static void time(@Nonnull String what, @Nonnull IExecute exec) throws Exception {
        long ts = System.nanoTime();
        exec.execute();
        ts = System.nanoTime() - ts;
        System.out.println(what + " took " + StringTool.strNanoTime((long)ts));
    }

    private static boolean appendPartial(@Nonnull StringBuilder sb, @Nonnull String text) {
        int todo = 400 - sb.length();
        if (todo >= text.length()) {
            sb.append(text);
            return true;
        }
        if (todo > 0) {
            sb.append(text.substring(0, todo));
        }
        return false;
    }

    static {
        long val = System.currentTimeMillis() / 1000L / 60L;
        m_guidSeed = (int)val;
        BASE64MAP = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_0".toCharArray();
    }

    public static interface IPerNode {
        public static final Object SKIP = new Object();

        public Object before(@Nonnull NodeBase var1) throws Exception;

        public Object after(@Nonnull NodeBase var1) throws Exception;
    }
}

