/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import to.etc.util.StringTool;

public final class HtmlUtil {
    private static final Set<String> VALID_ELEMENT_NAMES = new HashSet<String>(Arrays.asList("br", "p", "b", "i", "ol", "ul", "li", "a", "code", "div"));
    private static final Set<String> VALID_ATTRIBUTE_NAMES = new HashSet<String>(Arrays.asList("id", "class", "href", "target", "title", "color", "face", "size"));
    private static final Object VALID_MARKER = new Object();

    private HtmlUtil() {
    }

    @Nullable
    public static String removeUnsafe(@Nullable String htmlIn) {
        if (null == htmlIn) {
            return null;
        }
        String s = HtmlUtil.sanitize(htmlIn, false, true);
        return s;
    }

    private static String sanitize(String pseudoHTML, boolean formatWhiteSpace, boolean stripInvalidElements) {
        StringBuilder sb = new StringBuilder(pseudoHTML.length() + 2000);
        try {
            StringTool.entitiesToUnicode((Appendable)sb, (String)pseudoHTML, (boolean)true);
            pseudoHTML = sb.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Source source = new Source((CharSequence)pseudoHTML);
        source.fullSequentialParse();
        OutputDocument outputDocument = new OutputDocument(source);
        List tags = source.getAllTags();
        int pos = 0;
        for (Tag tag : tags) {
            if (HtmlUtil.processTag(tag, outputDocument)) {
                tag.setUserData(VALID_MARKER);
            } else {
                if (!stripInvalidElements) continue;
                outputDocument.remove((Segment)tag);
            }
            HtmlUtil.reencodeTextSegment(source, outputDocument, pos, tag.getBegin(), formatWhiteSpace);
            pos = tag.getEnd();
        }
        HtmlUtil.reencodeTextSegment(source, outputDocument, pos, source.getEnd(), formatWhiteSpace);
        sb.setLength(0);
        try {
            StringTool.entitiesToUnicode((Appendable)sb, (String)outputDocument.toString(), (boolean)true);
            pseudoHTML = sb.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    private static boolean processTag(Tag tag, OutputDocument outputDocument) {
        String elementName = tag.getName();
        if (!VALID_ELEMENT_NAMES.contains(elementName)) {
            return false;
        }
        if (tag.getTagType() == StartTagType.NORMAL) {
            Element element = tag.getElement();
            if (HtmlUtil.isParentInCodeTag(tag)) {
                if (elementName == "div") {
                    return false;
                }
                if (elementName == "br") {
                    outputDocument.replace((Segment)tag, (CharSequence)"\n");
                    return true;
                }
            } else {
                if ("code" == elementName) {
                    Tag prev = tag.getPreviousTag();
                    if (prev != null && prev.getTagType() == EndTagType.NORMAL && prev.getName() == "code") {
                        outputDocument.remove((Segment)prev);
                        outputDocument.replace((Segment)tag, (CharSequence)"\n");
                    }
                    return true;
                }
                if (HTMLElements.getEndTagRequiredElementNames().contains(elementName)) {
                    if (element.getEndTag() == null) {
                        return false;
                    }
                } else if (HTMLElements.getEndTagOptionalElementNames().contains(elementName)) {
                    if (elementName == "li" && !HtmlUtil.isValidLITag(tag)) {
                        return false;
                    }
                    if (element.getEndTag() == null) {
                        outputDocument.insert(element.getEnd(), (CharSequence)HtmlUtil.getEndTagHTML(elementName));
                    }
                }
            }
            CharSequence text = HtmlUtil.getStartTagHTML(element.getStartTag());
            String tagtext = tag.toString();
            if (!tagtext.equals(text.toString())) {
                outputDocument.replace((Segment)tag, text);
            }
        } else if (tag.getTagType() == EndTagType.NORMAL) {
            if (tag.getElement() == null) {
                return false;
            }
            if (elementName == "li" && !HtmlUtil.isValidLITag(tag)) {
                return false;
            }
            if (HtmlUtil.isParentInCodeTag(tag) && elementName == "div") {
                outputDocument.replace((Segment)tag, (CharSequence)"\n");
                return false;
            }
            String text = HtmlUtil.getEndTagHTML(elementName);
            String tagtext = tag.toString();
            if (!tagtext.equals(text.toString())) {
                outputDocument.replace((Segment)tag, (CharSequence)text);
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean isParentInCodeTag(Tag tag) {
        Element dad = tag.getElement();
        do {
            if ((dad = dad.getParentElement()) != null) continue;
            return false;
        } while (dad.getName() != "code");
        return true;
    }

    private static boolean isValidLITag(Tag tag) {
        Element parentElement = tag.getElement().getParentElement();
        if (parentElement == null) {
            return false;
        }
        if (parentElement.getStartTag().getUserData() != VALID_MARKER) {
            return false;
        }
        return parentElement.getName() == "ul" || parentElement.getName() == "ol";
    }

    private static void reencodeTextSegment(Source source, OutputDocument outputDocument, int begin, int end, boolean formatWhiteSpace) {
        String encodedText;
        if (begin >= end) {
            return;
        }
        Segment textSegment = new Segment(source, begin, end);
        String decodedText = CharacterReference.decode((CharSequence)textSegment);
        String string = encodedText = formatWhiteSpace ? CharacterReference.encodeWithWhiteSpaceFormatting((CharSequence)decodedText) : CharacterReference.encode((CharSequence)decodedText);
        if (!decodedText.equals(encodedText)) {
            outputDocument.replace(textSegment, (CharSequence)encodedText);
        }
    }

    private static CharSequence getStartTagHTML(StartTag startTag) {
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(startTag.getName());
        for (Attribute attribute : startTag.getAttributes()) {
            if (!VALID_ATTRIBUTE_NAMES.contains(attribute.getKey())) continue;
            sb.append(' ').append(attribute.getName());
            if (attribute.getValue() == null) continue;
            sb.append("=\"");
            sb.append(CharacterReference.encode((CharSequence)attribute.getValue()));
            sb.append('\"');
        }
        if (startTag.getElement().getEndTag() == null && !HTMLElements.getEndTagOptionalElementNames().contains(startTag.getName())) {
            sb.append(" /");
        }
        sb.append('>');
        return sb;
    }

    private static String getEndTagHTML(String tagName) {
        return "</" + tagName + '>';
    }

    public static void main(String[] args) {
        String res = HtmlUtil.removeUnsafe("Dit<p><code>i1</code><code>i2</code></p><p>een</p><p>twee</p>");
        System.out.println("Res=" + res);
    }
}

