/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util;

import java.util.List;
import to.etc.domui.component.input.ComboFixed;
import to.etc.domui.component.input.ComboLookup;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.input.TextStr;
import to.etc.domui.component.input.ValueLabelPair;
import to.etc.domui.component.layout.ButtonBar;
import to.etc.domui.component.layout.IButtonBar;
import to.etc.domui.component.upload.FileUpload;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TH;
import to.etc.domui.dom.html.THead;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IListMaker;

public class MiniTableBuilder {
    private Table m_table;
    private TBody m_body;
    private THead m_head;
    private ButtonBar m_bb;

    public Table getTable() {
        if (this.m_table == null) {
            this.m_table = new Table();
        }
        return this.m_table;
    }

    public TBody getBody() {
        if (this.m_body == null) {
            this.m_body = new TBody();
            this.getTable().add(this.m_body);
        }
        return this.m_body;
    }

    public THead getHead() {
        if (this.m_head == null) {
            this.m_head = new THead();
            this.getTable().add(this.m_head);
        }
        return this.m_head;
    }

    public void appendTo(NodeContainer c) {
        if (this.m_table != null) {
            c.add(this.m_table);
            this.m_table = null;
            this.m_body = null;
            this.m_head = null;
            this.m_bb = null;
        }
    }

    public void adjustColspans() {
        DomUtil.adjustTableColspans(this.m_table);
    }

    public void clear() {
        this.m_table = null;
        this.m_body = null;
        this.m_head = null;
    }

    public TD addRowAndCell() {
        return this.getBody().addRowAndCell();
    }

    public TR addRow() {
        return this.getBody().addRow();
    }

    public TD addCell() {
        if (this.row() == null) {
            this.addRow();
        }
        return this.getBody().addCell();
    }

    public TR row() {
        return this.getBody().row();
    }

    public TD cell() {
        return this.getBody().cell();
    }

    public <T extends NodeBase> T add(T comp) {
        this.cell().add(comp);
        return comp;
    }

    public void setHeaders(String ... hdrs) {
        this.getHead().setHeaders(hdrs);
    }

    public TH addHeader(String text) {
        return this.getHead().addHeader(text);
    }

    public <T> Text<T> addText(Class<T> clz) {
        return this.add(new Text<T>(clz));
    }

    private void doLabelCtl(String label) {
        this.addCell().add(DomUtil.nlsLabel(label));
        this.cell().setCssClass("ui-f-lbl");
        this.addCell().setCssClass("ui-f-in");
    }

    public void addLabel(String lbl) {
        this.addCell().add(DomUtil.nlsLabel(lbl));
        this.cell().setCssClass("ui-f-lbl");
    }

    public <T> Text<T> addText(String label, Class<T> clz) {
        this.doLabelCtl(label);
        return this.addText(clz);
    }

    public TextStr addStr() {
        return this.add(new TextStr());
    }

    public TextStr addStr(String label) {
        this.doLabelCtl(label);
        return this.add(new TextStr());
    }

    public FileUpload addUpload(int maxfiles, String exts) {
        return this.add(new FileUpload(maxfiles, exts));
    }

    public FileUpload addUpload(String label, int maxfiles, String exts) {
        this.doLabelCtl(label);
        return this.addUpload(maxfiles, exts);
    }

    public <T> ComboLookup<T> addComboLookup(IListMaker<T> maker) {
        ComboLookup<T> cb = new ComboLookup<T>(maker);
        return this.add(cb);
    }

    public <T> ComboLookup<T> addComboLookup(String label, IListMaker<T> maker) {
        this.doLabelCtl(label);
        return this.addComboLookup(maker);
    }

    public <T> ComboLookup<T> addComboLookup(List<T> input) {
        ComboLookup<T> cb = new ComboLookup<T>(input);
        return this.add(cb);
    }

    public <T> ComboLookup<T> addComboLookup(String label, List<T> input) {
        this.doLabelCtl(label);
        return this.addComboLookup(input);
    }

    public <T> ComboFixed<T> addComboFixed(List<ValueLabelPair<T>> list) {
        ComboFixed<T> cf = new ComboFixed<T>(list);
        return this.add(cf);
    }

    public <T> ComboFixed<T> addComboFixed(String label, List<ValueLabelPair<T>> list) {
        this.doLabelCtl(label);
        return this.addComboFixed(list);
    }

    public IButtonBar bb() {
        if (this.m_bb == null) {
            this.m_bb = new ButtonBar();
            if (this.row() == null || this.row().getChildCount() > 0) {
                this.addRowAndCell();
            }
            this.cell().add(this.m_bb);
        }
        return this.m_bb;
    }
}

