/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util;

import java.util.Locale;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.converter.IConverter;
import to.etc.domui.trouble.UIException;
import to.etc.util.WrappedException;

public final class PropertyValueConverter<T>
implements IConverter<T> {
    private final String[] m_properties;

    public PropertyValueConverter(String ... properties) {
        this.m_properties = properties;
    }

    @Override
    public T convertStringToObject(Locale loc, String in) throws UIException {
        throw new IllegalStateException("This converter cannot be used for input");
    }

    @Override
    public String convertObjectToString(Locale loc, T in) throws UIException {
        if (null == in) {
            return "";
        }
        Class<?> clz = in.getClass();
        ClassMetaModel cmm = MetaManager.findClassMeta(clz);
        StringBuilder sb = new StringBuilder();
        for (String pname : this.m_properties) {
            Object value;
            PropertyMetaModel<?> pmm = cmm.findProperty(pname);
            if (null == pmm) {
                throw new IllegalArgumentException("The property '" + pname + "' is unknown on class " + clz.getName() + " (" + this + ")");
            }
            try {
                value = pmm.getValue(in);
            }
            catch (Exception x) {
                throw WrappedException.wrap((Exception)x);
            }
            if (value == null) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(String.valueOf(value));
        }
        return sb.toString();
    }
}

