/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.event.ICheckCallback;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.state.AppSession;
import to.etc.domui.util.DomUtil;
import to.etc.util.StringTool;
import to.etc.webapp.query.IIdentifyable;
import to.etc.webapp.query.QDataContext;

public class SessionStorageUtil {
    private static final String PART_TIME = "time";
    private static final String PART_TYPE = "type";
    private static final String PART_ID = "id";
    private static final String EMPTY_VALUE = "#NULL#";

    public static boolean hasStoredData(@Nonnull IRequestContext ctx, @Nonnull ISessionStorage storableData) {
        AppSession ses = ctx.getSession();
        return null != ses.getAttribute(storableData.getStorageId() + "|" + PART_TIME);
    }

    public static void storeData(@Nonnull IRequestContext ctx, @Nonnull ISessionStorage storableData) {
        AppSession ses = ctx.getSession();
        ses.setAttribute(storableData.getStorageId() + "|" + PART_TIME, new Date());
        for (IControl control : storableData.getNodeToStore().getDeepChildren(IControl.class)) {
            UIMessage existingMessage;
            String controlKey = control.getErrorLocation();
            if (StringTool.isBlank((String)controlKey) || SessionStorageUtil.isIgnoredControl(DomUtil.nullChecked(controlKey), storableData.getIgnoredControlKeys()) || null != (existingMessage = control.getMessage())) continue;
            Object value = control.getValueSafe();
            control.clearMessage();
            String key = storableData.getStorageId() + "|" + controlKey;
            if (null == value) {
                value = EMPTY_VALUE;
                ses.setAttribute(key, value);
                continue;
            }
            if (value instanceof IIdentifyable) {
                ClassMetaModel cmm = MetaManager.findClassMeta(value.getClass());
                if (null == cmm) continue;
                Object id = ((IIdentifyable)value).getId();
                ses.setAttribute(key + "|" + PART_TYPE, cmm.getActualClass());
                ses.setAttribute(key + "|" + PART_ID, id);
                continue;
            }
            ses.setAttribute(key, value);
        }
    }

    private static boolean isIgnoredControl(@Nonnull String controlKey, @Nonnull List<String> ignoredControlKeys) {
        return ignoredControlKeys.contains(controlKey);
    }

    public static void loadData(@Nonnull QDataContext dc, @Nonnull IRequestContext ctx, @Nonnull ISessionStorage storableData) throws Exception {
        AppSession ses = ctx.getSession();
        for (IControl control : storableData.getNodeToStore().getDeepChildren(IControl.class)) {
            Object id;
            UIMessage existingMessage = control.getMessage();
            Object existingValue = control.getValueSafe();
            if (null == existingMessage) {
                control.clearMessage();
            } else if (!existingMessage.equals(control.getMessage())) {
                control.setMessage(existingMessage);
            }
            String key = storableData.getStorageId() + "|" + control.getErrorLocation();
            Object sesValue = ses.getAttribute(key);
            ICheckCallback<ControlValuePair> callback = storableData.getCustomLoadCallback();
            if (null != sesValue) {
                if (EMPTY_VALUE.equals(sesValue)) {
                    if (MetaManager.areObjectsEqual(null, existingValue)) continue;
                    control.setValue(null);
                    SessionStorageUtil.fireValueChanged(control);
                    continue;
                }
                if (MetaManager.areObjectsEqual(sesValue, existingValue)) continue;
                boolean handled = SessionStorageUtil.setNonIdentifiableTypeValue(control, sesValue);
                if (handled) {
                    SessionStorageUtil.fireValueChanged(control);
                    continue;
                }
                if (callback == null || !callback.check(new ControlValuePair(control, sesValue))) continue;
                SessionStorageUtil.fireValueChanged(control);
                continue;
            }
            Class type = (Class)ses.getAttribute(key + "|" + PART_TYPE);
            if (null == type || null == (id = ses.getAttribute(key + "|" + PART_ID)) || !SessionStorageUtil.setIdentifiableValue(dc, control, type, id, existingValue)) continue;
            SessionStorageUtil.fireValueChanged(control);
        }
    }

    private static void fireValueChanged(@Nonnull IControl<?> control) throws Exception {
        if (control instanceof NodeBase) {
            IValueChanged<?> valueChangedListener = control.getOnValueChanged();
            if (valueChangedListener != null) {
                valueChangedListener.onValueChanged((NodeBase)((Object)control));
            }
        } else {
            throw new IllegalStateException("Unexpected type for control[" + control.getClass() + "]. Has to be assignable from " + NodeBase.class);
        }
    }

    private static boolean setIdentifiableValue(@Nonnull QDataContext dc, @Nonnull IControl<?> control, @Nonnull Class<?> type, @Nonnull Object id, @Nullable Object existingValue) throws Exception {
        if (id instanceof Long) {
            Long longId = (Long)id;
            IIdentifyable val = (IIdentifyable)dc.find(type, (Object)longId);
            if (!MetaManager.areObjectsEqual(val, existingValue)) {
                control.setValue(val);
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Id argument type not supported [" + id + "], Id argument of type:" + id.getClass());
    }

    private static boolean setNonIdentifiableTypeValue(@Nonnull IControl<?> control, @Nonnull Object value) {
        boolean recognized = true;
        if (value instanceof Integer) {
            control.setValue((Integer)value);
        } else if (value instanceof BigDecimal) {
            control.setValue((BigDecimal)value);
        } else if (value instanceof Double) {
            control.setValue((Double)value);
        } else if (value instanceof Long) {
            control.setValue((Long)value);
        } else if (value instanceof Date) {
            control.setValue((Date)value);
        } else if (value instanceof Boolean) {
            control.setValue((Boolean)value);
        } else if (value instanceof String) {
            control.setValue((String)value);
        } else if (Enum.class.isAssignableFrom(value.getClass())) {
            control.setValue((Enum)value);
        } else {
            recognized = false;
        }
        return recognized;
    }

    public static class ControlValuePair {
        @Nonnull
        private final IControl<?> m_control;
        @Nonnull
        private final Object m_value;

        ControlValuePair(@Nonnull IControl<?> control, @Nonnull Object value) {
            this.m_control = control;
            this.m_value = value;
        }

        @Nonnull
        public IControl<?> getControl() {
            return this.m_control;
        }

        @Nonnull
        public Object getValue() {
            return this.m_value;
        }
    }

    public static interface ISessionStorage {
        @Nonnull
        default public String getStorageId() {
            return this.getClass().getSimpleName();
        }

        @Nonnull
        default public NodeContainer getNodeToStore() {
            if (this instanceof NodeContainer) {
                return (NodeContainer)((Object)this);
            }
            throw new IllegalStateException("Must be instance of NodeContainer or provide correct node container");
        }

        @Nonnull
        default public List<String> getIgnoredControlKeys() {
            return Collections.EMPTY_LIST;
        }

        @Nullable
        default public ICheckCallback<ControlValuePair> getCustomLoadCallback() {
            return null;
        }
    }
}

