/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util;

import java.util.HashMap;
import java.util.Map;
import to.etc.domui.dom.html.DropMode;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.util.DivModeDragAndDropPlugin;
import to.etc.domui.util.IDragArea;
import to.etc.domui.util.IDragHandler;
import to.etc.domui.util.IDragNdropPlugin;
import to.etc.domui.util.IDropHandler;

public final class UIDragDropUtil
implements IDragNdropPlugin {
    public static final String DROP_MODE_ATTRIBUTE = "DROP_MODE";
    private static final DropMode DEFAULT_MODE = DropMode.ROW;
    private static Map<DropMode, IDragNdropPlugin> m_dragNdropPlugins = new HashMap<DropMode, IDragNdropPlugin>();

    private UIDragDropUtil() {
    }

    public static void exposeDraggable(NodeBase base, IDragHandler dh) {
        IDragNdropPlugin plugin = UIDragDropUtil.getPlugin(base);
        plugin.renderDraggable(base, dh);
    }

    public static void exposeDroppable(NodeBase base, IDropHandler dh) {
        IDragNdropPlugin plugin = UIDragDropUtil.getPlugin(base);
        plugin.renderDroppable(base, dh);
    }

    private static IDragNdropPlugin getPlugin(NodeBase base) {
        String mode = base.getSpecialAttribute(DROP_MODE_ATTRIBUTE);
        DropMode key = mode != null ? DropMode.valueOf(mode) : null;
        IDragNdropPlugin plugin = m_dragNdropPlugins.get((Object)key);
        if (plugin == null) {
            plugin = m_dragNdropPlugins.get((Object)DEFAULT_MODE);
        }
        return plugin;
    }

    @Override
    public DropMode getMode() {
        return DEFAULT_MODE;
    }

    @Override
    public void renderDraggable(NodeBase base, IDragHandler dh) {
        if (dh == null) {
            base.removeCssClass("ui-drgbl");
        } else {
            base.addCssClass("ui-drgbl");
            base.setOnMouseDownJS("WebUI.dragMouseDown(this, event)");
            base.setSpecialAttribute("uitype", dh.getTypeName(base));
            IDragArea dragArea = dh.getDragArea();
            if (dragArea != null) {
                base.setSpecialAttribute("dragarea", dragArea.getActualID());
            }
        }
    }

    @Override
    public void renderDroppable(NodeBase base, IDropHandler dh) {
        if (dh == null) {
            base.removeCssClass("ui-drpbl");
        } else {
            base.addCssClass("ui-drpbl");
            StringBuilder sb = new StringBuilder();
            if (dh.getAcceptableTypes() == null) {
                throw new IllegalStateException("The IDropHandler for node " + base + " (" + dh + ") returns a null list of acceptable types");
            }
            for (String s : dh.getAcceptableTypes()) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append(s);
            }
            base.setSpecialAttribute("uitypes", sb.toString());
        }
    }

    static {
        UIDragDropUtil rowDD = new UIDragDropUtil();
        m_dragNdropPlugins.put(rowDD.getMode(), rowDD);
        DivModeDragAndDropPlugin divDD = new DivModeDragAndDropPlugin();
        m_dragNdropPlugins.put(divDD.getMode(), divDD);
    }
}

