/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.bugs;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.util.bugs.BugItem;
import to.etc.domui.util.bugs.IBugListener;

public class Bug {
    private static final ThreadLocal<IBugListener> m_listener = new ThreadLocal();

    private Bug() {
    }

    public static void bug(@Nonnull String message) {
        BugItem bi = new BugItem(message);
        Bug.postBug(bi);
    }

    public static void bug(List<NodeBase> msg) {
        BugItem bi = new BugItem(msg);
        Bug.postBug(bi);
    }

    public static void bug(@Nullable Throwable x, @Nonnull String message) {
        BugItem bi = new BugItem(message, x);
        Bug.postBug(bi);
    }

    public static void bug(@Nonnull Throwable x) {
        BugItem bi = new BugItem(x.getMessage(), x);
        Bug.postBug(bi);
    }

    private static void postBug(BugItem bi) {
        IBugListener listener = m_listener.get();
        if (null == listener) {
            System.out.println("BUG: " + bi.getMessage());
            Throwable x = bi.getException();
            if (null != x) {
                x.printStackTrace();
            }
            return;
        }
        try {
            listener.bugSignaled(bi);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Nullable
    public static IBugListener getListener() {
        return m_listener.get();
    }

    public static void setListener(@Nullable IBugListener l) {
        m_listener.set(l);
    }
}

