/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.bugs;

import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TextNode;

public final class BugItem {
    private final Date m_timestamp = new Date();
    @Nonnull
    private String m_message;
    @Nullable
    private final Throwable m_exception;
    @Nullable
    private Exception m_location;
    @Nullable
    private List<NodeBase> m_formattedMsg;
    private int m_number;

    public BugItem(@Nonnull String message) {
        this.m_message = message;
        this.m_exception = null;
        this.initLocation();
    }

    public BugItem(List<NodeBase> msg) {
        this.m_formattedMsg = msg;
        this.m_exception = null;
        this.initLocation();
        StringBuilder sb = new StringBuilder();
        BugItem.flatten(sb, msg);
        this.m_message = sb.toString();
    }

    public BugItem(@Nonnull String message, @Nullable Throwable exception) {
        this.m_message = message;
        this.m_exception = exception;
        this.initLocation();
    }

    private static void flatten(StringBuilder sb, List<NodeBase> msg) {
        for (NodeBase b : msg) {
            BugItem.flatten(sb, b);
        }
    }

    private static void flatten(StringBuilder sb, NodeBase b) {
        if (b instanceof TextNode) {
            sb.append(((TextNode)b).getText());
        } else if (b instanceof NodeContainer) {
            for (NodeBase cb : (NodeContainer)b) {
                BugItem.flatten(sb, cb);
            }
        }
    }

    private void initLocation() {
        try {
            throw new Exception("duh");
        }
        catch (Exception x) {
            this.m_location = x;
            return;
        }
    }

    @Nonnull
    public Date getTimestamp() {
        return this.m_timestamp;
    }

    @Nonnull
    public String getMessage() {
        return this.m_message;
    }

    @Nullable
    public Throwable getException() {
        return this.m_exception;
    }

    @Nonnull
    public Exception getLocation() {
        if (this.m_location != null) {
            return this.m_location;
        }
        throw new IllegalStateException("?? Location unset??");
    }

    public int getNumber() {
        return this.m_number;
    }

    public void setNumber(int number) {
        this.m_number = number;
    }

    @Nullable
    public List<NodeBase> getFormattedMsg() {
        return this.m_formattedMsg;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("message=").append(this.getMessage());
        sb.append("]");
        return sb.toString();
    }
}

