/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.bugs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.layout.FloatingWindow;
import to.etc.domui.component.layout.IWindowClosed;
import to.etc.domui.dom.css.VerticalAlignType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.ImgAlign;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.Span;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IDomUIStateListener;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.IRequestInterceptor;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.UIContext;
import to.etc.domui.state.WindowSession;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.bugs.Bug;
import to.etc.domui.util.bugs.BugItem;
import to.etc.domui.util.bugs.IBugListener;
import to.etc.util.StringTool;

public class DefaultBugListener
implements IBugListener {
    private static final int MAX_BUGS = 20;
    private static final String KEY = "DefaultBugList";
    private static final DefaultBugListener INSTANCE = new DefaultBugListener();
    static final String[] PRESET = new String[]{"to.etc.dbpool.", "oracle.", "to.etc.domui.util.bugs."};
    static final String[] ENDSET = new String[]{"to.etc.dbpool.", "org.apache.tomcat.", "org.apache.coyote.", "org.apache.catalina."};

    @Override
    public void bugSignaled(@Nonnull BugItem item) {
        ConversationContext cc;
        try {
            cc = UIContext.getCurrentConversation();
        }
        catch (Exception x) {
            System.out.println("Bug signalled, outside UI: " + item);
            return;
        }
        BugRef ref = (BugRef)cc.getAttribute(KEY);
        if (ref == null) {
            ref = new BugRef();
            cc.setAttribute(KEY, ref);
        }
        ref.getBugList().add(item);
        item.setNumber(ref.getBugList().size());
        if (ref.getWindow() != null) {
            ref.getWindow().remove();
            ref.setWindow(null);
        }
    }

    public static void onRequestAfter(IRequestContext rc) {
        Bug.setListener(null);
    }

    protected static void onRequestBefore(IRequestContext rc) {
        Bug.setListener(INSTANCE);
    }

    public static void registerSessionListener(DomApplication da) {
        da.addInterceptor(new IRequestInterceptor(){

            @Override
            public void before(IRequestContext rc) throws Exception {
                DefaultBugListener.onRequestBefore(rc);
            }

            @Override
            public void after(IRequestContext rc, Exception x) throws Exception {
                DefaultBugListener.onRequestAfter(rc);
            }
        });
        da.addUIStateListener(new IDomUIStateListener(){

            @Override
            public void windowSessionDestroyed(WindowSession ws) throws Exception {
            }

            @Override
            public void windowSessionCreated(WindowSession ws) throws Exception {
            }

            @Override
            public void onBeforePageAction(RequestContextImpl ctx, Page pg) {
            }

            @Override
            public void onBeforeFullRender(RequestContextImpl ctx, Page pg) {
            }

            @Override
            public void onAfterPage(IRequestContext ctx, Page pg) {
                DefaultBugListener.checkForBugs(ctx, pg);
            }

            @Override
            public void conversationDestroyed(ConversationContext cc) throws Exception {
            }

            @Override
            public void conversationCreated(ConversationContext cc) throws Exception {
            }
        });
    }

    protected static void checkForBugs(IRequestContext ctx, final Page pg) {
        ConversationContext cc = pg.getConversation();
        BugRef ref = (BugRef)cc.getAttribute(KEY);
        if (null == ref || ref.getBugList().size() == 0) {
            return;
        }
        System.out.println("BugListener: need to add UI for " + ref.getBugList().size() + " bugs are present");
        if (ref.getIndicator() == null) {
            Div ind = new Div();
            ind.setCssClass("ui-bug-ind");
            ind.setTitle("Houston, we have a problem... Bugs have been found.");
            Span count = new Span();
            count.setCssClass("ui-bug-count");
            ind.add(count);
            Img img = new Img("THEME/ui-bug-ind.png");
            ind.add(img);
            img.setImgBorder(0);
            img.setAlign(ImgAlign.RIGHT);
            ref.setIndicator(ind, count, img);
            final BugRef info = ref;
            ind.setClicked(new IClicked<Div>(){

                @Override
                public void clicked(@Nonnull Div clickednode) throws Exception {
                    DefaultBugListener.toggleBugDisplay(pg, info);
                }
            });
            pg.getBody().add(ind);
        }
        if (ref.getBugList().size() != ref.getLastCount()) {
            int ct = ref.getBugList().size();
            if (ct >= 20 && ref.getLastCount() < 20) {
                ref.getCountNode().setText("\u221e");
                ref.getIndicator().setTitle("Too many bugs..");
                ref.getImage().setSrc("THEME/ui-bug-ovf.png");
            } else if (ct < 20) {
                ref.getCountNode().setText(Integer.toString(ct));
                ref.setLastCount(ref.getBugList().size());
            }
        }
    }

    protected static void clearMessages(BugRef ref) {
        if (ref.getWindow() != null) {
            ref.getWindow().remove();
            ref.setWindow(null);
        }
        if (ref.getIndicator() != null) {
            ref.getIndicator().remove();
            ref.setIndicator(null, null, null);
        }
        ref.getBugList().clear();
        ref.setLastCount(0);
    }

    protected static void toggleBugDisplay(Page pg, final BugRef ref) {
        if (ref.getWindow() != null) {
            ref.getWindow().remove();
            ref.setWindow(null);
            return;
        }
        FloatingWindow fw = FloatingWindow.create(pg.getBody(), "Problem report", false);
        ref.setWindow(fw);
        fw.setOnClose(new IWindowClosed(){

            @Override
            public void closed(@Nonnull String closeReason) throws Exception {
                ref.setWindow(null);
                DefaultBugListener.clearMessages(ref);
            }
        });
        ArrayList<BugItem> list = new ArrayList<BugItem>(ref.getBugList());
        Collections.sort(list, new Comparator<BugItem>(){

            @Override
            public int compare(BugItem a, BugItem b) {
                long res = a.getTimestamp().getTime() - b.getTimestamp().getTime();
                if (res == 0L) {
                    return b.getNumber() - a.getNumber();
                }
                return res < 0L ? 1 : -1;
            }
        });
        Table tbl = new Table();
        fw.add(tbl);
        TBody b = new TBody();
        tbl.add(b);
        for (int i = 0; i < list.size() && i < 20; ++i) {
            BugItem bi = (BugItem)list.get(i);
            ItemPnl p = new ItemPnl(bi);
            b.add(p);
        }
    }

    private static class ItemPnl
    extends TR {
        private BugItem m_bi;
        private TD m_maintd;
        private Div m_detail;
        private Img m_clickimg;

        public ItemPnl(BugItem bi) {
            this.m_bi = bi;
        }

        @Override
        public void createContent() throws Exception {
            TD td = this.addCell();
            td.setVerticalAlign(VerticalAlignType.TOP);
            this.m_clickimg = new Img("THEME/xdt-collapsed.png");
            td.add(this.m_clickimg);
            this.m_clickimg.setAlign(ImgAlign.LEFT);
            this.m_clickimg.setClicked(new IClicked<Img>(){

                @Override
                public void clicked(@Nonnull Img clickednode) throws Exception {
                    this.toggle();
                }
            });
            td = this.addCell();
            Div ttl = new Div();
            td.add(ttl);
            List<NodeBase> formattedMsg = this.m_bi.getFormattedMsg();
            if (formattedMsg == null) {
                DomUtil.renderHtmlString(ttl, this.m_bi.getMessage() + " [" + this.m_bi.getNumber() + "]");
            } else {
                for (NodeBase nb : formattedMsg) {
                    ttl.add(nb);
                }
            }
            ttl.setCssClass("ui-bug-msg");
            this.m_maintd = td;
        }

        protected void toggle() {
            if (null != this.m_detail) {
                this.m_detail.remove();
                this.m_detail = null;
                this.m_clickimg.setSrc("THEME/xdt-collapsed.png");
                return;
            }
            this.m_clickimg.setSrc("THEME/xdt-expanded.png");
            this.m_detail = new Div();
            this.m_maintd.add(this.m_detail);
            this.m_detail.setCssClass("ui-bug-stk");
            StringBuilder sb = new StringBuilder();
            StringTool.strStacktraceFiltered((Appendable)sb, (Throwable)this.m_bi.getLocation(), (String[])PRESET, (String[])ENDSET, (int)40);
            this.m_detail.setText(sb.toString());
        }
    }

    private static class BugRef {
        private List<BugItem> m_bugList = new ArrayList<BugItem>();
        private NodeBase m_indicator;
        private Span m_countNode;
        private Img m_image;
        private int m_lastCount;
        private FloatingWindow m_window;

        public NodeBase getIndicator() {
            return this.m_indicator;
        }

        public void setIndicator(NodeBase indicator, Span countNode, Img image) {
            this.m_indicator = indicator;
            this.m_countNode = countNode;
            this.m_image = image;
        }

        public Span getCountNode() {
            return this.m_countNode;
        }

        public List<BugItem> getBugList() {
            return this.m_bugList;
        }

        public Img getImage() {
            return this.m_image;
        }

        public int getLastCount() {
            return this.m_lastCount;
        }

        public void setLastCount(int lastCount) {
            this.m_lastCount = lastCount;
        }

        public FloatingWindow getWindow() {
            return this.m_window;
        }

        public void setWindow(FloatingWindow window) {
            this.m_window = window;
        }
    }
}

