/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.db;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.domui.component.meta.impl.PathPropertyMetaModel;
import to.etc.domui.util.compare.StringLikeSearchMatchUtil;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.qsql.QQuerySyntaxException;
import to.etc.webapp.query.QBetweenNode;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QExistsSubquery;
import to.etc.webapp.query.QLiteral;
import to.etc.webapp.query.QMultiNode;
import to.etc.webapp.query.QMultiSelection;
import to.etc.webapp.query.QNodeVisitor;
import to.etc.webapp.query.QNodeVisitorBase;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QOrder;
import to.etc.webapp.query.QPropertyComparison;
import to.etc.webapp.query.QPropertyIn;
import to.etc.webapp.query.QPropertySelection;
import to.etc.webapp.query.QSelection;
import to.etc.webapp.query.QSelectionColumn;
import to.etc.webapp.query.QSelectionItem;
import to.etc.webapp.query.QSelectionSubquery;
import to.etc.webapp.query.QUnaryNode;
import to.etc.webapp.query.QUnaryProperty;

public class CriteriaMatchingVisitor<T>
extends QNodeVisitorBase {
    @Nonnull
    private T m_instance;
    @Nonnull
    private ClassMetaModel m_cmm;
    @Nullable
    StringLikeSearchMatchUtil m_likeCompare;
    private boolean m_lastResult;
    private static final Class<?>[] ORDERS = new Class[]{Byte.class, Byte.TYPE, Short.class, Short.TYPE, Character.class, Character.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, BigInteger.class, null, BigDecimal.class, null, String.class, null};

    public CriteriaMatchingVisitor(@Nonnull T instance, @Nonnull ClassMetaModel cmm) {
        this.m_instance = instance;
        this.m_cmm = cmm;
    }

    public boolean isMatching() {
        return this.m_lastResult;
    }

    public void setInstance(@Nonnull T instance) {
        this.m_instance = instance;
        this.m_lastResult = true;
    }

    public void visitPropertyComparison(@Nonnull QPropertyComparison n) throws Exception {
        Class<?> valc;
        QOperatorNode rhs = n.getExpr();
        String name = n.getProperty();
        QLiteral l = null;
        if (rhs.getOperation() != QOperation.LITERAL) {
            throw new IllegalStateException("Unknown operands to " + n.getOperation() + ": " + name + " and " + rhs.getOperation());
        }
        l = (QLiteral)rhs;
        this.m_lastResult = false;
        PropertyMetaModel<?> pmm = this.parseSubCriteria(name);
        Object lit = l.getValue();
        Object val = pmm.getValue(this.m_instance);
        if (lit == null) {
            return;
        }
        if (val == null) {
            return;
        }
        Class<?> litc = lit.getClass();
        if (litc != (valc = val.getClass())) {
            Class<?> endtype = this.getPromoted(litc, valc);
            if (null == endtype) {
                throw new QQuerySyntaxException("Cannot compare property " + n.getProperty() + " of type " + valc + " with a " + litc);
            }
            if (endtype != litc) {
                lit = RuntimeConversions.convertTo((Object)lit, endtype);
            }
            if (endtype != valc) {
                val = RuntimeConversions.convertTo(val, endtype);
            }
        }
        switch (n.getOperation()) {
            default: {
                break;
            }
            case LIKE: {
                this.m_lastResult = this.getLikeCompare().compareLike(val.toString(), lit.toString());
                return;
            }
            case ILIKE: {
                this.m_lastResult = this.getLikeCompare().compareLike(val.toString().toLowerCase(), lit.toString().toLowerCase());
                return;
            }
            case EQ: {
                this.m_lastResult = val.equals(lit);
                return;
            }
            case NE: {
                this.m_lastResult = !val.equals(lit);
                return;
            }
        }
        if (!(val instanceof Comparable)) {
            throw new QQuerySyntaxException("Cannot compare (" + n.getOperation() + ") property " + n.getProperty() + " of type " + valc + ": the class " + val.getClass().getName() + " does not implement Comparable");
        }
        int res = ((Comparable)val).compareTo(lit);
        switch (n.getOperation()) {
            default: {
                throw new IllegalStateException("Unexpected operation: " + n.getOperation());
            }
            case GT: {
                this.m_lastResult = res > 0;
                break;
            }
            case GE: {
                this.m_lastResult = res >= 0;
            }
            case LT: {
                this.m_lastResult = res < 0;
                break;
            }
            case LE: {
                this.m_lastResult = res <= 0;
            }
        }
    }

    public void visitPropertyIn(@Nonnull QPropertyIn n) throws Exception {
        Object val;
        QOperatorNode rhs = n.getExpr();
        String name = n.getProperty();
        List valueList = null;
        if (rhs.getOperation() == QOperation.LITERAL && (val = ((QLiteral)rhs).getValue()) instanceof List) {
            valueList = (List)val;
        }
        if (valueList == null) {
            throw new IllegalStateException("Unknown operands to " + n.getOperation() + ": " + name + " and " + rhs.getOperation());
        }
        this.m_lastResult = false;
        PropertyMetaModel<?> pmm = this.parseSubCriteria(name);
        Object instanceValue = pmm.getValue(this.m_instance);
        if (instanceValue == null) {
            return;
        }
        for (Object value : valueList) {
            if (!this.valueMatches(instanceValue, value, n.getProperty())) continue;
            this.m_lastResult = true;
            return;
        }
        this.m_lastResult = false;
    }

    private boolean valueMatches(Object instanceValue, Object wantedValue, String property) {
        Class<?> instType;
        Class<?> wantedType = wantedValue.getClass();
        if (wantedType != (instType = instanceValue.getClass())) {
            Class<?> endtype = this.getPromoted(wantedType, instType);
            if (null == endtype) {
                throw new QQuerySyntaxException("Cannot compare property " + property + " of type " + instType + " with a " + wantedType);
            }
            if (endtype != wantedType) {
                wantedValue = RuntimeConversions.convertTo((Object)wantedValue, endtype);
            }
            if (endtype != instType) {
                instanceValue = RuntimeConversions.convertTo((Object)instanceValue, endtype);
            }
        }
        return instanceValue.equals(wantedValue);
    }

    @Nullable
    private Class<?> getPromoted(@Nonnull Class<?> litc, @Nonnull Class<?> valc) {
        if (litc == valc) {
            return litc;
        }
        int lito = this.getPromoOrder(litc);
        int valo = this.getPromoOrder(valc);
        if (lito == -1 || valo == -1) {
            return null;
        }
        return lito > valo ? litc : valc;
    }

    private int getPromoOrder(Class<?> litc) {
        for (int i = 0; i < ORDERS.length; ++i) {
            if (ORDERS[i] != litc) continue;
            return i / 2;
        }
        return -1;
    }

    public void visitUnaryNode(@Nonnull QUnaryNode n) throws Exception {
        switch (n.getOperation()) {
            default: {
                break;
            }
            case NOT: {
                n.getNode().visit((QNodeVisitor)this);
                this.m_lastResult = !this.m_lastResult;
                return;
            }
        }
        throw new IllegalStateException("Unsupported UNARY operation: " + n.getOperation());
    }

    public void visitUnaryProperty(@Nonnull QUnaryProperty n) throws Exception {
        String name = n.getProperty();
        PropertyMetaModel<?> pmm = this.parseSubCriteria(n.getProperty());
        Object val = pmm.getValue(this.m_instance);
        switch (n.getOperation()) {
            default: {
                throw new IllegalStateException("Unsupported UNARY operation: " + n.getOperation());
            }
            case ISNOTNULL: {
                this.m_lastResult = val != null;
                break;
            }
            case ISNULL: {
                this.m_lastResult = val == null;
            }
        }
    }

    @Nonnull
    private PropertyMetaModel<?> parseSubCriteria(@Nonnull String property) {
        PropertyMetaModel<?> pmm = this.m_cmm.getProperty(property);
        if (pmm instanceof PathPropertyMetaModel) {
            PathPropertyMetaModel m = (PathPropertyMetaModel)pmm;
            for (PropertyMetaModel<?> pm : m.getAccessPath()) {
                if (pm.getRelationType() != PropertyRelationType.DOWN) continue;
                throw new QQuerySyntaxException(property + ": contains reference to a child property - use an exists subquery instead.");
            }
        }
        return pmm;
    }

    public void visitMulti(@Nonnull QMultiNode inn) throws Exception {
        boolean result = inn.getOperation() == QOperation.AND;
        block4: for (QOperatorNode n : inn.getChildren()) {
            n.visit((QNodeVisitor)this);
            switch (inn.getOperation()) {
                default: {
                    throw new IllegalStateException("Unexpected operation: " + inn.getOperation());
                }
                case AND: {
                    if (result = result && this.m_lastResult) continue block4;
                    this.m_lastResult = false;
                    return;
                }
                case OR: 
            }
            if (!(result = result || this.m_lastResult)) continue;
            this.m_lastResult = true;
            return;
        }
        this.m_lastResult = result;
    }

    public void visitBetween(@Nonnull QBetweenNode n) throws Exception {
        if (n.getA().getOperation() != QOperation.LITERAL || n.getB().getOperation() != QOperation.LITERAL) {
            throw new IllegalStateException("Expecting literals as 2nd and 3rd between parameter");
        }
        QLiteral lita = (QLiteral)n.getA();
        QLiteral litb = (QLiteral)n.getB();
        String name = n.getProp();
        this.m_lastResult = false;
        PropertyMetaModel<?> pmm = this.parseSubCriteria(n.getProp());
        Object val = pmm.getValue(this.m_instance);
        if (val == null) {
            return;
        }
        Object av = lita.getValue();
        Object bv = litb.getValue();
        if (av == null) {
            throw new QQuerySyntaxException("Second 'between' parameter is null in " + n);
        }
        if (bv == null) {
            throw new QQuerySyntaxException("Third 'between' parameter is null in " + n);
        }
        Class<?> valc = val.getClass();
        Class<?> ac = av.getClass();
        Class<?> bc = bv.getClass();
        if (ac != valc || bc != valc) {
            Class<?> endtype = this.getPromoted(valc, ac);
            if (endtype == null) {
                throw new QQuerySyntaxException("Between of property " + n.getProp() + " of type " + valc + " with values " + ac + " and " + bc + " is not valid");
            }
            if ((endtype = this.getPromoted(endtype, bc)) == null) {
                throw new QQuerySyntaxException("Between of property " + n.getProp() + " of type " + valc + " with values " + ac + " and " + bc + " is not valid");
            }
            if (endtype != valc) {
                val = RuntimeConversions.convertTo(val, endtype);
            }
            if (endtype != ac) {
                av = RuntimeConversions.convertTo((Object)av, endtype);
            }
            if (endtype != bc) {
                bv = RuntimeConversions.convertTo((Object)bv, endtype);
            }
        }
        if (!(val instanceof Comparable)) {
            throw new QQuerySyntaxException("Between of property " + n.getProp() + " of promoted type " + val.getClass() + " must implement Comparable.");
        }
        Comparable c = (Comparable)val;
        int ra = c.compareTo(av);
        if (ra < 0) {
            this.m_lastResult = false;
            return;
        }
        int rb = c.compareTo(bv);
        if (rb > 0) {
            this.m_lastResult = false;
            return;
        }
        this.m_lastResult = true;
    }

    public void visitSelection(@Nonnull QSelection<?> s) throws Exception {
        this.m_lastResult = true;
        throw new IllegalStateException("Selection not implemented");
    }

    public void visitCriteria(@Nonnull QCriteria<?> qc) throws Exception {
        this.m_lastResult = true;
        super.visitCriteria(qc);
    }

    public void visitSelectionColumns(@Nonnull QSelection<?> s) throws Exception {
        throw new IllegalStateException("Selection not implemented");
    }

    public void visitOrderList(@Nonnull List<QOrder> orderlist) throws Exception {
    }

    public void visitOrder(@Nonnull QOrder o) throws Exception {
        throw new IllegalStateException("Order: not implemented");
    }

    public void visitPropertySelection(@Nonnull QPropertySelection n) throws Exception {
        throw new IllegalStateException("Selection not implemented");
    }

    public void visitSelectionColumn(@Nonnull QSelectionColumn n) throws Exception {
        throw new IllegalStateException("Selection not implemented");
    }

    public void visitSelectionItem(@Nonnull QSelectionItem n) throws Exception {
        throw new IllegalStateException("Selection not implemented");
    }

    public void visitMultiSelection(@Nonnull QMultiSelection n) throws Exception {
        throw new IllegalStateException("Selection not implemented");
    }

    public void visitExistsSubquery(@Nonnull QExistsSubquery<?> q) throws Exception {
        throw new IllegalStateException("'exists' has no meaning here");
    }

    public void visitSelectionSubquery(@Nonnull QSelectionSubquery n) throws Exception {
        throw new IllegalStateException("'subselection' has no meaning here");
    }

    @Nonnull
    public StringLikeSearchMatchUtil getLikeCompare() {
        StringLikeSearchMatchUtil likeCompare = this.m_likeCompare;
        if (null == likeCompare) {
            likeCompare = this.m_likeCompare = new StringLikeSearchMatchUtil();
        }
        return likeCompare;
    }
}

